/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsat.scheduler;

import dispatching.Attribute;
import dispatching.Dispatch;
import dispatching.HasUserAttributes;
import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import lsat_graph.DispatchGraph;
import org.eclipse.emf.common.util.EMap;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.lsat.common.graph.directed.DirectedGraph;
import org.eclipse.lsat.common.graph.directed.Node;
import org.eclipse.lsat.common.scheduler.graph.Task;
import org.eclipse.lsat.scheduler.CollectedScheduleData;

public class CsvWriter {
    private static final String NL = System.lineSeparator();

    private CsvWriter() {
    }

    public static <T extends Task> void write(String name, Writer out, Map<T, CollectedScheduleData> results) throws IOException {
        CsvWriter.writeHeader(name, out, results.keySet());
        CsvWriter.writeData(out, results.values());
    }

    private static <T extends Task> void writeHeader(String name, Writer out, Collection<T> scheduledTasks) throws IOException {
        out.append("# Dispatch sequence ").append(name).append(NL);
        out.append("#TASKS").append(NL);
        Iterator<T> iter = scheduledTasks.iterator();
        int nodeIndex = 0;
        while (nodeIndex < scheduledTasks.size()) {
            Task task = (Task)iter.next();
            Map<String, String> attr = CsvWriter.getUserAttributes(task);
            if (nodeIndex == 0) {
                List<String> metaHeader = List.of("nodeIndex", "task", "type");
                String metaHeaderAsStream = Stream.concat(metaHeader.stream(), attr.keySet().stream()).collect(Collectors.joining(",", "## ", NL));
                out.append(metaHeaderAsStream);
            }
            out.append(Stream.concat(Stream.of(Integer.toString(nodeIndex), task.getName(), task.eClass().getName()), attr.values().stream()).collect(Collectors.joining(",", "## ", NL)));
            ++nodeIndex;
        }
        out.append("#DATA").append(NL);
        List<String> header = List.of("step", "nodeIndex", "start time", "duration", "critical");
        String headerAsStream = header.stream().collect(Collectors.joining(",", "", NL));
        out.append(headerAsStream);
    }

    private static void writeData(Writer out, Collection<CollectedScheduleData> collectedData) throws IOException {
        if (collectedData.isEmpty()) {
            return;
        }
        int sample = 0;
        while (sample < collectedData.iterator().next().getSampleLength()) {
            Iterator<CollectedScheduleData> iter = collectedData.iterator();
            int nodeIndex = 0;
            while (nodeIndex < collectedData.size()) {
                CollectedScheduleData c = iter.next();
                out.append(String.join((CharSequence)",", Integer.toString(sample), Integer.toString(nodeIndex), Double.toString(c.startTime[sample]), Double.toString(c.duration[sample]), c.critical[sample] != 1.0 ? "0" : "1")).append(NL);
                ++nodeIndex;
            }
            ++sample;
        }
    }

    private static <T extends Task> Map<String, String> getUserAttributes(T task) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        Dispatch dispatch = CsvWriter.getDispatch(task);
        EMap userAttributes = null;
        if (dispatch != null) {
            userAttributes = dispatch.getUserAttributes();
        }
        if (userAttributes != null) {
            CsvWriter.addUserAttributes((EObject)dispatch, map);
        }
        return map;
    }

    private static <T extends Node> Dispatch getDispatch(T node) {
        DirectedGraph graph = node.getGraph();
        if (graph instanceof DispatchGraph) {
            DispatchGraph dGraph = (DispatchGraph)graph;
            return dGraph.getDispatch();
        }
        return null;
    }

    private static void addUserAttributes(EObject object, Map<String, String> map) {
        if (object != null) {
            CsvWriter.addUserAttributes(object.eContainer(), map);
        }
        if (object instanceof HasUserAttributes) {
            HasUserAttributes hasUserAttributes = (HasUserAttributes)object;
            hasUserAttributes.getUserAttributes().forEach(e -> {
                String string = map.put(((Attribute)e.getKey()).getName(), (String)e.getValue());
            });
        }
    }
}

