/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.outline;

import com.google.common.collect.RangeMap;
import com.google.common.collect.TreeRangeMap;
import java.net.URI;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.DecorationOverlayIcon;
import org.eclipse.jface.viewers.DelegatingStyledCellLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.jface.viewers.StyledString;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.outline.LSSymbolsContentProvider;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4e.ui.LSPImages;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.SymbolKind;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.navigator.ICommonContentExtensionSite;
import org.eclipse.ui.navigator.ICommonLabelProvider;

public class SymbolsLabelProvider
extends LabelProvider
implements ICommonLabelProvider,
DelegatingStyledCellLabelProvider.IStyledLabelProvider,
IEclipsePreferences.IPreferenceChangeListener {
    private Map<IResource, RangeMap<Integer, Integer>> severities = new HashMap<IResource, RangeMap<Integer, Integer>>();
    private final IResourceChangeListener listener = e -> {
        try {
            IResourceDelta delta = e.getDelta();
            if (delta != null) {
                delta.accept(d -> {
                    if (d.getMarkerDeltas().length > 0) {
                        this.severities.remove(d.getResource());
                    }
                    return true;
                });
            }
        }
        catch (CoreException ex) {
            LanguageServerPlugin.logError(ex);
        }
    };
    private Map<Image, Image[]> overlays = new HashMap<Image, Image[]>();
    private boolean showLocation;
    private boolean showKind;

    public SymbolsLabelProvider() {
        this(false, InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").getBoolean("org.eclipse.lsp4e.outline.showKind", false));
    }

    public SymbolsLabelProvider(boolean showLocation, boolean showKind) {
        this.showLocation = showLocation;
        this.showKind = showKind;
        InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").addPreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.listener);
    }

    public void dispose() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.listener);
        InstanceScope.INSTANCE.getNode("org.eclipse.lsp4e").removePreferenceChangeListener((IEclipsePreferences.IPreferenceChangeListener)this);
        super.dispose();
    }

    public Image getImage(Object element) {
        if (element == null) {
            return null;
        }
        if (element == LSSymbolsContentProvider.COMPUTING) {
            return JFaceResources.getImage((String)"WAITING_JOB");
        }
        if (element instanceof Throwable) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK");
        }
        if (element instanceof Either) {
            element = ((Either)element).get();
        }
        Image res = null;
        if (element instanceof SymbolInformation) {
            res = LSPImages.imageFromSymbolKind(((SymbolInformation)element).getKind());
        } else if (element instanceof DocumentSymbol) {
            res = LSPImages.imageFromSymbolKind(((DocumentSymbol)element).getKind());
        } else if (element instanceof SymbolsModel.DocumentSymbolWithFile) {
            res = LSPImages.imageFromSymbolKind(((SymbolsModel.DocumentSymbolWithFile)element).symbol.getKind());
        }
        IResource file = null;
        if (element instanceof SymbolInformation) {
            file = LSPEclipseUtils.findResourceFor(((SymbolInformation)element).getLocation().getUri());
        } else if (element instanceof SymbolsModel.DocumentSymbolWithFile) {
            file = ((SymbolsModel.DocumentSymbolWithFile)element).file;
        }
        if (file != null) {
            Range range = null;
            if (element instanceof SymbolInformation) {
                range = ((SymbolInformation)element).getLocation().getRange();
            } else if (element instanceof DocumentSymbol) {
                range = ((DocumentSymbol)element).getRange();
            } else if (element instanceof SymbolsModel.DocumentSymbolWithFile) {
                range = ((SymbolsModel.DocumentSymbolWithFile)element).symbol.getRange();
            }
            if (range != null) {
                try {
                    int maxSeverity;
                    IDocument doc = LSPEclipseUtils.getExistingDocument(file);
                    if (doc != null && (maxSeverity = this.getMaxSeverity(file, doc, range)) > 0) {
                        return this.getOverlay(res, maxSeverity);
                    }
                }
                catch (CoreException | BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        }
        return res;
    }

    protected int getMaxSeverity(@NonNull IResource resource, @NonNull IDocument doc, @NonNull Range range) throws CoreException, BadLocationException {
        RangeMap<Integer, Integer> severitiesForResource;
        if (!this.severities.containsKey(resource)) {
            this.refreshMarkersByLine(resource);
        }
        if ((severitiesForResource = this.severities.get(resource)) == null) {
            return -1;
        }
        int bound1 = LSPEclipseUtils.toOffset(range.getStart(), doc);
        int bound2 = LSPEclipseUtils.toOffset(range.getEnd(), doc);
        com.google.common.collect.Range subRange = com.google.common.collect.Range.closed((Comparable)Integer.valueOf(Math.min(bound1, bound2)), (Comparable)Integer.valueOf(bound2));
        return severitiesForResource.subRangeMap(subRange).asMapOfRanges().values().stream().max(Comparator.naturalOrder()).orElse(-1);
    }

    private void refreshMarkersByLine(IResource resource) throws CoreException {
        TreeRangeMap rangeMap = TreeRangeMap.create();
        Arrays.stream(resource.findMarkers("org.eclipse.core.resources.problemmarker", true, 0)).filter(marker -> marker.getAttribute("severity", -1) > 0).sorted(Comparator.comparingInt(marker -> marker.getAttribute("severity", -1))).forEach(arg_0 -> SymbolsLabelProvider.lambda$4((RangeMap)rangeMap, arg_0));
        this.severities.put(resource, (RangeMap<Integer, Integer>)rangeMap);
    }

    private Image getOverlay(Image res, int maxSeverity) {
        if (maxSeverity != 1 && maxSeverity != 2) {
            throw new IllegalArgumentException("Severity " + maxSeverity + " not supported.");
        }
        Image[] currentOverlays = this.overlays.computeIfAbsent(res, key -> new Image[2]);
        if (currentOverlays[maxSeverity - 1] == null) {
            String overlayId = null;
            if (maxSeverity == 2) {
                overlayId = "IMG_DEC_FIELD_ERROR";
            } else if (maxSeverity == 1) {
                overlayId = "IMG_DEC_FIELD_WARNING";
            }
            currentOverlays[maxSeverity - 1] = new DecorationOverlayIcon(res, PlatformUI.getWorkbench().getSharedImages().getImageDescriptor(overlayId), 2).createImage();
        }
        return currentOverlays[maxSeverity - 1];
    }

    public String getText(Object element) {
        return this.getStyledText(element).getString();
    }

    public StyledString getStyledText(Object element) {
        if (element == LSSymbolsContentProvider.COMPUTING) {
            return new StyledString(Messages.outline_computingSymbols);
        }
        if (element instanceof Throwable) {
            String message = ((Throwable)element).getMessage();
            if (message == null) {
                message = element.getClass().getName();
            }
            return new StyledString(message);
        }
        if (element instanceof LanguageServiceAccessor.LSPDocumentInfo) {
            return new StyledString(((LanguageServiceAccessor.LSPDocumentInfo)element).getFileUri().getPath());
        }
        StyledString res = new StyledString();
        if (element == null) {
            return res;
        }
        if (element instanceof Either) {
            element = ((Either)element).get();
        }
        String name = null;
        SymbolKind kind = null;
        URI location = null;
        if (element instanceof SymbolInformation) {
            name = ((SymbolInformation)element).getName();
            kind = ((SymbolInformation)element).getKind();
            try {
                location = URI.create(((SymbolInformation)element).getLocation().getUri());
            }
            catch (IllegalArgumentException e) {
                LanguageServerPlugin.logError("Invalid URI: " + ((SymbolInformation)element).getLocation().getUri(), e);
            }
        } else if (element instanceof DocumentSymbol) {
            name = ((DocumentSymbol)element).getName();
            kind = ((DocumentSymbol)element).getKind();
        } else if (element instanceof SymbolsModel.DocumentSymbolWithFile) {
            name = ((SymbolsModel.DocumentSymbolWithFile)element).symbol.getName();
            kind = ((SymbolsModel.DocumentSymbolWithFile)element).symbol.getKind();
            IFile file = ((SymbolsModel.DocumentSymbolWithFile)element).file;
            if (file != null) {
                location = file.getLocationURI();
            }
        }
        if (name != null) {
            res.append(name, null);
        }
        if (this.showKind && kind != null) {
            res.append(" :", null);
            res.append(kind.toString(), StyledString.DECORATIONS_STYLER);
        }
        if (this.showLocation && location != null) {
            res.append(' ');
            res.append(location.getPath(), StyledString.QUALIFIER_STYLER);
        }
        return res;
    }

    public void restoreState(IMemento aMemento) {
    }

    public void saveState(IMemento aMemento) {
    }

    public String getDescription(Object anElement) {
        return null;
    }

    public void init(ICommonContentExtensionSite aConfig) {
    }

    public void preferenceChange(IEclipsePreferences.PreferenceChangeEvent event) {
        if (event.getKey().equals("org.eclipse.lsp4e.outline.showKind")) {
            this.showKind = Boolean.valueOf(event.getNewValue().toString());
            Object[] objectArray = this.getListeners();
            int n = objectArray.length;
            int n2 = 0;
            while (n2 < n) {
                Object listener = objectArray[n2];
                if (listener instanceof ILabelProviderListener) {
                    ((ILabelProviderListener)listener).labelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)this));
                }
                ++n2;
            }
        }
    }

    private static /* synthetic */ void lambda$4(RangeMap rangeMap, IMarker marker) {
        int start = marker.getAttribute("charStart", -1);
        int end = marker.getAttribute("charEnd", -1);
        if (end < start) {
            end = start;
        }
        int severity = marker.getAttribute("severity", -1);
        if (start != end) {
            com.google.common.collect.Range markerRange = com.google.common.collect.Range.closed((Comparable)Integer.valueOf(start), (Comparable)Integer.valueOf(end - 1));
            rangeMap.remove(markerRange);
            rangeMap.put(markerRange, (Object)severity);
        }
    }
}

