/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test;

import java.util.function.Supplier;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.lsp4e.LanguageServiceAccessor;
import org.eclipse.lsp4e.test.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.intro.IIntroPart;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;

public class AllCleanRule
extends TestWatcher {
    private final Supplier<ServerCapabilities> serverConfigurer;

    public AllCleanRule() {
        this.serverConfigurer = MockLanguageServer::defaultServerCapabilities;
    }

    public AllCleanRule(Supplier<ServerCapabilities> serverConfigurer) {
        this.serverConfigurer = serverConfigurer;
    }

    protected void starting(Description description) {
        super.starting(description);
        IIntroPart intro = PlatformUI.getWorkbench().getIntroManager().getIntro();
        if (intro != null) {
            PlatformUI.getWorkbench().getIntroManager().closeIntro(intro);
        }
        this.clear();
    }

    protected void finished(Description description) {
        this.clear();
        super.finished(description);
    }

    private void clear() {
        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().closeAllEditors(false);
        IProject[] iProjectArray = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = iProjectArray.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                project.delete(true, null);
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
            ++n2;
        }
        LanguageServiceAccessor.clearStartedServers();
        MockLanguageServer.reset(this.serverConfigurer);
        TestUtils.tearDown();
    }
}

