/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.debug.breakpoints;

import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.ILineBreakpoint;
import org.eclipse.debug.ui.actions.IToggleBreakpointsTarget;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.lsp4e.debug.breakpoints.DSPLineBreakpoint;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.part.MultiPageEditorPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class DSPBreakpointAdapter
implements IToggleBreakpointsTarget {
    public void toggleLineBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
        ITextEditor textEditor = this.getEditor(part);
        if (textEditor != null && (resource = (IResource)textEditor.getEditorInput().getAdapter(IResource.class)) != null) {
            ITextSelection textSelection = (ITextSelection)selection;
            int lineNumber = textSelection.getStartLine();
            IBreakpoint[] breakpoints = DebugPlugin.getDefault().getBreakpointManager().getBreakpoints("org.eclipse.lsp4e.debug.model");
            int i = 0;
            while (i < breakpoints.length) {
                IBreakpoint breakpoint = breakpoints[i];
                if (breakpoint instanceof ILineBreakpoint var10_11 && resource.equals((Object)breakpoint.getMarker().getResource()) && lineBreakpoint.getLineNumber() == lineNumber + 1) {
                    breakpoint.delete();
                    return;
                }
                ++i;
            }
            DSPLineBreakpoint lineBreakpoint = new DSPLineBreakpoint(resource, lineNumber + 1);
            DebugPlugin.getDefault().getBreakpointManager().addBreakpoint((IBreakpoint)lineBreakpoint);
        }
    }

    public boolean canToggleLineBreakpoints(IWorkbenchPart part, ISelection selection) {
        return true;
    }

    private ITextEditor getEditor(IWorkbenchPart part) {
        IWorkbenchPart iWorkbenchPart = part;
        if (iWorkbenchPart instanceof ITextEditor && (var2_3 = (ITextEditor)iWorkbenchPart) == (ITextEditor)var3_2) {
            return textEditor;
        }
        if (part instanceof MultiPageEditorPart var4_5 && ( instanceOfPatternExpressionValue = ((MultiPageEditorPart)part).getSelectedPage()) instanceof ITextEditor && (var5_7 = (ITextEditor) instanceOfPatternExpressionValue) == (ITextEditor) instanceOfPatternExpressionValue) {
            return textEditor;
        }
        return null;
    }

    public void toggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleMethodBreakpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }

    public void toggleWatchpoints(IWorkbenchPart part, ISelection selection) throws CoreException {
    }

    public boolean canToggleWatchpoints(IWorkbenchPart part, ISelection selection) {
        return false;
    }
}

