/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.command;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import org.eclipse.core.commands.Category;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.commands.IParameter;
import org.eclipse.core.commands.NotEnabledException;
import org.eclipse.core.commands.NotHandledException;
import org.eclipse.core.commands.ParameterType;
import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.NotDefinedException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.jface.text.IDocument;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.command.internal.CommandEventParameter;
import org.eclipse.lsp4j.Command;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.WorkspaceEdit;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.handlers.IHandlerService;

@Deprecated
public class CommandExecutor {
    private static final String LSP_COMMAND_CATEGORY_ID = "org.eclipse.lsp4e.commandCategory";
    private static final String LSP_COMMAND_PARAMETER_TYPE_ID = "org.eclipse.lsp4e.commandParameterType";
    private static final String LSP_PATH_PARAMETER_TYPE_ID = "org.eclipse.lsp4e.pathParameterType";

    @Deprecated(forRemoval=true)
    public static CompletableFuture<Object> executeCommand(@Nullable Command command, @Nullable IDocument document, @Nullable String languageServerId) {
        if (command != null && document != null) {
            return CommandExecutor.executeCommandClientSide(command, document);
        }
        return CompletableFuture.completedFuture(null);
    }

    public static CompletableFuture<Object> executeCommandClientSide(@NonNull Command command, @NonNull IDocument document) {
        CompletableFuture<Object> r;
        IPath path = LSPEclipseUtils.toPath(document);
        if (path == null) {
            path = ResourcesPlugin.getWorkspace().getRoot().getLocation();
        }
        if ((r = CommandExecutor.executeCommandClientSide(command, path)) != null) {
            return r;
        }
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri != null) {
            return CommandExecutor.executeFallbackClientSide(command, uri);
        }
        return CompletableFuture.completedFuture(null);
    }

    public static CompletableFuture<Object> executeCommandClientSide(@NonNull Command command, @NonNull IResource resource) {
        CompletableFuture<Object> r = CommandExecutor.executeCommandClientSide(command, resource.getFullPath());
        if (r != null) {
            return r;
        }
        URI uri = LSPEclipseUtils.toUri(resource);
        if (uri != null) {
            return CommandExecutor.executeFallbackClientSide(command, uri);
        }
        return CompletableFuture.completedFuture(null);
    }

    private static CompletableFuture<Object> executeCommandClientSide(@NonNull Command command, @Nullable IPath path) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        if (workbench == null) {
            return null;
        }
        ParameterizedCommand parameterizedCommand = CommandExecutor.createEclipseCoreCommand(command, path, workbench);
        if (parameterizedCommand == null) {
            return null;
        }
        @Nullable IHandlerService handlerService = (IHandlerService)workbench.getService(IHandlerService.class);
        if (handlerService == null) {
            return null;
        }
        try {
            CompletableFuture<Object> r = CompletableFuture.completedFuture(handlerService.executeCommand(parameterizedCommand, null));
            if (r != null) {
                return r;
            }
        }
        catch (ExecutionException | NotDefinedException e) {
            LanguageServerPlugin.logError(e);
        }
        catch (NotEnabledException | NotHandledException throwable) {
            // empty catch block
        }
        return null;
    }

    private static CompletableFuture<Object> executeFallbackClientSide(@NonNull Command command, @NonNull URI initialUri) {
        if (command.getArguments() != null) {
            WorkspaceEdit edit = CommandExecutor.createWorkspaceEdit(command.getArguments(), initialUri);
            LSPEclipseUtils.applyWorkspaceEdit(edit, command.getTitle());
            return CompletableFuture.completedFuture(null);
        }
        return null;
    }

    private static ParameterizedCommand createEclipseCoreCommand(@NonNull Command command, IPath context, @NonNull IWorkbench workbench) {
        String commandId = command.getCommand();
        @Nullable ICommandService commandService = (ICommandService)workbench.getService(ICommandService.class);
        if (commandService == null) {
            return null;
        }
        org.eclipse.core.commands.Command coreCommand = commandService.getCommand(commandId);
        if (!coreCommand.isDefined()) {
            ParameterType commandParamType = commandService.getParameterType(LSP_COMMAND_PARAMETER_TYPE_ID);
            ParameterType pathParamType = commandService.getParameterType(LSP_PATH_PARAMETER_TYPE_ID);
            Category category = commandService.getCategory(LSP_COMMAND_CATEGORY_ID);
            IParameter[] parameters = new IParameter[]{new CommandEventParameter(commandParamType, command.getTitle(), "org.eclipse.lsp4e.command.param"), new CommandEventParameter(pathParamType, command.getTitle(), "org.eclipse.lsp4e.path.param")};
            coreCommand.define(commandId, null, category, parameters);
        }
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put("org.eclipse.lsp4e.command.param", command);
        parameters.put("org.eclipse.lsp4e.path.param", context);
        ParameterizedCommand parameterizedCommand = ParameterizedCommand.generateCommand((org.eclipse.core.commands.Command)coreCommand, parameters);
        return parameterizedCommand;
    }

    private static WorkspaceEdit createWorkspaceEdit(List<Object> commandArguments, @NonNull URI initialUri) {
        WorkspaceEdit workspaceEdit = new WorkspaceEdit();
        HashMap<String, List> changes = new HashMap<String, List>();
        workspaceEdit.setChanges(changes);
        Pair currentEntry = new Pair(initialUri, new ArrayList());
        commandArguments.stream().flatMap(item -> {
            if (item instanceof List var1_2) {
                return list.stream();
            }
            return Collections.singleton(item).stream();
        }).forEach(arg -> {
            if (arg instanceof String var3_4) {
                changes.put(((URI)pair.key).toString(), (List)pair.value);
                IResource res = LSPEclipseUtils.findResourceFor((String)argString);
                if (res != null) {
                    pair.key = res.getLocationURI();
                    pair.value = new ArrayList();
                }
            } else {
                if (arg instanceof WorkspaceEdit res) {
                    changes.putAll(wsEdit.getChanges());
                } else {
                    if (arg instanceof TextEdit var9_9) {
                        ((List)pair.value).add(textEdit);
                    } else if (arg instanceof Map) {
                        Gson gson = new Gson();
                        TextEdit edit = (TextEdit)gson.fromJson(gson.toJson(arg), TextEdit.class);
                        if (edit != null) {
                            ((List)pair.value).add(edit);
                        }
                    } else {
                        if (arg instanceof JsonPrimitive gson) {
                            if (json.isString()) {
                                changes.put(((URI)pair.key).toString(), (List)pair.value);
                                IResource res = LSPEclipseUtils.findResourceFor(json.getAsString());
                                if (res != null) {
                                    pair.key = res.getLocationURI();
                                    pair.value = new ArrayList();
                                }
                            }
                        } else {
                            if (arg instanceof JsonArray res) {
                                Gson gson = new Gson();
                                jsonArray.forEach(elt -> {
                                    TextEdit edit = (TextEdit)gson.fromJson(gson.toJson(elt), TextEdit.class);
                                    if (edit != null) {
                                        ((List)pair.value).add(edit);
                                    }
                                });
                            } else {
                                if (arg instanceof JsonObject gson) {
                                    Gson gson = new Gson();
                                    WorkspaceEdit wEdit = (WorkspaceEdit)gson.fromJson((JsonElement)jsonObject, WorkspaceEdit.class);
                                    Map entries = wEdit.getChanges();
                                    if (wEdit != null && !entries.isEmpty()) {
                                        changes.putAll(entries);
                                    } else {
                                        TextEdit edit = (TextEdit)gson.fromJson((JsonElement)jsonObject, TextEdit.class);
                                        if (edit != null && edit.getRange() != null) {
                                            ((List)pair.value).add(edit);
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        });
        if (!((List)currentEntry.value).isEmpty()) {
            changes.put(((URI)currentEntry.key).toASCIIString(), (List)currentEntry.value);
        }
        return workspaceEdit;
    }

    private static final class Pair<K, V> {
        K key;
        V value;

        Pair(K key, V value) {
            this.key = key;
            this.value = value;
        }
    }
}

