/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.symbols;

import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.resources.IFile;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServerPlugin;
import org.eclipse.lsp4e.LanguageServerWrapper;
import org.eclipse.lsp4e.outline.LSSymbolsContentProvider;
import org.eclipse.lsp4e.outline.SymbolsModel;
import org.eclipse.lsp4e.ui.Messages;
import org.eclipse.lsp4j.DocumentSymbol;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.SymbolInformation;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;
import org.eclipse.ui.internal.navigator.NavigatorContentService;
import org.eclipse.ui.internal.navigator.NavigatorDecoratingLabelProvider;
import org.eclipse.ui.navigator.CommonViewerSorter;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.texteditor.ITextEditor;

public class LSPSymbolInFileDialog
extends PopupDialog {
    private final LSSymbolsContentProvider.OutlineViewerInput outlineViewerInput;
    private final ITextEditor textEditor;

    public LSPSymbolInFileDialog(@NonNull Shell parentShell, @NonNull ITextEditor textEditor, @NonNull IDocument document, @NonNull LanguageServerWrapper wrapper) {
        super(parentShell, 16, true, true, true, false, false, null, null);
        this.outlineViewerInput = new LSSymbolsContentProvider.OutlineViewerInput(document, wrapper, textEditor);
        this.textEditor = textEditor;
        this.create();
    }

    protected Control createDialogArea(Composite parent) {
        IFile documentFile = this.outlineViewerInput.documentFile;
        this.getShell().setText(NLS.bind((String)Messages.symbolsInFile, (Object)(documentFile == null ? null : documentFile.getName())));
        FilteredTree filteredTree = new FilteredTree(parent, 2048, new PatternFilter(), true, false);
        TreeViewer viewer = filteredTree.getViewer();
        viewer.setData("isQuickOutline", (Object)Boolean.TRUE);
        NavigatorContentService contentService = new NavigatorContentService("org.eclipse.lsp4e.outline", (StructuredViewer)viewer);
        filteredTree.addDisposeListener(ev -> contentService.dispose());
        ITreeContentProvider contentProvider = contentService.createCommonContentProvider();
        viewer.setContentProvider((IContentProvider)contentProvider);
        CommonViewerSorter sorter = new CommonViewerSorter();
        sorter.setContentService((INavigatorContentService)contentService);
        viewer.setComparator((ViewerComparator)sorter);
        viewer.setLabelProvider((IBaseLabelProvider)new NavigatorDecoratingLabelProvider(contentService.createCommonLabelProvider()));
        viewer.setUseHashlookup(true);
        AtomicBoolean isFirstSelectionEvent = new AtomicBoolean(true);
        viewer.addSelectionChangedListener(event -> {
            if (isFirstSelectionEvent.get()) {
                isFirstSelectionEvent.set(false);
                return;
            }
            IStructuredSelection selection = (IStructuredSelection)event.getSelection();
            if (selection.isEmpty()) {
                return;
            }
            Object item = selection.getFirstElement();
            if (item instanceof Either var5_6) {
                item = either.get();
            }
            Range range = null;
            if (item instanceof SymbolInformation var9_9) {
                range = symbolInformation.getLocation().getRange();
            } else {
                if (item instanceof DocumentSymbol var12_11) {
                    range = documentSymbol.getSelectionRange();
                } else {
                    if (item instanceof SymbolsModel.DocumentSymbolWithFile var15_13) {
                        range = documentSymbolWithFile.symbol.getSelectionRange();
                    }
                }
            }
            if (range != null) {
                try {
                    int offset = LSPEclipseUtils.toOffset(range.getStart(), this.outlineViewerInput.document);
                    int endOffset = LSPEclipseUtils.toOffset(range.getEnd(), this.outlineViewerInput.document);
                    this.textEditor.selectAndReveal(offset, endOffset - offset);
                }
                catch (BadLocationException e) {
                    LanguageServerPlugin.logError(e);
                }
            }
        });
        viewer.setInput((Object)this.outlineViewerInput);
        return filteredTree;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setSize(280, 300);
        Control control = (Control)this.textEditor.getAdapter(Control.class);
        if (control != null) {
            shell.setLocation(control.toDisplay(control.getBounds().width - shell.getSize().x, control.getLocation().y));
        }
    }
}

