/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.format;

import java.net.URI;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.VersionedEdits;
import org.eclipse.lsp4e.internal.DocumentUtil;
import org.eclipse.lsp4j.DocumentFormattingParams;
import org.eclipse.lsp4j.DocumentRangeFormattingParams;
import org.eclipse.lsp4j.FormattingOptions;
import org.eclipse.lsp4j.Position;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentIdentifier;
import org.eclipse.lsp4j.TextEdit;
import org.eclipse.lsp4j.jsonrpc.messages.Either;
import org.eclipse.ui.editors.text.EditorsUI;

public class LSPFormatter {
    public CompletableFuture<Optional<VersionedEdits>> requestFormatting(@NonNull IDocument document, @NonNull ITextSelection textSelection) throws BadLocationException {
        URI uri = LSPEclipseUtils.toUri(document);
        if (uri == null) {
            return CompletableFuture.completedFuture(Optional.empty());
        }
        LanguageServers.LanguageServerDocumentExecutor executor = (LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument(document).withFilter(LSPFormatter::supportsFormatting);
        FormattingOptions formatOptions = this.getFormatOptions();
        TextDocumentIdentifier docId = new TextDocumentIdentifier(uri.toString());
        DocumentRangeFormattingParams rangeParams = this.getRangeFormattingParams(document, textSelection, formatOptions, docId);
        DocumentFormattingParams params = this.getFullFormatParams(formatOptions, docId);
        long modificationStamp = DocumentUtil.getDocumentModificationStamp(document);
        return executor.computeFirst((w, ls) -> {
            ServerCapabilities capabilities = w.getServerCapabilities();
            if (LSPFormatter.isDocumentRangeFormattingSupported(capabilities) && (!LSPFormatter.isDocumentFormattingSupported(capabilities) || textSelection.getLength() != 0)) {
                return ls.getTextDocumentService().rangeFormatting(rangeParams).thenApply(edits -> new VersionedEdits(modificationStamp, (List<? extends TextEdit>)edits, document));
            }
            return ls.getTextDocumentService().formatting(params).thenApply(edits -> new VersionedEdits(modificationStamp, (List<? extends TextEdit>)edits, document));
        });
    }

    private DocumentFormattingParams getFullFormatParams(FormattingOptions formatOptions, TextDocumentIdentifier docId) {
        DocumentFormattingParams params = new DocumentFormattingParams();
        params.setTextDocument(docId);
        params.setOptions(formatOptions);
        return params;
    }

    private DocumentRangeFormattingParams getRangeFormattingParams(IDocument document, ITextSelection textSelection, FormattingOptions formatOptions, TextDocumentIdentifier docId) throws BadLocationException {
        DocumentRangeFormattingParams rangeParams = new DocumentRangeFormattingParams();
        rangeParams.setTextDocument(docId);
        rangeParams.setOptions(formatOptions);
        boolean fullFormat = textSelection.getLength() == 0;
        Position start = LSPEclipseUtils.toPosition(fullFormat ? 0 : textSelection.getOffset(), document);
        Position end = LSPEclipseUtils.toPosition(fullFormat ? document.getLength() : textSelection.getOffset() + textSelection.getLength(), document);
        rangeParams.setRange(new Range(start, end));
        return rangeParams;
    }

    private FormattingOptions getFormatOptions() {
        IPreferenceStore store = EditorsUI.getPreferenceStore();
        int tabWidth = store.getInt("tabWidth");
        boolean insertSpaces = store.getBoolean("spacesForTabs");
        return new FormattingOptions(tabWidth, insertSpaces);
    }

    private static boolean isDocumentRangeFormattingSupported(ServerCapabilities capabilities) {
        return LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getDocumentRangeFormattingProvider());
    }

    private static boolean isDocumentFormattingSupported(ServerCapabilities capabilities) {
        return LSPEclipseUtils.hasCapability((Either<Boolean, ? extends Object>)capabilities.getDocumentFormattingProvider());
    }

    public static boolean supportsFormatting(ServerCapabilities capabilities) {
        return LSPFormatter.isDocumentFormattingSupported(capabilities) || LSPFormatter.isDocumentRangeFormattingSupported(capabilities);
    }
}

