/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.operations.completion;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;

public final class CompletionProposalTools {
    private CompletionProposalTools() {
    }

    public static String getFilterFromDocument(IDocument document, int cursorOffset, String completionItemFilter, int completionInsertionOffset) throws BadLocationException {
        if (completionInsertionOffset >= cursorOffset) {
            return "";
        }
        int prefixToCursorLength = cursorOffset - completionInsertionOffset;
        String prefixToCursor = document.get(completionInsertionOffset, prefixToCursorLength);
        int i = 0;
        while (i < prefixToCursor.length()) {
            if (!CompletionProposalTools.isSubstringFoundOrderedInString(prefixToCursor.substring(prefixToCursorLength - i - 1, prefixToCursorLength), completionItemFilter)) break;
            ++i;
        }
        return prefixToCursor.substring(prefixToCursor.length() - i);
    }

    public static boolean isSubstringFoundOrderedInString(String subString, String string) {
        int lastIndex = 0;
        subString = subString.toLowerCase();
        string = string.toLowerCase();
        char[] cArray = subString.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            Character c = Character.valueOf(cArray[n2]);
            int index = string.indexOf(c.charValue(), lastIndex);
            if (index < 0) {
                return false;
            }
            lastIndex = index + 1;
            ++n2;
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public static int getCategoryOfFilterMatch(String documentFilter, String completionFilter) {
        if (documentFilter.isEmpty()) {
            return 5;
        }
        documentFilter = documentFilter.toLowerCase();
        completionFilter = completionFilter.toLowerCase();
        subIndex = completionFilter.indexOf(documentFilter);
        topCategory = 5;
        if (subIndex != -1) ** GOTO lbl11
        return CompletionProposalTools.isSubstringFoundOrderedInString(documentFilter, completionFilter) != false ? 4 : 5;
        while ((topCategory = subIndex > 0 && Character.isLetterOrDigit(completionFilter.charAt(subIndex - 1)) != false ? Math.min(topCategory, 3) : (subIndex + documentFilter.length() < completionFilter.length() - 1 && Character.isLetterOrDigit(completionFilter.charAt(subIndex + documentFilter.length() + 1)) != false ? Math.min(topCategory, 2) : 1)) != 1) {
            subIndex = completionFilter.indexOf(documentFilter, subIndex + 1);
lbl11:
            // 2 sources

            if (subIndex != -1) continue;
        }
        return topCategory;
    }

    public static int getScoreOfFilterMatch(String documentFilter, String completionFilter) {
        documentFilter = documentFilter.toLowerCase();
        completionFilter = completionFilter.toLowerCase();
        return CompletionProposalTools.getScoreOfFilterMatchHelper(0, documentFilter, completionFilter);
    }

    private static int getScoreOfFilterMatchHelper(int prefixLength, String documentFilter, String completionFilter) {
        if (documentFilter == null || documentFilter.isEmpty()) {
            return 0;
        }
        char searchChar = documentFilter.charAt(0);
        int i = completionFilter.indexOf(searchChar);
        if (i == -1) {
            return -1;
        }
        if (documentFilter.length() == 1) {
            return i + prefixLength;
        }
        int matchLength = CompletionProposalTools.lengthOfPrefixMatch(documentFilter, completionFilter.substring(i));
        if (matchLength == documentFilter.length()) {
            return i + prefixLength;
        }
        int bestScore = i + CompletionProposalTools.getScoreOfFilterMatchHelper(prefixLength + i + matchLength, documentFilter.substring(matchLength), completionFilter.substring(i + matchLength));
        i = completionFilter.indexOf(searchChar, i + 1);
        while (i != -1) {
            matchLength = CompletionProposalTools.lengthOfPrefixMatch(documentFilter, completionFilter.substring(i));
            if (matchLength == documentFilter.length()) {
                return i + prefixLength;
            }
            int score = i + CompletionProposalTools.getScoreOfFilterMatchHelper(prefixLength + i + matchLength, documentFilter.substring(matchLength), completionFilter.substring(i + matchLength));
            if (score == i - 1) break;
            bestScore = Math.min(bestScore, score);
            i = completionFilter.indexOf(searchChar, i + 1);
        }
        return prefixLength + bestScore;
    }

    private static int lengthOfPrefixMatch(String first, String second) {
        int i = 0;
        while (i < Math.min(first.length(), second.length())) {
            if (first.charAt(i) != second.charAt(i)) break;
            ++i;
        }
        return i;
    }
}

