/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4e.test.edit;

import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;
import java.util.function.Predicate;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.lsp4e.LSPEclipseUtils;
import org.eclipse.lsp4e.LanguageServers;
import org.eclipse.lsp4e.test.utils.AbstractTestWithProject;
import org.eclipse.lsp4e.test.utils.TestUtils;
import org.eclipse.lsp4e.tests.mock.MockLanguageServer;
import org.eclipse.lsp4e.ui.UI;
import org.eclipse.lsp4j.DidChangeTextDocumentParams;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4j.ServerCapabilities;
import org.eclipse.lsp4j.TextDocumentContentChangeEvent;
import org.eclipse.lsp4j.TextDocumentSyncKind;
import org.eclipse.lsp4j.TextDocumentSyncOptions;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.ide.IDE;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class DocumentDidChangeTest
extends AbstractTestWithProject {
    @Test
    public void testIncrementalSync() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Incremental);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)viewer.getDocument()).withFilter((Predicate)new Predicate<ServerCapabilities>(){

            @Override
            public boolean test(ServerCapabilities t) {
                TextDocumentSyncKind syncKind = DocumentDidChangeTest.this.getDocumentSyncKind(t);
                Assertions.assertEquals((Object)TextDocumentSyncKind.Incremental, (Object)syncKind);
                return true;
            }
        })).anyMatching();
        viewer.getDocument().replace(0, 0, "Hello");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(1));
        DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(0);
        Assertions.assertNotNull((Object)lastChange.getContentChanges());
        Assertions.assertEquals((int)1, (int)lastChange.getContentChanges().size());
        TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Range range = change0.getRange();
        Assertions.assertNotNull((Object)range);
        Assertions.assertEquals((int)0, (int)range.getStart().getLine());
        Assertions.assertEquals((int)0, (int)range.getStart().getCharacter());
        Assertions.assertEquals((int)0, (int)range.getEnd().getLine());
        Assertions.assertEquals((int)0, (int)range.getEnd().getCharacter());
        Assertions.assertEquals((Integer)0, (Integer)change0.getRangeLength());
        Assertions.assertEquals((Object)"Hello", (Object)change0.getText());
        viewer.getDocument().replace(5, 0, " ");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(2));
        lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(1);
        Assertions.assertNotNull((Object)lastChange.getContentChanges());
        Assertions.assertEquals((int)1, (int)lastChange.getContentChanges().size());
        change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        range = change0.getRange();
        Assertions.assertNotNull((Object)range);
        Assertions.assertEquals((int)0, (int)range.getStart().getLine());
        Assertions.assertEquals((int)5, (int)range.getStart().getCharacter());
        Assertions.assertEquals((int)0, (int)range.getEnd().getLine());
        Assertions.assertEquals((int)5, (int)range.getEnd().getCharacter());
        Assertions.assertEquals((Integer)0, (Integer)change0.getRangeLength());
        Assertions.assertEquals((Object)" ", (Object)change0.getText());
        viewer.getDocument().replace(0, 5, "Hallo");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(3));
        lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(2);
        Assertions.assertNotNull((Object)lastChange.getContentChanges());
        Assertions.assertEquals((int)1, (int)lastChange.getContentChanges().size());
        change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        range = change0.getRange();
        Assertions.assertNotNull((Object)range);
        Assertions.assertEquals((int)0, (int)range.getStart().getLine());
        Assertions.assertEquals((int)0, (int)range.getStart().getCharacter());
        Assertions.assertEquals((int)0, (int)range.getEnd().getLine());
        Assertions.assertEquals((int)5, (int)range.getEnd().getCharacter());
        Assertions.assertEquals((Integer)5, (Integer)change0.getRangeLength());
        Assertions.assertEquals((Object)"Hallo", (Object)change0.getText());
    }

    @Test
    public void testIncrementalSync_deleteLastLine() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Incremental);
        String multiLineText = "line1\nline2\nline3\n";
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "line1\nline2\nline3\n");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)viewer.getDocument()).withFilter((Predicate)new Predicate<ServerCapabilities>(){

            @Override
            public boolean test(ServerCapabilities t) {
                Assertions.assertEquals((Object)TextDocumentSyncKind.Incremental, (Object)DocumentDidChangeTest.this.getDocumentSyncKind(t));
                return true;
            }
        })).anyMatching();
        viewer.getDocument().replace("line1\nline2\n".length(), "line3\n".length(), "");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(1));
        DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(0);
        Assertions.assertNotNull((Object)lastChange.getContentChanges());
        Assertions.assertEquals((int)1, (int)lastChange.getContentChanges().size());
        TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Range range = change0.getRange();
        Assertions.assertNotNull((Object)range);
        Assertions.assertEquals((int)2, (int)range.getStart().getLine());
        Assertions.assertEquals((int)0, (int)range.getStart().getCharacter());
        Assertions.assertEquals((int)3, (int)range.getEnd().getLine());
        Assertions.assertEquals((int)0, (int)range.getEnd().getCharacter());
        Assertions.assertEquals((Integer)6, (Integer)change0.getRangeLength());
        Assertions.assertEquals((Object)"", (Object)change0.getText());
    }

    @Test
    public void testIncrementalEditOrdering() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Incremental);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        StyledText text = viewer.getTextWidget();
        int i = 0;
        while (i < 500) {
            text.append(i + "\n");
            ++i;
        }
        TestUtils.waitForAndAssertCondition(10000, TestUtils.numberOfChangesIs(500));
        List changes = MockLanguageServer.INSTANCE.getDidChangeEvents();
        int i2 = 0;
        while (i2 < 500) {
            String delta = ((TextDocumentContentChangeEvent)((DidChangeTextDocumentParams)changes.get(i2)).getContentChanges().get(0)).getText();
            Assertions.assertEquals((Object)(i2 + "\n"), (Object)delta);
            ++i2;
        }
    }

    @Test
    public void testFullSync() throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Full);
        IFile testFile = TestUtils.createUniqueTestFile(this.project, "");
        ITextViewer viewer = TestUtils.openTextViewer(testFile);
        ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)viewer.getDocument()).withFilter((Predicate)new Predicate<ServerCapabilities>(){

            @Override
            public boolean test(ServerCapabilities t) {
                Assertions.assertEquals((Object)TextDocumentSyncKind.Full, (Object)DocumentDidChangeTest.this.getDocumentSyncKind(t));
                return true;
            }
        })).anyMatching();
        String text = "Hello";
        viewer.getDocument().replace(0, 0, "Hello");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(1));
        DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(0);
        Assertions.assertNotNull((Object)lastChange.getContentChanges());
        Assertions.assertEquals((int)1, (int)lastChange.getContentChanges().size());
        TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Assertions.assertEquals((Object)"Hello", (Object)change0.getText());
        viewer.getDocument().replace(5, 0, " World");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(2));
        lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(1);
        Assertions.assertNotNull((Object)lastChange.getContentChanges());
        Assertions.assertEquals((int)1, (int)lastChange.getContentChanges().size());
        change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Assertions.assertEquals((Object)"Hello World", (Object)change0.getText());
    }

    @Test
    public void testFullSyncExternalFile(@TempDir Path tempDir) throws Exception {
        MockLanguageServer.INSTANCE.getInitializeResult().getCapabilities().setTextDocumentSync(TextDocumentSyncKind.Full);
        Path file = Files.createFile(tempDir.resolve("testFullSyncExternalFile.lspt"), new FileAttribute[0]);
        IEditorPart editor = IDE.openEditorOnFileStore((IWorkbenchPage)UI.getActivePage(), (IFileStore)EFS.getStore((URI)file.toUri()));
        ITextViewer viewer = LSPEclipseUtils.getTextViewer((IEditorPart)editor);
        ((LanguageServers.LanguageServerDocumentExecutor)LanguageServers.forDocument((IDocument)viewer.getDocument()).withFilter((Predicate)new Predicate<ServerCapabilities>(){

            @Override
            public boolean test(ServerCapabilities t) {
                Assertions.assertEquals((Object)TextDocumentSyncKind.Full, (Object)DocumentDidChangeTest.this.getDocumentSyncKind(t));
                return true;
            }
        })).anyMatching();
        String text = "Hello";
        viewer.getDocument().replace(0, 0, "Hello");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(1));
        DidChangeTextDocumentParams lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(0);
        Assertions.assertNotNull((Object)lastChange.getContentChanges());
        Assertions.assertEquals((int)1, (int)lastChange.getContentChanges().size());
        TextDocumentContentChangeEvent change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Assertions.assertEquals((Object)"Hello", (Object)change0.getText());
        viewer.getDocument().replace(5, 0, " World");
        TestUtils.waitForAndAssertCondition(1000, TestUtils.numberOfChangesIs(2));
        lastChange = (DidChangeTextDocumentParams)MockLanguageServer.INSTANCE.getDidChangeEvents().get(1);
        Assertions.assertNotNull((Object)lastChange.getContentChanges());
        Assertions.assertEquals((int)1, (int)lastChange.getContentChanges().size());
        change0 = (TextDocumentContentChangeEvent)lastChange.getContentChanges().get(0);
        Assertions.assertEquals((Object)"Hello World", (Object)change0.getText());
    }

    private TextDocumentSyncKind getDocumentSyncKind(ServerCapabilities t) {
        TextDocumentSyncKind syncKind = null;
        if (t.getTextDocumentSync().isLeft()) {
            syncKind = (TextDocumentSyncKind)t.getTextDocumentSync().getLeft();
        } else if (t.getTextDocumentSync().isRight()) {
            syncKind = ((TextDocumentSyncOptions)t.getTextDocumentSync().getRight()).getChange();
        }
        return syncKind;
    }
}

