/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4jakarta.jdt.internal.jsonb;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.Flags;
import org.eclipse.jdt.core.IAnnotatable;
import org.eclipse.jdt.core.IAnnotation;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IField;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.lsp4j.Diagnostic;
import org.eclipse.lsp4j.DiagnosticSeverity;
import org.eclipse.lsp4j.Range;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.IJavaDiagnosticsParticipant;
import org.eclipse.lsp4jakarta.jdt.core.java.diagnostics.JavaDiagnosticsContext;
import org.eclipse.lsp4jakarta.jdt.core.utils.IJDTUtils;
import org.eclipse.lsp4jakarta.jdt.core.utils.PositionUtils;
import org.eclipse.lsp4jakarta.jdt.internal.DiagnosticUtils;
import org.eclipse.lsp4jakarta.jdt.internal.Messages;
import org.eclipse.lsp4jakarta.jdt.internal.core.ls.JDTUtilsLSImpl;
import org.eclipse.lsp4jakarta.jdt.internal.jsonb.Constants;
import org.eclipse.lsp4jakarta.jdt.internal.jsonb.ErrorCode;

public class JsonbDiagnosticsParticipant
implements IJavaDiagnosticsParticipant {
    @Override
    public List<Diagnostic> collectDiagnostics(JavaDiagnosticsContext context, IProgressMonitor monitor) throws CoreException {
        IType[] types;
        String uri = context.getUri();
        IJDTUtils utils = JDTUtilsLSImpl.getInstance();
        ICompilationUnit unit = utils.resolveCompilationUnit(uri);
        ArrayList<Diagnostic> diagnostics = new ArrayList<Diagnostic>();
        if (unit == null) {
            return diagnostics;
        }
        IType[] iTypeArray = types = unit.getAllTypes();
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            IMethod method;
            IType type = iTypeArray[n2];
            IMethod[] methods = type.getMethods();
            ArrayList<IMethod> jonbMethods = new ArrayList<IMethod>();
            IMethod[] iMethodArray = type.getMethods();
            int n3 = iMethodArray.length;
            int n4 = 0;
            while (n4 < n3) {
                method = iMethodArray[n4];
                if (DiagnosticUtils.isConstructorMethod(method) || Flags.isStatic((int)method.getFlags())) {
                    IAnnotation[] allAnnotations;
                    IAnnotation[] iAnnotationArray = allAnnotations = method.getAnnotations();
                    int n5 = allAnnotations.length;
                    int n6 = 0;
                    while (n6 < n5) {
                        IAnnotation annotation = iAnnotationArray[n6];
                        if (DiagnosticUtils.isMatchedJavaElement(type, annotation.getElementName(), "jakarta.json.bind.annotation.JsonbCreator")) {
                            jonbMethods.add(method);
                        }
                        ++n6;
                    }
                }
                ++n4;
            }
            if (jonbMethods.size() > 1) {
                iMethodArray = methods;
                n3 = methods.length;
                n4 = 0;
                while (n4 < n3) {
                    method = iMethodArray[n4];
                    String msg = Messages.getMessage("ErrorMessageJsonbCreator", new Object[0]);
                    Range range = PositionUtils.toNameRange(method, context.getUtils());
                    diagnostics.add(context.createDiagnostic(uri, msg, range, "jakarta-jsonb", ErrorCode.InvalidNumerOfJsonbCreatorAnnotationsInClass, DiagnosticSeverity.Error));
                    ++n4;
                }
            }
            iMethodArray = type.getFields();
            n3 = iMethodArray.length;
            n4 = 0;
            while (n4 < n3) {
                IMethod field = iMethodArray[n4];
                this.collectJsonbTransientFieldDiagnostics(context, uri, unit, type, diagnostics, (IField)field);
                this.collectJsonbTransientAccessorDiagnostics(context, uri, unit, type, diagnostics, (IField)field);
                ++n4;
            }
            ++n2;
        }
        return diagnostics;
    }

    private void collectJsonbTransientFieldDiagnostics(JavaDiagnosticsContext context, String uri, ICompilationUnit unit, IType type, List<Diagnostic> diagnostics, IField field) throws JavaModelException {
        List<String> jsonbAnnotationsForField = this.getJsonbAnnotationNames(type, (IAnnotatable)field);
        if (jsonbAnnotationsForField.contains("jakarta.json.bind.annotation.JsonbTransient")) {
            boolean hasAccessorConflict = false;
            List<IMethod> accessors = DiagnosticUtils.getFieldAccessors(unit, field);
            for (IMethod accessor : accessors) {
                List<String> jsonbAnnotationsForAccessor = this.getJsonbAnnotationNames(type, (IAnnotatable)accessor);
                if (!this.hasJsonbAnnotationOtherThanTransient(jsonbAnnotationsForAccessor)) continue;
                Range range = PositionUtils.toNameRange(accessor, context.getUtils());
                this.createJsonbTransientDiagnostic(context, uri, range, unit, diagnostics, (IMember)accessor, jsonbAnnotationsForAccessor, ErrorCode.InvalidJSonBindindAnnotationWithJsonbTransientOnField);
                hasAccessorConflict = true;
            }
            if (hasAccessorConflict || this.hasJsonbAnnotationOtherThanTransient(jsonbAnnotationsForField)) {
                Range range = PositionUtils.toNameRange(field, context.getUtils());
                this.createJsonbTransientDiagnostic(context, uri, range, unit, diagnostics, (IMember)field, jsonbAnnotationsForField, ErrorCode.InvalidJSonBindindAnnotationWithJsonbTransientOnField);
            }
        }
    }

    private void collectJsonbTransientAccessorDiagnostics(JavaDiagnosticsContext context, String uri, ICompilationUnit unit, IType type, List<Diagnostic> diagnostics, IField field) throws JavaModelException {
        boolean createDiagnosticForField = false;
        List<String> jsonbAnnotationsForField = this.getJsonbAnnotationNames(type, (IAnnotatable)field);
        List<IMethod> accessors = DiagnosticUtils.getFieldAccessors(unit, field);
        for (IMethod accessor : accessors) {
            List<String> jsonbAnnotationsForAccessor = this.getJsonbAnnotationNames(type, (IAnnotatable)accessor);
            boolean hasFieldConflict = false;
            if (!jsonbAnnotationsForAccessor.contains("jakarta.json.bind.annotation.JsonbTransient")) continue;
            if (this.hasJsonbAnnotationOtherThanTransient(jsonbAnnotationsForField)) {
                createDiagnosticForField = true;
                hasFieldConflict = true;
            }
            if (!hasFieldConflict && !this.hasJsonbAnnotationOtherThanTransient(jsonbAnnotationsForAccessor)) continue;
            Range range = PositionUtils.toNameRange(accessor, context.getUtils());
            this.createJsonbTransientDiagnostic(context, uri, range, unit, diagnostics, (IMember)accessor, jsonbAnnotationsForAccessor, ErrorCode.InvalidJSonBindindAnnotationWithJsonbTransientOnAccessor);
        }
        if (createDiagnosticForField) {
            Range range = PositionUtils.toNameRange(field, context.getUtils());
            this.createJsonbTransientDiagnostic(context, uri, range, unit, diagnostics, (IMember)field, jsonbAnnotationsForField, ErrorCode.InvalidJSonBindindAnnotationWithJsonbTransientOnAccessor);
        }
    }

    private boolean createJsonbTransientDiagnostic(JavaDiagnosticsContext context, String uri, Range range, ICompilationUnit unit, List<Diagnostic> diagnostics, IMember member, List<String> jsonbAnnotations, ErrorCode errorCode) throws JavaModelException {
        String diagnosticErrorMessage = null;
        if (errorCode.equals(ErrorCode.InvalidJSonBindindAnnotationWithJsonbTransientOnField)) {
            diagnosticErrorMessage = Messages.getMessage("ErrorMessageJsonbTransientOnField", new Object[0]);
        } else if (errorCode.equals(ErrorCode.InvalidJSonBindindAnnotationWithJsonbTransientOnAccessor)) {
            diagnosticErrorMessage = Messages.getMessage("ErrorMessageJsonbTransientOnAccessor", new Object[0]);
        }
        List diagnosticData = jsonbAnnotations.stream().map(annotation -> DiagnosticUtils.getSimpleName(annotation)).collect(Collectors.toList());
        diagnostics.add(context.createDiagnostic(uri, diagnosticErrorMessage, range, "jakarta-jsonb", (JsonArray)new Gson().toJsonTree(diagnosticData), errorCode, DiagnosticSeverity.Error));
        return true;
    }

    private List<String> getJsonbAnnotationNames(IType type, IAnnotatable annotable) throws JavaModelException {
        IAnnotation[] annotations;
        ArrayList<String> jsonbAnnotationNames = new ArrayList<String>();
        IAnnotation[] iAnnotationArray = annotations = annotable.getAnnotations();
        int n = annotations.length;
        int n2 = 0;
        while (n2 < n) {
            IAnnotation annotation = iAnnotationArray[n2];
            String matchedAnnotation = DiagnosticUtils.getMatchedJavaElementName(type, annotation.getElementName(), (String[])Constants.JSONB_ANNOTATIONS.toArray(String[]::new));
            if (matchedAnnotation != null) {
                jsonbAnnotationNames.add(matchedAnnotation);
            }
            ++n2;
        }
        return jsonbAnnotationNames;
    }

    private boolean hasJsonbAnnotationOtherThanTransient(List<String> jsonbAnnotations) throws JavaModelException {
        for (String annotationName : jsonbAnnotations) {
            if (!Constants.JSONB_ANNOTATIONS.contains(annotationName) || annotationName.equals("jakarta.json.bind.annotation.JsonbTransient")) continue;
            return true;
        }
        return false;
    }
}

