/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.core;

import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.lsp4mp.jdt.internal.core.MavenArtifactResolver;

public interface ArtifactResolver {
    public static final String CLASSIFIER_JAVADOC = "javadoc";
    public static final String CLASSIFIER_SOURCES = "sources";
    public static final ArtifactResolver DEFAULT_ARTIFACT_RESOLVER = new MavenArtifactResolver();

    public String getArtifact(Artifact var1, IProgressMonitor var2);

    public Set<Artifact> getDependencies(Artifact var1, IProgressMonitor var2);

    public static class Artifact {
        private final String groupId;
        private final String artifactId;
        private final String version;
        private final String classifier;

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.artifactId == null ? 0 : this.artifactId.hashCode());
            result = 31 * result + (this.classifier == null ? 0 : this.classifier.hashCode());
            result = 31 * result + (this.groupId == null ? 0 : this.groupId.hashCode());
            result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Artifact other = (Artifact)obj;
            if (this.artifactId == null ? other.artifactId != null : !this.artifactId.equals(other.artifactId)) {
                return false;
            }
            if (this.classifier == null ? other.classifier != null : !this.classifier.equals(other.classifier)) {
                return false;
            }
            if (this.groupId == null ? other.groupId != null : !this.groupId.equals(other.groupId)) {
                return false;
            }
            return !(this.version == null ? other.version != null : !this.version.equals(other.version));
        }

        public Artifact(String groupId, String artifactId, String version) {
            this(groupId, artifactId, version, null);
        }

        public Artifact(String groupId, String artifactId, String version, String classifier) {
            this.groupId = groupId;
            this.artifactId = artifactId;
            this.version = version;
            this.classifier = classifier;
        }

        public String getGroupId() {
            return this.groupId;
        }

        public String getArtifactId() {
            return this.artifactId;
        }

        public String getVersion() {
            return this.version;
        }

        public String getClassifier() {
            return this.classifier;
        }
    }
}

