/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.lsp4mp.jdt.internal.core;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.lsp4mp.jdt.core.IProjectLabelProvider;
import org.eclipse.lsp4mp.jdt.core.ProjectLabelDefinition;

public class ProjectLabelRegistry {
    private static final String CLASS_ATTR = "class";
    private static final String EXTENSION_PROJECT_LABEL_PROVIDERS = "projectLabelProviders";
    private static final Logger LOGGER = Logger.getLogger(ProjectLabelRegistry.class.getName());
    private static final ProjectLabelRegistry INSTANCE = new ProjectLabelRegistry();
    private final List<ProjectLabelDefinition> projectLabelDefinitions = new ArrayList<ProjectLabelDefinition>();
    private boolean projectDefinitionsLoaded = false;

    public static ProjectLabelRegistry getInstance() {
        return INSTANCE;
    }

    public List<ProjectLabelDefinition> getProjectLabelDefinitions() {
        this.loadProjectLabelDefinitions();
        return this.projectLabelDefinitions;
    }

    private synchronized void loadProjectLabelDefinitions() {
        if (this.projectDefinitionsLoaded) {
            return;
        }
        this.projectDefinitionsLoaded = true;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] cf = registry.getConfigurationElementsFor("org.eclipse.lsp4mp.jdt.core", EXTENSION_PROJECT_LABEL_PROVIDERS);
        this.addProjectLabelDefinition(cf);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addProjectLabelDefinition(IConfigurationElement[] cf) {
        IConfigurationElement[] iConfigurationElementArray = cf;
        int n = cf.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ce = iConfigurationElementArray[n2];
            try {
                IProjectLabelProvider provider = (IProjectLabelProvider)ce.createExecutableExtension(CLASS_ATTR);
                List<ProjectLabelDefinition> list = this.projectLabelDefinitions;
                synchronized (list) {
                    this.projectLabelDefinitions.add(new ProjectLabelDefinition(provider));
                }
            }
            catch (Throwable t) {
                LOGGER.log(Level.SEVERE, "Error while collecting project label extension contributions", t);
            }
            ++n2;
        }
    }
}

