/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mat.impl.chart;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Comparator;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import org.eclipse.birt.chart.computation.LegendItemHints;
import org.eclipse.birt.chart.device.EmptyUpdateNotifier;
import org.eclipse.birt.chart.device.IDeviceRenderer;
import org.eclipse.birt.chart.device.IImageMapEmitter;
import org.eclipse.birt.chart.event.StructureSource;
import org.eclipse.birt.chart.event.StructureType;
import org.eclipse.birt.chart.exception.ChartException;
import org.eclipse.birt.chart.factory.GeneratedChartState;
import org.eclipse.birt.chart.factory.Generator;
import org.eclipse.birt.chart.factory.RunTimeContext;
import org.eclipse.birt.chart.model.Chart;
import org.eclipse.birt.chart.model.attribute.ActionType;
import org.eclipse.birt.chart.model.attribute.ActionValue;
import org.eclipse.birt.chart.model.attribute.Anchor;
import org.eclipse.birt.chart.model.attribute.Bounds;
import org.eclipse.birt.chart.model.attribute.Insets;
import org.eclipse.birt.chart.model.attribute.TooltipValue;
import org.eclipse.birt.chart.model.attribute.TriggerCondition;
import org.eclipse.birt.chart.model.attribute.impl.BoundsImpl;
import org.eclipse.birt.chart.model.attribute.impl.ColorDefinitionImpl;
import org.eclipse.birt.chart.model.attribute.impl.TooltipValueImpl;
import org.eclipse.birt.chart.model.attribute.impl.URLValueImpl;
import org.eclipse.birt.chart.model.data.Action;
import org.eclipse.birt.chart.model.data.Trigger;
import org.eclipse.birt.chart.model.data.impl.ActionImpl;
import org.eclipse.birt.chart.model.data.impl.TriggerImpl;
import org.eclipse.birt.chart.model.layout.Block;
import org.eclipse.birt.chart.model.layout.LabelBlock;
import org.eclipse.birt.chart.model.layout.Legend;
import org.eclipse.birt.chart.render.ActionRendererAdapter;
import org.eclipse.birt.chart.render.IActionRenderer;
import org.eclipse.birt.chart.script.IScriptClassLoader;
import org.eclipse.birt.chart.util.PluginSettings;
import org.eclipse.mat.SnapshotException;
import org.eclipse.mat.impl.chart.ChartBuilder;
import org.eclipse.mat.impl.chart.Messages;
import org.eclipse.mat.query.IResult;
import org.eclipse.mat.query.IResultPie;
import org.eclipse.mat.query.registry.QueryObjectLink;
import org.eclipse.mat.report.IOutputter;
import org.eclipse.mat.report.Renderer;
import org.eclipse.mat.util.HTMLUtils;
import org.eclipse.mat.util.MessageUtil;

@Renderer(target="html", result={IResultPie.class})
public class HtmlPieChartRenderer
implements IOutputter {
    public void embedd(final IOutputter.Context context, IResult result, Writer writer) throws IOException {
        try {
            final IResultPie pie = (IResultPie)result;
            String imageFile = "chart" + context.getId() + ".png";
            Chart chart = ChartBuilder.create(pie, false, ColorDefinitionImpl.WHITE(), ColorDefinitionImpl.BLACK());
            Trigger trigger = TriggerImpl.create((TriggerCondition)TriggerCondition.ONMOUSEOVER_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.SHOW_TOOLTIP_LITERAL, (ActionValue)TooltipValueImpl.create((int)200, (String)"tooltip")));
            chart.getLegend().getTriggers().add((Object)trigger);
            Trigger trigger2 = TriggerImpl.create((TriggerCondition)TriggerCondition.ONCLICK_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.URL_REDIRECT_LITERAL, (ActionValue)URLValueImpl.create(null, null, null, null, null)));
            chart.getLegend().getTriggers().add((Object)trigger2);
            Trigger trigger3 = TriggerImpl.create((TriggerCondition)TriggerCondition.ONKEYPRESS_LITERAL, (Action)ActionImpl.create((ActionType)ActionType.URL_REDIRECT_LITERAL, (ActionValue)URLValueImpl.create(null, null, null, null, null)));
            chart.getLegend().getTriggers().add((Object)trigger3);
            PluginSettings ps = PluginSettings.instance();
            IDeviceRenderer render = ps.getDevice("dv.PNG");
            render.setProperty("device.file.identifier", (Object)new File(context.getOutputDirectory(), imageFile));
            int width = 850;
            int height = 350;
            int slices = pie.getSlices().size();
            if (slices > 13) {
                width += 350 * (slices / 13);
            }
            Bounds bo = BoundsImpl.create((double)0.0, (double)0.0, (double)width, (double)height);
            int resolution = render.getDisplayServer().getDpiResolution();
            bo.scale(72.0 / (double)resolution);
            Legend lg = chart.getLegend();
            Insets is = lg.getInsets();
            is.setLeft(is.getLeft() - 10.0);
            lg.setMaxPercent(((double)width - 510.0) / (double)width);
            lg.setAnchor(Anchor.EAST_LITERAL);
            RunTimeContext rtc = new RunTimeContext();
            rtc.setScriptClassLoader(new IScriptClassLoader(){

                public Class<?> loadClass(String className, ClassLoader parentLoader) throws ClassNotFoundException {
                    return this.getClass().getClassLoader().loadClass(className);
                }
            });
            Generator gr = Generator.instance();
            GeneratedChartState state = gr.build(render.getDisplayServer(), chart, bo, null, rtc, null);
            String plotLabel = null;
            for (Block o : chart.getPlot().getChildren()) {
                if (!(o instanceof LabelBlock)) continue;
                plotLabel = ((LabelBlock)o).getLabel().getCaption().getValue();
            }
            state.getRunTimeContext().setActionRenderer((IActionRenderer)new ActionRendererAdapter(){

                public void processAction(Action action, StructureSource source) {
                    if (ActionType.SHOW_TOOLTIP_LITERAL.equals((Object)action.getType())) {
                        TooltipValue tooltip = (TooltipValue)action.getValue();
                        if (StructureType.LEGEND_ENTRY.equals(source.getType())) {
                            LegendItemHints item = (LegendItemHints)source.getSource();
                            IResultPie.Slice slice = (IResultPie.Slice)pie.getSlices().get(item.getIndex());
                            String[] descs = slice.getDescription().split("<br/>", 2);
                            if (descs.length >= 2) {
                                String desc = descs[1].replaceAll("<[/a-z]+>", "");
                                tooltip.setText(MessageUtil.format((String)Messages.HtmlPieChartRenderer_LabelTooltipWithStorage, (Object[])new Object[]{item.getItemText(), desc}));
                            } else {
                                tooltip.setText(item.getItemText());
                            }
                        }
                    } else if (ActionType.URL_REDIRECT_LITERAL.equals((Object)action.getType())) {
                        URLValueImpl cb = (URLValueImpl)action.getValue();
                        if (StructureType.LEGEND_ENTRY.equals(source.getType())) {
                            LegendItemHints item = (LegendItemHints)source.getSource();
                            IResultPie.Slice slice = (IResultPie.Slice)pie.getSlices().get(item.getIndex());
                            if (slice.getContext() != null) {
                                try {
                                    int id = slice.getContext().getObjectId();
                                    if (id != -1) {
                                        String externalIdentifier = context.getQueryContext().mapToExternalIdentifier(id);
                                        cb.setBaseUrl(QueryObjectLink.forObject((String)externalIdentifier));
                                    }
                                }
                                catch (SnapshotException e) {
                                    return;
                                }
                            }
                        }
                    }
                }

                public void processAction(Action action, StructureSource source, RunTimeContext ctx) {
                    this.processAction(action, source);
                }
            });
            render.setProperty("device.component", (Object)new EmptyUpdateNotifier(chart, state.getChartModel()));
            gr.render(render, state);
            String imageMap = ((IImageMapEmitter)render).getImageMap();
            imageMap = this.fixupMapAreas(imageMap, resolution);
            String mapName = "chart" + context.getId() + "map";
            writer.append("<map name='").append(mapName).append("'>").append(imageMap).append("</map>");
            String slicesText = MessageUtil.format((String)Messages.HtmlPieChartRenderer_PieChartSlices, (Object[])new Object[]{slices});
            String altText = plotLabel != null ? MessageUtil.format((String)Messages.HtmlPieChartRenderer_LabelTooltipWithStorage, (Object[])new Object[]{slicesText, plotLabel}) : slicesText;
            writer.append("<img src=\"").append(imageFile).append("\" width=\"" + width + "\" height=\"" + height + "\" usemap='#").append(mapName).append("' alt=\"").append(altText).append("\" title=\"").append(slicesText).append("\">");
        }
        catch (LinkageError e) {
            this.handleError(e, writer);
        }
        catch (ChartException e) {
            this.handleError(e, writer);
        }
    }

    private String fixupMapAreas(String imageMap, int resolution) {
        imageMap = imageMap.replaceAll("/><area", "><area").replaceFirst("/>$", ">");
        String altReplace = MessageUtil.format((String)Matcher.quoteReplacement(Messages.HtmlPieChartRenderer_AreaAltReplace), (Object[])new Object[]{"$2"});
        imageMap = imageMap.replaceAll("alt=\"\"([^>]*)title=\"([^\"]*)\"", "alt=\"" + altReplace + "\"$1title=\"$2\"");
        imageMap = imageMap.replace("href=\"\"", "");
        CharSequence[] areas = imageMap.split("<area ");
        Arrays.sort(areas, new Comparator<String>(){

            @Override
            public int compare(String o1, String o2) {
                int i1 = o1.indexOf("title");
                int i2 = o2.indexOf("title");
                return o1.substring(i1 + 1).compareTo(o2.substring(i2 + 1));
            }
        });
        double scaling = (double)resolution / 96.0;
        int i = 0;
        while (i < areas.length) {
            int i2;
            String m = "coords=\"";
            int i1 = ((String)areas[i]).indexOf(m);
            if (i1 >= 0 && (i2 = ((String)areas[i]).indexOf("\"", i1 += m.length())) > 0) {
                StringBuilder sb = new StringBuilder(((String)areas[i]).substring(0, i1));
                String[] coords = ((String)areas[i]).substring(i1, i2).split(",");
                int j = 0;
                while (j < coords.length) {
                    if (j > 0) {
                        sb.append(',');
                    }
                    int v = Integer.parseInt(coords[j]);
                    sb.append((int)((double)v * scaling));
                    ++j;
                }
                sb.append(((String)areas[i]).substring(i2));
                areas[i] = sb.toString();
            }
            ++i;
        }
        imageMap = String.join((CharSequence)"<area ", areas);
        return imageMap;
    }

    private void handleError(Throwable e, Writer writer) throws IOException {
        StringBuilder message = new StringBuilder();
        message.append(Messages.HtmlPieChartRenderer_ErrorRenderingChart);
        message.append(HTMLUtils.escapeText((String)e.getClass().getName()));
        if (e.getMessage() != null) {
            message.append(": ").append(HTMLUtils.escapeText((String)e.getMessage()));
        }
        String msg = message.toString();
        writer.append(msg).append(Messages.HtmlPieChartRenderer_SeeLogForDetails);
        Logger.getLogger(this.getClass().getName()).log(Level.SEVERE, msg, e);
    }

    public void process(IOutputter.Context context, IResult result, Writer writer) throws IOException {
    }
}

