/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.microprofile.telemetry.tracing.tck.async;

import io.opentelemetry.api.baggage.Baggage;
import io.opentelemetry.api.trace.Span;
import io.opentelemetry.context.Scope;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.PreDestroy;
import jakarta.inject.Inject;
import jakarta.ws.rs.ApplicationPath;
import jakarta.ws.rs.GET;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.QueryParam;
import jakarta.ws.rs.WebApplicationException;
import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.core.Application;
import jakarta.ws.rs.core.Context;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.eclipse.microprofile.telemetry.tracing.tck.exporter.InMemorySpanExporter;
import org.testng.Assert;

@Path(value="JaxRsClientAsyncTestEndpoint")
public class JaxRsClientAsyncTestEndpoint {
    public static final String TEST_PASSED = "Test Passed";
    @Inject
    private InMemorySpanExporter spanExporter;
    private Client client;

    @PostConstruct
    private void openClient() {
        this.client = ClientBuilder.newClient();
    }

    @PreDestroy
    private void closeClient() {
        if (this.client != null) {
            this.client.close();
            this.client = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Path(value="/jaxrsclient")
    public Response getJax(@Context UriInfo uriInfo, @QueryParam(value="baggageValue") String baggageValue) {
        Assert.assertNotNull((Object)Span.current());
        try (Scope s = Baggage.builder().put("foo", baggageValue).build().makeCurrent();){
            Baggage baggage = Baggage.current();
            Assert.assertEquals((String)baggage.getEntryValue("foo"), (String)baggageValue);
            String url = new String(uriInfo.getAbsolutePath().toString());
            url = url.replace("jaxrsclient", "jaxrstwo");
            String result = (String)this.client.target(url).queryParam("baggageValue", new Object[]{baggageValue}).request(new String[]{"text/plain"}).get(String.class);
            Assert.assertEquals((String)result, (String)TEST_PASSED);
        }
        finally {
            this.client.close();
        }
        return Response.ok((Object)Span.current().getSpanContext().getTraceId()).build();
    }

    @GET
    @Path(value="/jaxrsclientasync")
    public Response getJaxAsync(@Context UriInfo uriInfo, @QueryParam(value="baggageValue") String baggageValue) {
        Assert.assertNotNull((Object)Span.current());
        try (Scope s = Baggage.builder().put("foo", baggageValue).build().makeCurrent();){
            Baggage baggage = Baggage.current();
            Assert.assertEquals((String)baggage.getEntryValue("foo"), (String)baggageValue);
            String url = new String(uriInfo.getAbsolutePath().toString());
            url = url.replace("jaxrsclientasync", "jaxrstwo");
            Client client = ClientBuilder.newClient();
            Future result = client.target(url).queryParam("baggageValue", new Object[]{baggageValue}).request(new String[]{"text/plain"}).async().get(String.class);
            try {
                String resultValue = (String)result.get(10L, TimeUnit.SECONDS);
                Assert.assertEquals((String)resultValue, (String)TEST_PASSED);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                client.close();
            }
        }
        return Response.ok((Object)Span.current().getSpanContext().getTraceId()).build();
    }

    @GET
    @Path(value="/jaxrsclienterror")
    public Response getJaxError(@Context UriInfo uriInfo, @QueryParam(value="baggageValue") String baggageValue) {
        Assert.assertNotNull((Object)Span.current());
        try (Scope s = Baggage.builder().put("foo", baggageValue).build().makeCurrent();){
            Baggage baggage = Baggage.current();
            Assert.assertEquals((String)baggage.getEntryValue("foo"), (String)baggageValue);
            String url = new String(uriInfo.getAbsolutePath().toString());
            url = url.replace("jaxrsclienterror", "error");
            Client client = ClientBuilder.newClient();
            Future result = client.target(url).request(new String[]{"text/plain"}).async().get(String.class);
            try {
                result.get(10L, TimeUnit.SECONDS);
                Assert.fail((String)"Client didn't throw an exception");
            }
            catch (ExecutionException e) {
                WebApplicationException webEx = (WebApplicationException)e.getCause();
                Assert.assertEquals((int)webEx.getResponse().getStatus(), (int)400);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                client.close();
            }
        }
        return Response.ok((Object)Span.current().getSpanContext().getTraceId()).build();
    }

    @GET
    @Path(value="/jaxrstwo")
    public Response getJaxRsTwo(@QueryParam(value="baggageValue") String baggageValue) {
        Assert.assertNotNull((Object)Span.current());
        Baggage baggage = Baggage.current();
        Assert.assertEquals((String)baggage.getEntryValue("foo"), (String)baggageValue);
        return Response.ok((Object)TEST_PASSED).build();
    }

    @GET
    @Path(value="/error")
    public Response getError() {
        return Response.status((int)400).build();
    }

    @ApplicationPath(value="/")
    public static class RestApplication
    extends Application {
    }
}

