/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.service.core.configuration;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.m2m.atl.engine.AtlLauncher;
import org.eclipse.m2m.atl.engine.AtlModelHandler;
import org.eclipse.m2m.atl.service.core.ServiceMessages;
import org.eclipse.m2m.atl.service.core.ServiceTransformationUtil;
import org.eclipse.m2m.atl.service.core.configuration.TransformationConfiguration;
import org.eclipse.m2m.atl.service.core.exception.ServiceException;
import org.eclipse.m2m.atl.service.core.nestedElements.Model;
import org.eclipse.m2m.atl.service.core.nestedElements.Transformation;

public class SingleTransformationConfiguration
extends TransformationConfiguration {
    private Transformation transformation;

    public SingleTransformationConfiguration(String path, String name, String pluginId) {
        super(name, pluginId);
        this.transformation = new Transformation(path);
    }

    public void addInModel(String name, String path, String metamodel, boolean inWorkspace) {
        try {
            if (inWorkspace) {
                this.models.put(name, new Model(name, metamodel, "EMF"));
                this.transformation.addInNotPreloadedList(name);
            } else {
                this.models.put(name, new Model(name, ((Model)this.models.get(metamodel)).getAsmModel(), path, null, false, "EMF", this.pluginId));
            }
            this.transformation.addInModel(name, name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addOutModel(String name, String fileName, String metamodel) {
        this.models.put(name, new Model(name, ((Model)this.models.get(metamodel)).getAsmModel(), fileName, "EMF"));
        this.transformation.addOutModel(name, name, metamodel);
    }

    public void addMetamodel(String name, String path, String nsUri, boolean isM3, String modelHandler) {
        try {
            this.models.put(name, new Model(name, AtlModelHandler.getDefault((String)modelHandler).getMof(), path, nsUri, isM3, modelHandler, this.pluginId));
            this.transformation.addInModel(name, name);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void execute(String pathFolder, String pathInModel) throws ServiceException {
        Map params = Collections.EMPTY_MAP;
        HashMap libs = new HashMap();
        ArrayList superimps = new ArrayList();
        URL asmUrl = ServiceTransformationUtil.getURLFromASMFile(this.transformation.getTransformationPath(), this.pluginId);
        if (this.transformation.getModelsNotPreloaded().size() != 1) {
            throw new ServiceException(8, ServiceMessages.getString("SingleTransformationConfiguration.0"));
        }
        ((Model)this.models.get(this.transformation.getModelsNotPreloaded().get(0))).loadModel(pathInModel, ((Model)this.models.get(((Model)this.models.get(this.transformation.getModelsNotPreloaded().get(0))).getMetamodelName())).getAsmModel(), this.pluginId);
        AtlLauncher.getDefault().launch(asmUrl, libs, this.getModelsForTransformation(this.transformation), params, superimps, Collections.EMPTY_MAP);
        for (String modelName : this.transformation.getOutModels().keySet()) {
            Model currentOutModel = (Model)this.models.get(modelName);
            AtlModelHandler.getDefault((String)"EMF").saveModel(currentOutModel.getAsmModel(), String.valueOf(pathFolder) + "/" + currentOutModel.getFileName());
        }
    }
}

