/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.atl.emftvm.impl.resource;

import java.io.DataInputStream;
import java.io.IOException;
import org.eclipse.m2m.atl.emftvm.BranchInstruction;
import org.eclipse.m2m.atl.emftvm.CodeBlockInstruction;
import org.eclipse.m2m.atl.emftvm.FieldInstruction;
import org.eclipse.m2m.atl.emftvm.Findtype;
import org.eclipse.m2m.atl.emftvm.Ifte;
import org.eclipse.m2m.atl.emftvm.Instruction;
import org.eclipse.m2m.atl.emftvm.InvokeInstruction;
import org.eclipse.m2m.atl.emftvm.InvokeOperationInstruction;
import org.eclipse.m2m.atl.emftvm.LocalVariableInstruction;
import org.eclipse.m2m.atl.emftvm.Match;
import org.eclipse.m2m.atl.emftvm.New;
import org.eclipse.m2m.atl.emftvm.Push;
import org.eclipse.m2m.atl.emftvm.impl.resource.ConstantPool;
import org.eclipse.m2m.atl.emftvm.util.EmftvmSwitch;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LoadInstructionParametersSwitch
extends EmftvmSwitch<Instruction> {
    protected final DataInputStream inputStream;
    protected final ConstantPool constants;

    public LoadInstructionParametersSwitch(DataInputStream inputStream, ConstantPool constants) {
        this.inputStream = inputStream;
        this.constants = constants;
    }

    @Override
    public Instruction caseBranchInstruction(BranchInstruction object) {
        try {
            int offset = this.inputStream.readInt();
            object.setOffset(offset);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseBranchInstruction(object);
    }

    @Override
    public Instruction caseFieldInstruction(FieldInstruction object) {
        try {
            object.setFieldname((String)this.constants.get(this.inputStream.readInt()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseFieldInstruction(object);
    }

    @Override
    public Instruction caseFindtype(Findtype object) {
        try {
            object.setModelname((String)this.constants.get(this.inputStream.readInt()));
            object.setTypename((String)this.constants.get(this.inputStream.readInt()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseFindtype(object);
    }

    @Override
    public Instruction caseInvokeInstruction(InvokeInstruction object) {
        try {
            object.setArgcount(this.inputStream.readInt());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseInvokeInstruction(object);
    }

    @Override
    public Instruction caseInvokeOperationInstruction(InvokeOperationInstruction object) {
        try {
            object.setOpname((String)this.constants.get(this.inputStream.readInt()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseInvokeOperationInstruction(object);
    }

    @Override
    public Instruction caseLocalVariableInstruction(LocalVariableInstruction object) {
        try {
            object.setCbOffset(this.inputStream.readInt());
            object.setLocalVariableIndex(this.inputStream.readInt());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseLocalVariableInstruction(object);
    }

    @Override
    public Instruction caseNew(New object) {
        try {
            object.setModelname((String)this.constants.get(this.inputStream.readInt()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseNew(object);
    }

    @Override
    public Instruction casePush(Push object) {
        try {
            object.setValue(this.constants.get(this.inputStream.readInt()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.casePush(object);
    }

    @Override
    public Instruction caseMatch(Match object) {
        try {
            object.setRulename((String)this.constants.get(this.inputStream.readInt()));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseMatch(object);
    }

    @Override
    public Instruction caseCodeBlockInstruction(CodeBlockInstruction object) {
        try {
            object.setCbIndex(this.inputStream.readInt());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseCodeBlockInstruction(object);
    }

    @Override
    public Instruction caseIfte(Ifte object) {
        try {
            object.setThenCbIndex(this.inputStream.readInt());
            object.setElseCbIndex(this.inputStream.readInt());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return (Instruction)super.caseIfte(object);
    }
}

