/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.m2m.internal.qvt.oml.debug.ui;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IStatusHandler;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.m2m.internal.qvt.oml.debug.ui.DebugUIMessages;
import org.eclipse.m2m.internal.qvt.oml.debug.ui.QVTODebugUIPlugin;
import org.eclipse.m2m.internal.qvt.oml.debug.ui.actions.QVTOBreakpointPropertiesAction;
import org.eclipse.m2m.qvt.oml.debug.core.BreakpointError;
import org.eclipse.m2m.qvt.oml.debug.core.QVTOBreakpoint;
import org.eclipse.m2m.qvt.oml.debug.core.QVTODebugCore;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class BreakpointCondErrorHandler
implements IStatusHandler {
    public Object handleStatus(IStatus status, Object source) throws CoreException {
        if (!(source instanceof IDebugTarget)) {
            throw new CoreException(QVTODebugCore.createStatus((int)4, (String)("Unable to resolve status for:" + source)));
        }
        BreakpointError breakpointError = (BreakpointError)status;
        IDebugTarget target = (IDebugTarget)source;
        this.suspendDebugUI(target);
        this.showErrorDialog(breakpointError.getfBreakpointID(), breakpointError.getMessage(), breakpointError.getDetail());
        return Boolean.TRUE;
    }

    public void showErrorDialog(final long breakPointID, final String errorMessage, final String detail) {
        final Display display = QVTODebugUIPlugin.getStandardDisplay();
        display.asyncExec(new Runnable(){

            public void run() {
                IStatus errorStatus;
                QVTOBreakpoint breakpoint = QVTOBreakpoint.getBreakpointByID((long)breakPointID);
                if (breakpoint == null) {
                    QVTODebugCore.log((IStatus)QVTODebugCore.createStatus((int)4, (String)"Breakpoint not found"));
                    return;
                }
                if (display.isDisposed()) {
                    return;
                }
                Shell shell = QVTODebugUIPlugin.getActiveWorkbenchShell();
                CondErrorDialog dialog = new CondErrorDialog(shell, errorMessage, errorStatus = QVTODebugUIPlugin.createErrorStatus(detail));
                int result = dialog.open();
                if (result == 0) {
                    QVTOBreakpointPropertiesAction action = new QVTOBreakpointPropertiesAction();
                    action.selectionChanged(null, (ISelection)new StructuredSelection((Object)breakpoint));
                    action.run(null);
                }
            }
        });
    }

    private void suspendDebugUI(final IDebugTarget target) {
        QVTODebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                try {
                    IThread mainThread;
                    IThread[] threads = target.getThreads();
                    IThread iThread = mainThread = threads.length > 0 ? threads[0] : null;
                    if (mainThread != null) {
                        DebugEvent debugEvent = new DebugEvent((Object)mainThread, 2, 16);
                        DebugPlugin.getDefault().fireDebugEventSet(new DebugEvent[]{debugEvent});
                    }
                }
                catch (DebugException e) {
                    QVTODebugUIPlugin.log(e.getStatus());
                }
            }
        });
    }

    private static class CondErrorDialog
    extends ErrorDialog {
        CondErrorDialog(Shell parentShell, String message, IStatus status) {
            super(parentShell, DebugUIMessages.BreakpointCondErrorHandler_DialogTitle, message, status, 4);
        }

        protected void createButtonsForButtonBar(Composite parent) {
            this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
            this.createButton(parent, 0, DebugUIMessages.BreakpointCondErrorHandler_EditConditionButtonLabel, true);
        }
    }
}

