/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.compare.rcp.ui.tests.match;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.compare.EMFCompare;
import org.eclipse.emf.compare.match.IMatchEngine;
import org.eclipse.emf.compare.match.impl.MatchEngineFactoryImpl;
import org.eclipse.emf.compare.rcp.EMFCompareRCPPlugin;
import org.eclipse.emf.compare.rcp.internal.extension.impl.EMFCompareBuilderConfigurator;
import org.eclipse.emf.compare.rcp.ui.tests.match.data.EcoreInputData;
import org.eclipse.emf.compare.scope.DefaultComparisonScope;
import org.eclipse.emf.compare.scope.IComparisonScope;
import org.eclipse.ui.preferences.ScopedPreferenceStore;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.osgi.service.prefs.BackingStoreException;

public class RCPMatchEngineFactoryRegistryTest {
    private IMatchEngine.Factory.Registry registryWrapper;
    private ScopedPreferenceStore preferenceStore;

    private IComparisonScope createComparisonScope() throws IOException {
        EcoreInputData ecoreData = new EcoreInputData();
        return new DefaultComparisonScope((Notifier)ecoreData.getLeft(), (Notifier)ecoreData.getRight(), (Notifier)ecoreData.getOrigin());
    }

    @Before
    public void setUp() throws BackingStoreException {
        this.preferenceStore = new ScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.emf.compare.rcp");
        this.registryWrapper = EMFCompareRCPPlugin.getDefault().getMatchEngineFactoryRegistry();
    }

    @After
    public void tearDown() throws BackingStoreException {
        IEclipsePreferences[] iEclipsePreferencesArray = this.preferenceStore.getPreferenceNodes(false);
        int n = iEclipsePreferencesArray.length;
        int n2 = 0;
        while (n2 < n) {
            IEclipsePreferences prefs = iEclipsePreferencesArray[n2];
            prefs.clear();
            ++n2;
        }
    }

    @Test
    public void testAdd() throws IOException {
        MockMatchEngineFactory1 factory = new MockMatchEngineFactory1();
        factory.setRanking(50);
        this.registryWrapper.add((IMatchEngine.Factory)factory);
        IComparisonScope createComparisonScope = this.createComparisonScope();
        Assert.assertSame((Object)this.registryWrapper.getHighestRankingMatchEngineFactory(createComparisonScope), (Object)((Object)factory));
        Assert.assertEquals((long)this.registryWrapper.getMatchEngineFactories(createComparisonScope).size(), (long)4L);
    }

    @Test
    public void testAddFactoryWithNoRanking() throws IOException {
        MockMatchEngineFactory1 factory = new MockMatchEngineFactory1();
        this.registryWrapper.add((IMatchEngine.Factory)factory);
        MockMatchEngineFactory2 factory2 = new MockMatchEngineFactory2();
        factory2.setRanking(50);
        this.registryWrapper.add((IMatchEngine.Factory)factory2);
        IComparisonScope createComparisonScope = this.createComparisonScope();
        Assert.assertSame((Object)this.registryWrapper.getHighestRankingMatchEngineFactory(createComparisonScope), (Object)((Object)factory2));
    }

    @Test(expected=NullPointerException.class)
    public void testAddNull() {
        this.registryWrapper.add(null);
    }

    @Test
    public void testAddSameID() throws IOException {
        MockMatchEngineFactory1 factory1 = new MockMatchEngineFactory1();
        factory1.setRanking(50);
        this.registryWrapper.add((IMatchEngine.Factory)factory1);
        MockMatchEngineFactory1 factory2 = new MockMatchEngineFactory1();
        factory2.setRanking(50);
        IMatchEngine.Factory oldValue = this.registryWrapper.add((IMatchEngine.Factory)factory2);
        Assert.assertSame((Object)oldValue, (Object)((Object)factory1));
        IComparisonScope createComparisonScope = this.createComparisonScope();
        Assert.assertSame((Object)this.registryWrapper.getHighestRankingMatchEngineFactory(createComparisonScope), (Object)((Object)factory2));
    }

    @Test
    public void testHighestRankingMatchEngineFactory() throws IOException {
        MockMatchEngineFactory1 factory = new MockMatchEngineFactory1();
        factory.setRanking(10);
        this.registryWrapper.add((IMatchEngine.Factory)factory);
        MockMatchEngineFactory2 factory2 = new MockMatchEngineFactory2();
        factory2.setRanking(20);
        this.registryWrapper.add((IMatchEngine.Factory)factory2);
        MockMatchEngineFactory3 factory3 = new MockMatchEngineFactory3();
        factory3.setRanking(30);
        this.registryWrapper.add((IMatchEngine.Factory)factory3);
        IComparisonScope scope = this.createComparisonScope();
        Assert.assertSame((Object)this.registryWrapper.getHighestRankingMatchEngineFactory(scope), (Object)((Object)factory3));
        Assert.assertTrue((boolean)this.registryWrapper.getMatchEngineFactories(scope).containsAll(Lists.newArrayList((Object[])new IMatchEngine.Factory[]{factory, factory2, factory3})));
    }

    @Test
    public void testHighestRankingMatchEngineFactoryWithDisabledFactories() throws IOException {
        MockMatchEngineFactory1 factory = new MockMatchEngineFactory1();
        factory.setRanking(10);
        this.registryWrapper.add((IMatchEngine.Factory)factory);
        MockMatchEngineFactory2 factory2 = new MockMatchEngineFactory2();
        factory2.setRanking(20);
        this.registryWrapper.add((IMatchEngine.Factory)factory2);
        MockMatchEngineFactory3 factory3 = new MockMatchEngineFactory3();
        factory3.setRanking(30);
        this.registryWrapper.add((IMatchEngine.Factory)factory3);
        MockDisabledMatchEngineFactory1 disabledFactory1 = new MockDisabledMatchEngineFactory1(null, null);
        disabledFactory1.setRanking(40);
        this.registryWrapper.add((IMatchEngine.Factory)disabledFactory1);
        MockDisabledMatchEngineFactory2 disabledFactory2 = new MockDisabledMatchEngineFactory2();
        disabledFactory2.setRanking(50);
        this.registryWrapper.add((IMatchEngine.Factory)disabledFactory2);
        MockDisabledMatchEngineFactory3 disabledFactory3 = new MockDisabledMatchEngineFactory3();
        disabledFactory2.setRanking(60);
        this.registryWrapper.add((IMatchEngine.Factory)disabledFactory3);
        IComparisonScope scope = this.createComparisonScope();
        Assert.assertSame((Object)this.registryWrapper.getHighestRankingMatchEngineFactory(scope), (Object)((Object)factory3));
        Assert.assertTrue((boolean)this.registryWrapper.getMatchEngineFactories(scope).containsAll(Lists.newArrayList((Object[])new IMatchEngine.Factory[]{factory, factory2, factory3})));
    }

    @Test
    public void testRemove() throws IOException {
        MockMatchEngineFactory1 factory = new MockMatchEngineFactory1();
        factory.setRanking(50);
        this.registryWrapper.add((IMatchEngine.Factory)factory);
        IMatchEngine.Factory oldValue = this.registryWrapper.remove(MockMatchEngineFactory1.class.getName());
        Assert.assertSame((Object)oldValue, (Object)((Object)factory));
        Assert.assertFalse((boolean)this.registryWrapper.getMatchEngineFactories(this.createComparisonScope()).contains((Object)factory));
    }

    @Test(expected=NullPointerException.class)
    public void testRemoveNull() {
        this.registryWrapper.remove(null);
    }

    @Test
    public void testRemoveWrongID() throws IOException {
        MockMatchEngineFactory1 factory = new MockMatchEngineFactory1();
        factory.setRanking(10);
        this.registryWrapper.add((IMatchEngine.Factory)factory);
        IMatchEngine.Factory oldValue = this.registryWrapper.remove("IncohereId");
        Assert.assertNull((Object)oldValue);
        Assert.assertTrue((!this.registryWrapper.getMatchEngineFactories(this.createComparisonScope()).isEmpty() ? 1 : 0) != 0);
    }

    @Test
    public void testDisablingMatchEngine() throws IOException {
        MockMatchEngineFactory1 factory = new MockMatchEngineFactory1();
        factory.setRanking(10);
        this.registryWrapper.add((IMatchEngine.Factory)factory);
        MockMatchEngineFactory2 factory2 = new MockMatchEngineFactory2();
        factory2.setRanking(20);
        this.registryWrapper.add((IMatchEngine.Factory)factory2);
        MockMatchEngineFactory3 factory3 = new MockMatchEngineFactory3();
        factory3.setRanking(30);
        this.registryWrapper.add((IMatchEngine.Factory)factory3);
        IComparisonScope scope = this.createComparisonScope();
        Assert.assertSame((Object)this.registryWrapper.getHighestRankingMatchEngineFactory(scope), (Object)((Object)factory3));
        this.disableEngine("org.eclipse.emf.compare.preference.match.engine", Collections.singleton(((Object)((Object)factory3)).getClass().getName()));
        Assert.assertSame((Object)this.registryWrapper.getHighestRankingMatchEngineFactory(scope), (Object)((Object)factory2));
        Assert.assertTrue((!this.registryWrapper.getMatchEngineFactories(scope).contains((Object)factory3) ? 1 : 0) != 0);
        this.disableEngine("org.eclipse.emf.compare.preference.match.engine", Lists.newArrayList((Object[])new String[]{((Object)((Object)factory3)).getClass().getName(), ((Object)((Object)factory2)).getClass().getName()}));
        Assert.assertSame((Object)this.registryWrapper.getHighestRankingMatchEngineFactory(scope), (Object)((Object)factory));
        Assert.assertTrue((!this.registryWrapper.getMatchEngineFactories(scope).contains((Object)factory2) ? 1 : 0) != 0);
    }

    @Test
    public void testEMFCompareBuilder() throws IOException {
        MockMatchEngineFactory1 factory = new MockMatchEngineFactory1();
        factory.setRanking(10);
        this.registryWrapper.add((IMatchEngine.Factory)factory);
        MockMatchEngineFactory2 factory2 = new MockMatchEngineFactory2();
        factory2.setRanking(20);
        this.registryWrapper.add((IMatchEngine.Factory)factory2);
        MockMatchEngineFactory3 factory3 = new MockMatchEngineFactory3();
        factory3.setRanking(30);
        this.registryWrapper.add((IMatchEngine.Factory)factory3);
        MockBuilder mockBuilder = new MockBuilder();
        mockBuilder.build();
        IMatchEngine.Factory.Registry builderMatchEngineFactoryRegistry = mockBuilder.getMatchEngineFactoryRegistry();
        Assert.assertNotSame((Object)this.registryWrapper, (Object)builderMatchEngineFactoryRegistry);
        EMFCompareBuilderConfigurator.createDefault().configure((EMFCompare.Builder)mockBuilder);
        mockBuilder.build();
        builderMatchEngineFactoryRegistry = mockBuilder.getMatchEngineFactoryRegistry();
        Assert.assertSame((Object)this.registryWrapper, (Object)builderMatchEngineFactoryRegistry);
    }

    private void disableEngine(String key, Collection<String> toDisable) {
        if (toDisable != null && !toDisable.isEmpty()) {
            String newPreferenceValue = Joiner.on((String)";").join(toDisable);
            this.preferenceStore.setValue(key, newPreferenceValue);
        } else {
            this.preferenceStore.setToDefault(key);
        }
    }

    private static class MockBuilder
    extends EMFCompare.Builder {
        private MockBuilder() {
        }

        public IMatchEngine.Factory.Registry getMatchEngineFactoryRegistry() {
            return this.matchEngineFactoryRegistry;
        }
    }

    private static class MockDisabledMatchEngineFactory1
    extends MatchEngineFactoryImpl {
        private MockDisabledMatchEngineFactory1() {
        }

        public boolean isMatchEngineFactoryFor(IComparisonScope scope) {
            return false;
        }

        /* synthetic */ MockDisabledMatchEngineFactory1(MockDisabledMatchEngineFactory1 mockDisabledMatchEngineFactory1, MockDisabledMatchEngineFactory1 mockDisabledMatchEngineFactory12) {
            this();
        }
    }

    private static class MockDisabledMatchEngineFactory2
    extends MockDisabledMatchEngineFactory1 {
        private MockDisabledMatchEngineFactory2() {
        }
    }

    private static class MockDisabledMatchEngineFactory3
    extends MockDisabledMatchEngineFactory1 {
        private MockDisabledMatchEngineFactory3() {
        }
    }

    private static class MockMatchEngineFactory1
    extends MatchEngineFactoryImpl {
        private MockMatchEngineFactory1() {
        }
    }

    private static class MockMatchEngineFactory2
    extends MatchEngineFactoryImpl {
        private MockMatchEngineFactory2() {
        }
    }

    private static class MockMatchEngineFactory3
    extends MatchEngineFactoryImpl {
        private MockMatchEngineFactory3() {
        }
    }
}

