/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.mapper;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.teneo.annotations.mapper.BaseEFeatureAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.StoreMappingException;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEStructuralFeature;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.JoinTable;
import org.eclipse.emf.teneo.annotations.pannotation.ManyToMany;
import org.eclipse.emf.teneo.annotations.pannotation.PAnnotation;
import org.eclipse.emf.teneo.extension.ExtensionPoint;

public class BidirectionalManyToManyAnnotator
extends BaseEFeatureAnnotator
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(BidirectionalManyToManyAnnotator.class);

    public void annotate(PAnnotatedEReference aReference) {
        List<String> names;
        JoinTable joinTable;
        boolean mtmWasSet;
        String featureLogStr = String.valueOf(aReference.getModelEReference().getName()) + "/" + aReference.getModelEReference().getEContainingClass().getName();
        if (aReference.getOneToMany() != null || aReference.getOneToOne() != null || aReference.getManyToOne() != null) {
            throw new StoreMappingException("The feature/eclass " + featureLogStr + " should be a ManyToMany but " + "it already has a OneToMany, OneToOne or ManyToOne annotation");
        }
        EReference eReference = (EReference)aReference.getModelElement();
        EReference eOpposite = eReference.getEOpposite();
        assert (eOpposite != null && eOpposite.isMany());
        ManyToMany mtm = aReference.getManyToMany();
        boolean bl = mtmWasSet = mtm != null;
        if (mtm == null) {
            log.debug((Object)("Adding manytomany annotations to ereference: " + featureLogStr));
            mtm = this.getFactory().createManyToMany();
            aReference.setManyToMany(mtm);
            mtm.setEModelElement((EModelElement)eReference);
        } else {
            log.debug((Object)"ManyToMany present check if default information should be added");
        }
        if (eReference.isContainment() || this.getPersistenceOptions().isSetDefaultCascadeOnNonContainment()) {
            this.setCascade((List<CascadeType>)mtm.getCascade(), eReference.isContainment());
        }
        if (mtm.getTargetEntity() == null) {
            mtm.setTargetEntity(this.getEntityName(eReference.getEReferenceType()));
        }
        if (this.getPersistenceOptions().isSetForeignKeyNames() && aReference.getForeignKey() == null) {
            aReference.setForeignKey(this.createFK((PAnnotatedEStructuralFeature)aReference));
        }
        PAnnotatedEReference otherPA = aReference.getPaModel().getPAnnotated(eOpposite);
        if (mtm.getMappedBy() == null && this.setMappedBy(eReference) && (otherPA.getManyToMany() == null || otherPA.getManyToMany().getMappedBy() == null)) {
            mtm.setMappedBy(eOpposite.getName());
        }
        if ((joinTable = aReference.getJoinTable()) == null) {
            joinTable = this.getFactory().createJoinTable();
            aReference.setJoinTable(joinTable);
        }
        joinTable.setEModelElement((EModelElement)eReference);
        if (!mtmWasSet) {
            log.debug((Object)"Setting indexed and unique from ereference.isOrdered/isUnique because mtm was not set manually!");
            mtm.setIndexed(!this.getPersistenceOptions().alwaysMapListAsBag() && eReference.isOrdered());
        }
        if (joinTable.getName() == null) {
            joinTable.setName(this.getSqlNameStrategy().getJoinTableName(aReference));
        }
        if (joinTable.getJoinColumns().size() == 0) {
            names = this.getSqlNameStrategy().getJoinTableJoinColumns(aReference, false);
            joinTable.getJoinColumns().addAll(this.getJoinColumns(names, false, true, (PAnnotation)mtm));
        }
        if (joinTable.getInverseJoinColumns().size() == 0) {
            names = this.getSqlNameStrategy().getJoinTableJoinColumns(aReference, true);
            joinTable.getInverseJoinColumns().addAll(this.getJoinColumns(names, false, true, (PAnnotation)mtm));
        }
    }
}

