/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.jpox.mapper.association;

import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEReference;
import org.eclipse.emf.teneo.annotations.pannotation.CascadeType;
import org.eclipse.emf.teneo.annotations.pannotation.ManyToMany;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.jpox.mapper.MappingUtil;
import org.eclipse.emf.teneo.jpox.mapper.association.AssociationMapper;
import org.eclipse.emf.teneo.simpledom.Element;

public class ManyToManyMapper
extends AssociationMapper
implements ExtensionPoint {
    protected static final Log log = LogFactory.getLog(ManyToManyMapper.class);

    public void map(Element eclassElement, PAnnotatedEReference aReference) {
        log.debug((Object)("Processing many to many ereference: " + aReference.getModelElement().getName()));
        EReference eReference = (EReference)aReference.getModelElement();
        EList cascade = aReference.getManyToMany().getCascade();
        boolean cascadeRemove = cascade.contains(CascadeType.ALL) || cascade.contains(CascadeType.REMOVE);
        log.debug((Object)("Cascaderemove " + cascadeRemove));
        if (cascadeRemove) {
            log.warn((Object)"Cascade (all) remove on a many to many relation is an unlikely case");
        }
        Element field = eclassElement.addElement("field");
        field.addAttribute("name", this.namingHandler.correctName(this.mappingContext, (EStructuralFeature)eReference)).addAttribute("persistence-modifier", "persistent");
        if (eReference.getEOpposite() != null && eReference.getEOpposite().isContainment()) {
            field.addAttribute("delete-action", "cascade");
        } else {
            field.addAttribute("delete-action", "restrict");
        }
        ManyToMany mtm = aReference.getManyToMany();
        if (mtm.getMappedBy() != null) {
            aReference.getModelEReference().isContainment();
        }
        Element collection = field.addElement("collection");
        MappingUtil.addEagerLazyLoading(collection, mtm.getFetch());
        Element joinElement = field.addElement("join");
        if (aReference.getJoinTable() != null) {
            log.warn((Object)"JPOX does currently not support a specific table setting for many-to-many table name ignored");
        }
        if (aReference.getJoinColumns() != null && aReference.getJoinColumns().size() > 0) {
            this.mappingContext.getJoinColumnMapper().map((List)aReference.getJoinColumns(), joinElement);
        }
        collection.addAttribute("element-type", MappingUtil.getImplNameOfEClass(aReference.getManyToMany().getTargetEntity(), this.mappingContext));
        if (cascadeRemove) {
            collection.addAttribute("dependent-element", "true");
        } else {
            collection.addAttribute("dependent-element", "false");
        }
    }
}

