/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.samples.emf.schemaconstructs.listunion.util;

import java.math.BigInteger;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.listunion.ListunionPackage;
import org.eclipse.emf.teneo.samples.emf.schemaconstructs.listunion.statesByCountry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListunionValidator
extends EObjectValidator {
    public static final ListunionValidator INSTANCE = new ListunionValidator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.emf.teneo.samples.emf.schemaconstructs.listunion";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;
    public static final Collection SIMPLE_UNION_TYPE_MEMBER1__ENUMERATION__VALUES = ListunionValidator.wrapEnumerationValues((Object[])new Object[]{"N/A"});

    protected EPackage getEPackage() {
        return ListunionPackage.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map<Object, Object> context) {
        switch (classifierID) {
            case 0: {
                return this.validatestatesByCountry((statesByCountry)value, diagnostics, context);
            }
            case 1: {
                return this.validateSimpleStringUnionType((String)value, diagnostics, context);
            }
            case 2: {
                return this.validateSimpleStringUnionTypeMember0((String)value, diagnostics, context);
            }
            case 3: {
                return this.validateSimpleStringUnionTypeMember1((String)value, diagnostics, context);
            }
            case 4: {
                return this.validateSimpleUnionType(value, diagnostics, context);
            }
            case 5: {
                return this.validateSimpleUnionTypeMember0((BigInteger)value, diagnostics, context);
            }
            case 6: {
                return this.validateSimpleUnionTypeMember1((String)value, diagnostics, context);
            }
            case 7: {
                return this.validateSixStatesList((List)value, diagnostics, context);
            }
            case 8: {
                return this.validateState((String)value, diagnostics, context);
            }
            case 9: {
                return this.validateStateList((List)value, diagnostics, context);
            }
            case 10: {
                return this.validateStringList((List)value, diagnostics, context);
            }
            case 11: {
                return this.validateZipCode((String)value, diagnostics, context);
            }
            case 12: {
                return this.validateZipUnionsType((String)value, diagnostics, context);
            }
            case 13: {
                return this.validateZipUnionType((String)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validatestatesByCountry(statesByCountry statesByCountry2, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return this.validate_EveryDefaultConstraint(statesByCountry2, diagnostics, context);
    }

    public boolean validateSimpleStringUnionType(String simpleStringUnionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateSimpleStringUnionType_MemberTypes(simpleStringUnionType, diagnostics, context);
        return result;
    }

    public boolean validateSimpleStringUnionType_MemberTypes(String simpleStringUnionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            BasicDiagnostic tempDiagnostics = new BasicDiagnostic();
            if (ListunionPackage.Literals.SIMPLE_STRING_UNION_TYPE_MEMBER0.isInstance((Object)simpleStringUnionType) && this.validateSimpleStringUnionTypeMember0(simpleStringUnionType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (ListunionPackage.Literals.SIMPLE_STRING_UNION_TYPE_MEMBER1.isInstance((Object)simpleStringUnionType) && this.validateSimpleStringUnionTypeMember1(simpleStringUnionType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            for (Diagnostic diagnostic : tempDiagnostics.getChildren()) {
                diagnostics.add(diagnostic);
            }
        } else {
            if (ListunionPackage.Literals.SIMPLE_STRING_UNION_TYPE_MEMBER0.isInstance((Object)simpleStringUnionType) && this.validateSimpleStringUnionTypeMember0(simpleStringUnionType, null, context)) {
                return true;
            }
            if (ListunionPackage.Literals.SIMPLE_STRING_UNION_TYPE_MEMBER1.isInstance((Object)simpleStringUnionType) && this.validateSimpleStringUnionTypeMember1(simpleStringUnionType, null, context)) {
                return true;
            }
        }
        return false;
    }

    public boolean validateSimpleStringUnionTypeMember0(String simpleStringUnionTypeMember0, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateSimpleStringUnionTypeMember0_MinLength(simpleStringUnionTypeMember0, diagnostics, context);
        return result;
    }

    public boolean validateSimpleStringUnionTypeMember0_MinLength(String simpleStringUnionTypeMember0, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = simpleStringUnionTypeMember0.length();
        boolean bl = result = length >= 1;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(ListunionPackage.Literals.SIMPLE_STRING_UNION_TYPE_MEMBER0, simpleStringUnionTypeMember0, length, 1, diagnostics, context);
        }
        return result;
    }

    public boolean validateSimpleStringUnionTypeMember1(String simpleStringUnionTypeMember1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateSimpleStringUnionTypeMember1_MaxLength(simpleStringUnionTypeMember1, diagnostics, context);
        return result;
    }

    public boolean validateSimpleStringUnionTypeMember1_MaxLength(String simpleStringUnionTypeMember1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = simpleStringUnionTypeMember1.length();
        boolean bl = result = length <= 5;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(ListunionPackage.Literals.SIMPLE_STRING_UNION_TYPE_MEMBER1, simpleStringUnionTypeMember1, length, 5, diagnostics, context);
        }
        return result;
    }

    public boolean validateSimpleUnionType(Object simpleUnionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateSimpleUnionType_MemberTypes(simpleUnionType, diagnostics, context);
        return result;
    }

    public boolean validateSimpleUnionType_MemberTypes(Object simpleUnionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            BasicDiagnostic tempDiagnostics = new BasicDiagnostic();
            if (ListunionPackage.Literals.SIMPLE_UNION_TYPE_MEMBER0.isInstance(simpleUnionType) && this.validateSimpleUnionTypeMember0((BigInteger)simpleUnionType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (ListunionPackage.Literals.SIMPLE_UNION_TYPE_MEMBER1.isInstance(simpleUnionType) && this.validateSimpleUnionTypeMember1((String)simpleUnionType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            for (Diagnostic diagnostic : tempDiagnostics.getChildren()) {
                diagnostics.add(diagnostic);
            }
        } else {
            if (ListunionPackage.Literals.SIMPLE_UNION_TYPE_MEMBER0.isInstance(simpleUnionType) && this.validateSimpleUnionTypeMember0((BigInteger)simpleUnionType, null, context)) {
                return true;
            }
            if (ListunionPackage.Literals.SIMPLE_UNION_TYPE_MEMBER1.isInstance(simpleUnionType) && this.validateSimpleUnionTypeMember1((String)simpleUnionType, null, context)) {
                return true;
            }
        }
        return false;
    }

    public boolean validateSimpleUnionTypeMember0(BigInteger simpleUnionTypeMember0, DiagnosticChain diagnostics, Map<Object, Object> context) {
        return true;
    }

    public boolean validateSimpleUnionTypeMember1(String simpleUnionTypeMember1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateSimpleUnionTypeMember1_Enumeration(simpleUnionTypeMember1, diagnostics, context);
        return result;
    }

    public boolean validateSimpleUnionTypeMember1_Enumeration(String simpleUnionTypeMember1, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = SIMPLE_UNION_TYPE_MEMBER1__ENUMERATION__VALUES.contains(simpleUnionTypeMember1);
        if (!result && diagnostics != null) {
            this.reportEnumerationViolation(ListunionPackage.Literals.SIMPLE_UNION_TYPE_MEMBER1, simpleUnionTypeMember1, SIMPLE_UNION_TYPE_MEMBER1__ENUMERATION__VALUES, diagnostics, context);
        }
        return result;
    }

    public boolean validateSixStatesList(List<?> sixStatesList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateStateList_ItemType(sixStatesList, diagnostics, context);
        if (result || diagnostics != null) {
            result &= this.validateSixStatesList_MinLength(sixStatesList, diagnostics, context);
        }
        if (result || diagnostics != null) {
            result &= this.validateSixStatesList_MaxLength(sixStatesList, diagnostics, context);
        }
        return result;
    }

    public boolean validateSixStatesList_MinLength(List<?> sixStatesList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = sixStatesList.size();
        boolean bl = result = length >= 6;
        if (!result && diagnostics != null) {
            this.reportMinLengthViolation(ListunionPackage.Literals.SIX_STATES_LIST, sixStatesList, length, 6, diagnostics, context);
        }
        return result;
    }

    public boolean validateSixStatesList_MaxLength(List<?> sixStatesList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = sixStatesList.size();
        boolean bl = result = length <= 6;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(ListunionPackage.Literals.SIX_STATES_LIST, sixStatesList, length, 6, diagnostics, context);
        }
        return result;
    }

    public boolean validateState(String state, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateState_MaxLength(state, diagnostics, context);
        return result;
    }

    public boolean validateState_MaxLength(String state, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = state.length();
        boolean bl = result = length <= 12;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(ListunionPackage.Literals.STATE, state, length, 12, diagnostics, context);
        }
        return result;
    }

    public boolean validateStateList(List<?> stateList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateStateList_ItemType(stateList, diagnostics, context);
        return result;
    }

    public boolean validateStateList_ItemType(List<?> stateList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<?> i = stateList.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (ListunionPackage.Literals.STATE.isInstance(item)) {
                result &= this.validateState((String)item, diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(ListunionPackage.Literals.STATE, item, diagnostics, context);
        }
        return result;
    }

    public boolean validateStringList(List<?> stringList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateStringList_ItemType(stringList, diagnostics, context);
        return result;
    }

    public boolean validateStringList_ItemType(List<?> stringList, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = true;
        Iterator<?> i = stringList.iterator();
        while (i.hasNext() && (result || diagnostics != null)) {
            Object item = i.next();
            if (XMLTypePackage.Literals.STRING.isInstance(item)) {
                result &= this.xmlTypeValidator.validateString((String)item, diagnostics, context);
                continue;
            }
            result = false;
            this.reportDataValueTypeViolation(XMLTypePackage.Literals.STRING, item, diagnostics, context);
        }
        return result;
    }

    public boolean validateZipCode(String zipCode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateZipCode_MaxLength(zipCode, diagnostics, context);
        return result;
    }

    public boolean validateZipCode_MaxLength(String zipCode, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result;
        int length = zipCode.length();
        boolean bl = result = length <= 6;
        if (!result && diagnostics != null) {
            this.reportMaxLengthViolation(ListunionPackage.Literals.ZIP_CODE, zipCode, length, 6, diagnostics, context);
        }
        return result;
    }

    public boolean validateZipUnionsType(String zipUnionsType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateZipUnionsType_MemberTypes(zipUnionsType, diagnostics, context);
        return result;
    }

    public boolean validateZipUnionsType_MemberTypes(String zipUnionsType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            BasicDiagnostic tempDiagnostics = new BasicDiagnostic();
            if (ListunionPackage.Literals.ZIP_CODE.isInstance((Object)zipUnionsType) && this.validateZipCode(zipUnionsType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (ListunionPackage.Literals.STATE.isInstance((Object)zipUnionsType) && this.validateState(zipUnionsType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            for (Diagnostic diagnostic : tempDiagnostics.getChildren()) {
                diagnostics.add(diagnostic);
            }
        } else {
            if (ListunionPackage.Literals.ZIP_CODE.isInstance((Object)zipUnionsType) && this.validateZipCode(zipUnionsType, null, context)) {
                return true;
            }
            if (ListunionPackage.Literals.STATE.isInstance((Object)zipUnionsType) && this.validateState(zipUnionsType, null, context)) {
                return true;
            }
        }
        return false;
    }

    public boolean validateZipUnionType(String zipUnionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        boolean result = this.validateZipUnionType_MemberTypes(zipUnionType, diagnostics, context);
        return result;
    }

    public boolean validateZipUnionType_MemberTypes(String zipUnionType, DiagnosticChain diagnostics, Map<Object, Object> context) {
        if (diagnostics != null) {
            BasicDiagnostic tempDiagnostics = new BasicDiagnostic();
            if (ListunionPackage.Literals.ZIP_CODE.isInstance((Object)zipUnionType) && this.validateZipCode(zipUnionType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            if (ListunionPackage.Literals.STATE.isInstance((Object)zipUnionType) && this.validateState(zipUnionType, (DiagnosticChain)tempDiagnostics, context)) {
                return true;
            }
            for (Diagnostic diagnostic : tempDiagnostics.getChildren()) {
                diagnostics.add(diagnostic);
            }
        } else {
            if (ListunionPackage.Literals.ZIP_CODE.isInstance((Object)zipUnionType) && this.validateZipCode(zipUnionType, null, context)) {
                return true;
            }
            if (ListunionPackage.Literals.STATE.isInstance((Object)zipUnionType) && this.validateState(zipUnionType, null, context)) {
                return true;
            }
        }
        return false;
    }
}

