/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.eclipse.emf.teneo.util.EcoreDataTypes;
import org.hibernate.HibernateException;
import org.hibernate.type.MutableType;

public class XSDDateTime
extends MutableType {
    static final long serialVersionUID = 1L;
    private final DatatypeFactory dataTypeFactory;

    public XSDDateTime() {
        try {
            this.dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new HbStoreException("Exception ", e);
        }
    }

    public int sqlType() {
        return 93;
    }

    public Object deepCopyNotNull(Object value) {
        return value;
    }

    public String getName() {
        return "xmldatetime";
    }

    public Class<?> getReturnedClass() {
        return XMLGregorianCalendar.class;
    }

    public boolean isEqual(Object x, Object y) throws HibernateException {
        if (x == y) {
            return true;
        }
        if (x == null || y == null) {
            return false;
        }
        if (x.getClass() != y.getClass()) {
            return false;
        }
        return x.equals(y);
    }

    public Object get(ResultSet resultSet, String name) throws SQLException {
        Timestamp ts = resultSet.getTimestamp(name);
        if (ts == null) {
            return null;
        }
        return EcoreDataTypes.INSTANCE.getXMLGregorianCalendarDateTime((Date)ts);
    }

    public void set(PreparedStatement statement, Object value, int index) throws SQLException {
        Timestamp d = new Timestamp(((XMLGregorianCalendar)value).toGregorianCalendar().getTime().getTime());
        statement.setTimestamp(index, d);
    }

    public String toString(Object val) {
        return ((XMLGregorianCalendar)val).toString();
    }

    public Object fromStringValue(String s) throws HibernateException {
        return this.dataTypeFactory.newXMLGregorianCalendar(s);
    }
}

