/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.annotations.mapper;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.annotations.mapper.AbstractAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.EClassAnnotator;
import org.eclipse.emf.teneo.annotations.mapper.EDataTypeAnnotator;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEClass;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEDataType;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedEPackage;
import org.eclipse.emf.teneo.annotations.pamodel.PAnnotatedModel;
import org.eclipse.emf.teneo.annotations.pannotation.PannotationFactory;
import org.eclipse.emf.teneo.ecore.EModelResolver;
import org.eclipse.emf.teneo.extension.ExtensionManager;
import org.eclipse.emf.teneo.extension.ExtensionManagerAware;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.mapping.strategy.EntityNameStrategy;
import org.eclipse.emf.teneo.mapping.strategy.SQLNameStrategy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationGenerator
implements ExtensionPoint,
ExtensionManagerAware {
    protected static final Log log = LogFactory.getLog(AnnotationGenerator.class);
    protected PersistenceOptions persistenceOptions;
    private ExtensionManager extensionManager;
    private final PannotationFactory aFactory = PannotationFactory.eINSTANCE;
    private PAnnotatedModel annotatedModel;
    private EClassAnnotator eClassAnnotator;
    private EDataTypeAnnotator eDataTypeAnnotator;

    public synchronized void map(PAnnotatedModel annotatedModel, PersistenceOptions po) {
        Object object;
        this.persistenceOptions = po;
        EList apacks = annotatedModel.getPaEPackages();
        EPackage[] epacks = new EPackage[apacks.size()];
        int cnt = 0;
        for (PAnnotatedEPackage apack : apacks) {
            epacks[cnt++] = apack.getModelEPackage();
        }
        EModelResolver eModelResolver = EModelResolver.instance();
        if (log.isDebugEnabled()) {
            log.debug((Object)("Registering epackages in model resolver, modelresolver instance is: " + eModelResolver.getClass().getName()));
        }
        eModelResolver.register(epacks);
        if (this.persistenceOptions.isAlsoMapAsClass()) {
            if (log.isDebugEnabled()) {
                log.debug((Object)"Class names are to be fully classified, registering all the epackages");
            }
            for (PAnnotatedEPackage apack : annotatedModel.getPaEPackages()) {
                object = apack.getPaEClasses().iterator();
                while (object.hasNext()) {
                    PAnnotatedEClass aclass;
                    aclass.setOnlyMapAsEntity(!eModelResolver.hasImplementationClass((EClassifier)(aclass = (PAnnotatedEClass)object.next()).getModelEClass()));
                }
            }
        }
        object = epacks;
        int aclass = epacks.length;
        int n = 0;
        while (n < aclass) {
            EPackage epack = object[n];
            if (epack.getNsURI() != null && epack.getNsURI().compareTo(EcorePackage.eINSTANCE.getNsURI()) == 0) {
                block4: for (EClassifier eClassifier : epack.getEClassifiers()) {
                    if (eClassifier.eClass() != EcorePackage.eINSTANCE.getEClass()) continue;
                    EClass eClass = (EClass)eClassifier;
                    for (EStructuralFeature eFeature : eClass.getEAllStructuralFeatures()) {
                        if (eFeature.getName().compareTo("eSuperTypes") != 0 || eFeature.getEAnnotation("teneo.jpa") != null) continue;
                        EcoreUtil.setAnnotation((EModelElement)eFeature, (String)"teneo.jpa", (String)"value", (String)"@ManyToMany");
                        continue block4;
                    }
                }
            }
            ++n;
        }
        annotatedModel.setInitialized(true);
        this.annotatedModel = annotatedModel;
        EntityNameStrategy entityNameStrategy = this.extensionManager.getExtension(EntityNameStrategy.class);
        entityNameStrategy.setPaModel(annotatedModel);
        SQLNameStrategy sqlNameStrategy = this.extensionManager.getExtension(SQLNameStrategy.class);
        sqlNameStrategy.setPersistenceOptions(po);
        this.setAnnotators();
        for (PAnnotatedEPackage pae : annotatedModel.getPaEPackages()) {
            this.processPackage(pae);
        }
    }

    protected void setAnnotators() {
        this.eClassAnnotator = this.createAnnotator(EClassAnnotator.class);
        this.eDataTypeAnnotator = this.createAnnotator(EDataTypeAnnotator.class);
    }

    private <T extends AbstractAnnotator> T createAnnotator(Class<T> clz) {
        AbstractAnnotator annotator = (AbstractAnnotator)this.extensionManager.getExtension(clz);
        annotator.setAnnotatedModel(this.annotatedModel);
        annotator.setExtensionManager(this.extensionManager);
        annotator.setPersistenceOptions(this.persistenceOptions);
        annotator.setFactory(this.aFactory);
        annotator.initialize();
        return (T)annotator;
    }

    protected void processPackage(PAnnotatedEPackage aPackage) {
        if (log.isDebugEnabled()) {
            log.debug((Object)(">>>> Adding default annotations for EPackage " + aPackage.getModelElement().getName()));
            log.debug((Object)"Processing EDataTypes");
        }
        for (PAnnotatedEDataType annotatedEDataType : aPackage.getPaEDataTypes()) {
            this.eDataTypeAnnotator.annotate(annotatedEDataType);
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)"Processing EClasses");
        }
        for (PAnnotatedEClass annotatedEClass : aPackage.getPaEClasses()) {
            this.eClassAnnotator.annotate(annotatedEClass);
        }
    }

    @Override
    public void setExtensionManager(ExtensionManager extensionManager) {
        this.extensionManager = extensionManager;
    }
}

