/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.hbannotation;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum OptimisticLockType implements Enumerator
{
    ALL(0, "ALL", "ALL"),
    DIRTY(1, "DIRTY", "DIRTY"),
    NONE(2, "NONE", "NONE"),
    VERSION(3, "VERSION", "VERSION");

    public static final int ALL_VALUE = 0;
    public static final int DIRTY_VALUE = 1;
    public static final int NONE_VALUE = 2;
    public static final int VERSION_VALUE = 3;
    private static final OptimisticLockType[] VALUES_ARRAY;
    public static final List<OptimisticLockType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    static {
        VALUES_ARRAY = new OptimisticLockType[]{ALL, DIRTY, NONE, VERSION};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }

    public static OptimisticLockType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OptimisticLockType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OptimisticLockType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            OptimisticLockType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static OptimisticLockType get(int value) {
        switch (value) {
            case 0: {
                return ALL;
            }
            case 1: {
                return DIRTY;
            }
            case 2: {
                return NONE;
            }
            case 3: {
                return VERSION;
            }
        }
        return null;
    }

    private OptimisticLockType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }
}

