/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.auditing;

import java.io.Serializable;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.util.Collection;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.common.util.Enumerator;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EModelElement;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.EcoreFactory;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.util.ExtendedMetaData;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.util.FeatureMapUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.emf.teneo.PersistenceOptions;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.eclipse.emf.teneo.hibernate.auditing.AuditDataStore;
import org.eclipse.emf.teneo.hibernate.auditing.AuditReference;
import org.eclipse.emf.teneo.hibernate.auditing.AuditVersionProvider;
import org.eclipse.emf.teneo.hibernate.auditing.model.teneoauditing.TeneoAuditEntry;
import org.eclipse.emf.teneo.hibernate.auditing.model.teneoauditing.TeneoauditingPackage;
import org.eclipse.emf.teneo.util.StoreUtil;
import org.hibernate.Session;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

public class AuditHandler
implements ExtensionPoint {
    private static Log log = LogFactory.getLog(AuditHandler.class);
    public static final String ID_SEPARATOR = ";";
    private final ConcurrentHashMap<String, Constructor<?>> constructors = new ConcurrentHashMap();
    private AuditDataStore dataStore;
    private static boolean inTest = false;

    public static void inTest() {
        inTest = true;
    }

    public void setContainerInfo(Session session, TeneoAuditEntry teneoAuditEntry, Object object) {
        EObject eObject = (EObject)object;
        if (eObject.eContainer() != null) {
            teneoAuditEntry.setTeneo_container_id(this.entityToIdString(session, eObject.eContainer()));
            int containerFeatureId = ((InternalEObject)eObject).eContainerFeatureID();
            teneoAuditEntry.setTeneo_container_feature_id(containerFeatureId);
            EStructuralFeature eContainingFeature = eObject.eContainingFeature();
            int computedContainingFeatureId = AuditVersionProvider.getContainingFeatureId(eObject, eObject.eContainer(), eContainingFeature);
            if (computedContainingFeatureId != containerFeatureId) {
                if (inTest) {
                    throw new IllegalStateException("Container feature id computation is not working correctly, " + computedContainingFeatureId + " - " + containerFeatureId + eObject.eClass().getName() + " - " + eObject.eClass().getName() + " - " + eObject.eContainingFeature().getName());
                }
                log.error((Object)("Container feature id computation is not working correctly, " + computedContainingFeatureId + " - " + containerFeatureId + eObject.eClass().getName() + " - " + eObject.eClass().getName() + " - " + eObject.eContainingFeature().getName()));
            }
            teneoAuditEntry.setTeneo_container_feature_name(eObject.eContainingFeature().getName());
        }
    }

    public boolean isAudited(Object entity) {
        if (!(entity instanceof EObject)) {
            return false;
        }
        if (!this.dataStore.isAuditing()) {
            return false;
        }
        EObject eObject = (EObject)entity;
        EClass auditEClass = this.getAuditingModelElement(eObject.eClass());
        return auditEClass != null;
    }

    public EClass getEClass(Object o) {
        return ((EObject)o).eClass();
    }

    public void copyContentToAuditEntry(Session session, Object object, TeneoAuditEntry auditEntry, boolean copyCollections) {
        EObject source = (EObject)object;
        EClass sourceEClass = source.eClass();
        EClass targetEClass = auditEntry.eClass();
        for (EStructuralFeature targetEFeature : targetEClass.getEAllStructuralFeatures()) {
            EStructuralFeature sourceEFeature;
            if (!copyCollections && targetEFeature.isMany()) continue;
            if (targetEFeature.getEType().getInstanceClass() != null && targetEFeature.getEType().getInstanceClass().isArray()) {
                auditEntry.eSet(targetEFeature, Array.newInstance(targetEFeature.getEType().getInstanceClass().getComponentType(), 0));
            }
            if ((sourceEFeature = sourceEClass.getEStructuralFeature(targetEFeature.getName())) == null || !sourceEFeature.isMany() && !source.eIsSet(sourceEFeature)) continue;
            if (targetEFeature instanceof EAttribute && sourceEFeature instanceof EReference) {
                if (sourceEFeature.isMany()) {
                    for (Object value : (Collection)source.eGet(sourceEFeature)) {
                        String idAsString = this.entityToIdString(session, value);
                        ((Collection)auditEntry.eGet(targetEFeature)).add(idAsString);
                    }
                    continue;
                }
                String idAsString = this.entityToIdString(session, source.eGet(sourceEFeature));
                auditEntry.eSet(targetEFeature, idAsString);
                continue;
            }
            if (sourceEFeature.isMany()) {
                if (StoreUtil.isMap((EStructuralFeature)sourceEFeature)) {
                    this.convertEMap(session, (Collection)source.eGet(sourceEFeature), (EReference)sourceEFeature, auditEntry, (EReference)targetEFeature);
                    continue;
                }
                if (FeatureMapUtil.isFeatureMap((EStructuralFeature)sourceEFeature)) {
                    this.convertFeatureMap(session, (Collection)source.eGet(sourceEFeature), sourceEFeature, auditEntry, targetEFeature);
                    continue;
                }
                for (Object value : (Collection)source.eGet(sourceEFeature)) {
                    ((Collection)auditEntry.eGet(targetEFeature)).add(this.convertValue(targetEFeature, value));
                }
                continue;
            }
            auditEntry.eSet(targetEFeature, this.convertValue(targetEFeature, source.eGet(sourceEFeature)));
        }
    }

    protected void convertEMap(Session session, Collection<?> values, EReference sourceEReference, TeneoAuditEntry auditEntry, EReference targetEReference) {
        EStructuralFeature keySourceEFeature = sourceEReference.getEReferenceType().getEStructuralFeature("key");
        EStructuralFeature valueSourceEFeature = sourceEReference.getEReferenceType().getEStructuralFeature("value");
        EStructuralFeature keyTargetEFeature = targetEReference.getEReferenceType().getEStructuralFeature("key");
        EStructuralFeature valueTargetEFeature = targetEReference.getEReferenceType().getEStructuralFeature("value");
        for (Object sourceEntry : values) {
            EObject sourceMapEntry = (EObject)sourceEntry;
            EObject mapEntry = EcoreUtil.create((EClass)targetEReference.getEReferenceType());
            Object key = keySourceEFeature instanceof EReference ? this.entityToIdString(session, sourceMapEntry.eGet(keySourceEFeature)) : this.convertValue(keyTargetEFeature, sourceMapEntry.eGet(keySourceEFeature));
            Object value = valueSourceEFeature instanceof EReference ? this.entityToIdString(session, sourceMapEntry.eGet(valueSourceEFeature)) : this.convertValue(valueTargetEFeature, sourceMapEntry.eGet(valueSourceEFeature));
            mapEntry.eSet(keyTargetEFeature, key);
            mapEntry.eSet(valueTargetEFeature, value);
            ((Collection)auditEntry.eGet((EStructuralFeature)targetEReference)).add(mapEntry);
        }
    }

    protected void convertFeatureMap(Session session, Collection<?> values, EStructuralFeature sourceEFeature, TeneoAuditEntry auditEntry, EStructuralFeature targetEFeature) {
        for (Object value : values) {
            FeatureMap.Entry sourceEntry = (FeatureMap.Entry)value;
            EStructuralFeature targetEntryFeature = this.getAuditingModelElement(sourceEntry.getEStructuralFeature(), auditEntry.eClass().getName());
            FeatureMap.Entry targetEntry = this.createFeatureMapEntry(session, targetEntryFeature, sourceEntry);
            ((Collection)auditEntry.eGet(targetEFeature)).add(targetEntry);
        }
    }

    public Object convertValue(EStructuralFeature eFeature, Object value) {
        if (value == null) {
            return value;
        }
        if (eFeature.getEType() instanceof EEnum && value instanceof Integer) {
            int ordinal = (Integer)value;
            EEnum eeNum = (EEnum)eFeature.getEType();
            if (eeNum.getInstanceClass() != null && eeNum.getInstanceClass().isEnum()) {
                T[] constants;
                T[] TArray = constants = eeNum.getInstanceClass().getEnumConstants();
                int n = constants.length;
                int n2 = 0;
                while (n2 < n) {
                    Enumerator enumerator;
                    Object constant = TArray[n2];
                    if (constant instanceof Enumerator && (enumerator = (Enumerator)constant).getValue() == ordinal) {
                        return enumerator;
                    }
                    ++n2;
                }
                return constants[ordinal];
            }
            return eeNum.getEEnumLiteral(((Integer)value).intValue());
        }
        if (eFeature instanceof EReference && ((EReference)eFeature).isContainment()) {
            return EcoreUtil.copy((EObject)((EObject)value));
        }
        if (value.getClass().isArray()) {
            int length = Array.getLength(value);
            Object newArray = Array.newInstance(value.getClass().getComponentType(), length);
            int i = 0;
            while (i < length) {
                Array.set(newArray, i, Array.get(value, i));
                ++i;
            }
            return newArray;
        }
        return value;
    }

    private FeatureMap.Entry createFeatureMapEntry(Session session, EStructuralFeature eFeature, FeatureMap.Entry sourceEntry) {
        Object value = sourceEntry.getValue();
        if (sourceEntry.getEStructuralFeature() instanceof EReference) {
            value = this.entityToIdString(session, value);
        }
        return FeatureMapUtil.createEntry((EStructuralFeature)eFeature, (Object)value);
    }

    public String entityToIdString(Session session, Object entity) {
        String entityName = ((SharedSessionContractImplementor)session).bestGuessEntityName(entity);
        Serializable id = ((SharedSessionContractImplementor)session).getEntityPersister(entityName, entity).getIdentifier(entity, (SharedSessionContractImplementor)session);
        return String.valueOf(entityName) + ID_SEPARATOR + id.getClass().getName() + ID_SEPARATOR + id;
    }

    public String idToString(EClass eClass, Object id) {
        String entityName = (String)eClass.getEAnnotation("teneo.jpa").getDetails().get((Object)"teneo.entity.name");
        return String.valueOf(entityName) + ID_SEPARATOR + id.getClass().getName() + ID_SEPARATOR + id;
    }

    public AuditReference fromString(String idString) {
        String[] parts = idString.split(ID_SEPARATOR);
        AuditReference auditReference = new AuditReference();
        auditReference.setTimeStamp(Long.parseLong(parts[0]));
        auditReference.setEntityName(parts[1]);
        auditReference.setId(this.getId(parts[3], parts[2]));
        return auditReference;
    }

    private Serializable getId(String idStr, String idType) {
        try {
            Constructor<?> constructor = this.constructors.get(idType);
            if (constructor == null) {
                Class<?> idClass = this.getClass().getClassLoader().loadClass(idType);
                constructor = idClass.getConstructor(String.class);
                this.constructors.put(idType, constructor);
            }
            return (Serializable)constructor.newInstance(idStr);
        }
        catch (Exception e) {
            throw new HbStoreException("Could not create id type for " + idType + " and id " + idStr, e);
        }
    }

    public <T extends EModelElement> T getModelElement(T auditModelElement) {
        EAnnotation eAnnotation = auditModelElement.getEAnnotation("teneo.auditing");
        if (eAnnotation == null) {
            return null;
        }
        String id = (String)eAnnotation.getDetails().get((Object)"teneo.auditing.modelelement");
        if (id == null) {
            return null;
        }
        if (auditModelElement instanceof EClass) {
            return (T)StoreUtil.stringToEClass((EPackage.Registry)this.dataStore.getPackageRegistry(), (String)id);
        }
        return (T)StoreUtil.stringToStructureFeature((EPackage.Registry)this.getDataStore().getPackageRegistry(), (String)id);
    }

    public EClass getAuditingModelElement(EClass modelElement) {
        return this.getAuditingModelElement(modelElement, null);
    }

    public <T extends EModelElement> T getAuditingModelElement(T modelElement, String qualifier) {
        EAnnotation eAnnotation = modelElement.getEAnnotation("teneo.auditing");
        if (eAnnotation == null && modelElement instanceof EStructuralFeature && ((EStructuralFeature)modelElement).getEContainingClass().getEPackage() == XMLTypePackage.eINSTANCE) {
            return modelElement;
        }
        if (eAnnotation == null) {
            return null;
        }
        String id = (String)eAnnotation.getDetails().get((Object)("teneo.auditing.modelelement.auditing" + (qualifier == null ? "" : qualifier)));
        if (id == null) {
            EClass containingEClass;
            EClass auditEClass;
            if (modelElement instanceof EStructuralFeature && (auditEClass = this.getAuditingModelElement(containingEClass = ((EStructuralFeature)modelElement).getEContainingClass())) != null) {
                id = (String)eAnnotation.getDetails().get((Object)("teneo.auditing.modelelement.auditing" + auditEClass.getName()));
            }
            if (id == null) {
                return null;
            }
        }
        if (modelElement instanceof EClass) {
            return (T)StoreUtil.stringToEClass((EPackage.Registry)this.dataStore.getPackageRegistry(), (String)id);
        }
        return (T)StoreUtil.stringToStructureFeature((EPackage.Registry)this.getDataStore().getPackageRegistry(), (String)id);
    }

    public <T extends EModelElement> boolean isNoAuditing(PersistenceOptions po, T modelElement) {
        EAnnotation teneoAnnotation = modelElement.getEAnnotation("teneo.jpa");
        if (teneoAnnotation != null) {
            boolean noEAVPresent = false;
            for (String value : teneoAnnotation.getDetails().values()) {
                if (value != null && (value.contains("@EAV") || value.contains("@Transient") || value.contains("@NoAuditing"))) {
                    return true;
                }
                boolean bl = noEAVPresent = noEAVPresent || value != null && value.contains("@NoEAV");
            }
            if (po.isEAVMapping() && !noEAVPresent) {
                return true;
            }
        } else if (po.isEAVMapping()) {
            return true;
        }
        if (modelElement instanceof EEnum) {
            return false;
        }
        if (modelElement instanceof EDataType) {
            EDataType eDataType = (EDataType)modelElement;
            if (eDataType.getEAnnotation("teneo.jpa.auditing") != null) {
                return false;
            }
            if (this.isCustomType((EDataType)modelElement)) {
                return !this.supportCustomType();
            }
            return false;
        }
        if (modelElement instanceof EStructuralFeature) {
            EReference eReference;
            EStructuralFeature eStructuralFeature = (EStructuralFeature)modelElement;
            if (modelElement instanceof EAttribute) {
                EAttribute eAttribute = (EAttribute)modelElement;
                if (eAttribute.getEAnnotation("teneo.jpa.auditing") == null && this.isNoAuditing(po, eAttribute.getEType())) {
                    return true;
                }
            } else {
                if (eStructuralFeature.getEAnnotation("teneo.jpa.auditing") != null) {
                    return false;
                }
                if (this.isNoAuditing(po, eStructuralFeature.getEType())) {
                    return true;
                }
            }
            if (ExtendedMetaData.INSTANCE.getGroup(eStructuralFeature) != null) {
                return false;
            }
            if (ExtendedMetaData.INSTANCE.getAffiliation(eStructuralFeature) != null) {
                return false;
            }
            if (!eStructuralFeature.isChangeable() || eStructuralFeature.isVolatile() || eStructuralFeature.isDerived()) {
                return ExtendedMetaData.INSTANCE.getMixedFeature(eStructuralFeature.getEContainingClass()) == null;
            }
            if (eStructuralFeature instanceof EReference && this.isNoAuditing(po, (eReference = (EReference)eStructuralFeature).getEType())) {
                return true;
            }
            return eStructuralFeature.isTransient() && (eStructuralFeature instanceof EAttribute || ((EReference)eStructuralFeature).getEOpposite() == null || !((EReference)eStructuralFeature).getEOpposite().isContainment() || ((EReference)eStructuralFeature).getEOpposite().isTransient());
        }
        return false;
    }

    protected boolean isCustomType(EDataType eDataType) {
        boolean isJavaType = this.isJavaType(eDataType.getInstanceClass());
        boolean xmlOrJavaOrEcoreType = isJavaType || eDataType.getEPackage().getNsURI().equals("http://www.eclipse.org/emf/2003/XMLType") || eDataType.getEPackage().getNsURI().equals("http://www.eclipse.org/emf/2002/Ecore");
        return !xmlOrJavaOrEcoreType;
    }

    protected boolean supportCustomType() {
        return false;
    }

    protected boolean isJavaType(Class<?> clz) {
        if (clz == null) {
            return false;
        }
        if (clz.isArray()) {
            return this.isJavaType(clz.getComponentType());
        }
        return clz.isPrimitive() || clz.getName().startsWith("java.");
    }

    public <T extends EModelElement> void setAuditingAssociation(T source, T auditing, String qualifier) {
        String localQualifier;
        EAnnotation eAnnotation = auditing.getEAnnotation("teneo.auditing");
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("teneo.auditing");
            auditing.getEAnnotations().add((Object)eAnnotation);
        }
        if (source instanceof EClass) {
            eAnnotation.getDetails().put((Object)"teneo.auditing.modelelement", (Object)StoreUtil.eClassToString((EClass)((EClass)source)));
        } else {
            eAnnotation.getDetails().put((Object)"teneo.auditing.modelelement", (Object)StoreUtil.structuralFeatureToString((EStructuralFeature)((EStructuralFeature)source)));
        }
        eAnnotation = source.getEAnnotation("teneo.auditing");
        if (eAnnotation == null) {
            eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("teneo.auditing");
            source.getEAnnotations().add((Object)eAnnotation);
        }
        String string = localQualifier = qualifier != null ? qualifier : "";
        if (auditing instanceof EClass) {
            eAnnotation.getDetails().put((Object)("teneo.auditing.modelelement.auditing" + localQualifier), (Object)StoreUtil.eClassToString((EClass)((EClass)auditing)));
        } else {
            eAnnotation.getDetails().put((Object)("teneo.auditing.modelelement.auditing" + localQualifier), (Object)StoreUtil.structuralFeatureToString((EStructuralFeature)((EStructuralFeature)auditing)));
        }
    }

    public EPackage createAuditingEPackage(AuditDataStore dataStore, EPackage sourceEPackage, EPackage.Registry registry, PersistenceOptions po) {
        EPackage eAuditingPackage;
        if (registry.containsKey((Object)(String.valueOf(sourceEPackage.getNsURI()) + "Auditing"))) {
            eAuditingPackage = registry.getEPackage(String.valueOf(sourceEPackage.getNsURI()) + "Auditing");
        } else {
            eAuditingPackage = EcoreFactory.eINSTANCE.createEPackage();
            eAuditingPackage.setName(String.valueOf(sourceEPackage.getName()) + "Auditing");
            eAuditingPackage.setNsPrefix(String.valueOf(sourceEPackage.getNsPrefix()) + "Auditing");
            eAuditingPackage.setNsURI(String.valueOf(sourceEPackage.getNsURI()) + "Auditing");
            registry.put((Object)eAuditingPackage.getNsURI(), (Object)eAuditingPackage);
        }
        if (eAuditingPackage.getEAnnotation("teneo.auditing") == null) {
            EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
            eAnnotation.setSource("teneo.auditing");
            eAuditingPackage.getEAnnotations().add((Object)eAnnotation);
        }
        for (EClassifier eClassifier : sourceEPackage.getEClassifiers()) {
            EClass auditingEClass;
            if (!(eClassifier instanceof EClass) || this.isNoAuditing(po, eClassifier)) continue;
            EClass eClass = (EClass)eClassifier;
            String auditEClassName = String.valueOf(po.getAuditingEntityPrefix()) + eClass.getName() + po.getAuditingEntityPostfix();
            if (eAuditingPackage.getEClassifier(auditEClassName) != null) {
                auditingEClass = (EClass)eAuditingPackage.getEClassifier(auditEClassName);
                auditingEClass.getEStructuralFeatures().clear();
            } else {
                auditingEClass = EcoreFactory.eINSTANCE.createEClass();
                auditingEClass.setName(auditEClassName);
            }
            eAuditingPackage.getEClassifiers().add((Object)auditingEClass);
            if (eClass.getESuperTypes().isEmpty()) {
                auditingEClass.getESuperTypes().add((Object)TeneoauditingPackage.eINSTANCE.getTeneoAuditEntry());
            } else {
                for (EClass eSuperClass : eClass.getESuperTypes()) {
                    if (this.isNoAuditing(po, eSuperClass)) continue;
                    auditingEClass.getESuperTypes().add((Object)this.getSuperAuditingEClass(dataStore, eSuperClass, registry, po));
                }
            }
            this.setAuditingAssociation(eClass, auditingEClass, null);
            if (eClass.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData") != null) {
                auditingEClass.getEAnnotations().add((Object)((EAnnotation)EcoreUtil.copy((EObject)eClass.getEAnnotation("http:///org/eclipse/emf/ecore/util/ExtendedMetaData"))));
            }
            if (eClass.getEAnnotation("teneo.jpa.auditing") != null) {
                EAnnotation teneoAnnotation = (EAnnotation)EcoreUtil.copy((EObject)eClass.getEAnnotation("teneo.jpa"));
                teneoAnnotation.setSource("teneo.jpa");
                auditingEClass.getEAnnotations().add((Object)teneoAnnotation);
            } else {
                boolean setMappedSuperclass = this.hasJPAAnnotation((EModelElement)eClass, "@MappedSuperclass");
                EAnnotation eAnnotation = EcoreFactory.eINSTANCE.createEAnnotation();
                eAnnotation.setSource("teneo.jpa");
                if (setMappedSuperclass) {
                    eAnnotation.getDetails().put((Object)"value", (Object)"@MappedSuperclass");
                } else {
                    eAnnotation.getDetails().put((Object)"value", (Object)"@Entity");
                }
                auditingEClass.getEAnnotations().add((Object)eAnnotation);
            }
            for (EStructuralFeature eFeature : eClass.getEStructuralFeatures()) {
                String value;
                EAnnotation teneoAnnotation;
                Object auditingEFeature;
                if (this.isNoAuditing(po, eFeature)) continue;
                if (eFeature instanceof EReference && StoreUtil.isMap((EStructuralFeature)eFeature)) {
                    EClass auditingEMapEClass;
                    EClass eMapEClass = ((EReference)eFeature).getEReferenceType();
                    String auditEMapClassName = String.valueOf(po.getAuditingEntityPrefix()) + eMapEClass.getName() + po.getAuditingEntityPostfix();
                    if (eAuditingPackage.getEClassifier(auditEMapClassName) == null) {
                        auditingEMapEClass = EcoreFactory.eINSTANCE.createEClass();
                        auditingEMapEClass.setName(auditEMapClassName);
                        eAuditingPackage.getEClassifiers().add((Object)auditingEMapEClass);
                    } else {
                        auditingEMapEClass = (EClass)eAuditingPackage.getEClassifier(auditEMapClassName);
                    }
                    auditingEFeature = this.createEMapFeature(eFeature, auditingEMapEClass);
                } else {
                    auditingEFeature = eFeature instanceof EReference && this.isEmbedded((EModelElement)((EReference)eFeature)) ? (EStructuralFeature)EcoreUtil.copy((EObject)eFeature) : (eFeature instanceof EReference ? this.createEReferenceAttribute((EReference)eFeature) : this.createEAttribute((EAttribute)eFeature));
                }
                EAnnotation jpaEAnnotation = auditingEFeature.getEAnnotation("teneo.jpa");
                auditingEFeature.getEAnnotations().remove((Object)jpaEAnnotation);
                auditingEFeature.getEAnnotations().remove((Object)auditingEFeature.getEAnnotation("teneo.hibernate"));
                if (eFeature.getEAnnotation("teneo.jpa.auditing") != null) {
                    teneoAnnotation = (EAnnotation)EcoreUtil.copy((EObject)eFeature.getEAnnotation("teneo.jpa.auditing"));
                    teneoAnnotation.setSource("teneo.jpa");
                    auditingEFeature.getEAnnotations().add((Object)teneoAnnotation);
                } else if (eFeature.getEType().getEAnnotation("teneo.jpa.auditing") != null) {
                    teneoAnnotation = (EAnnotation)EcoreUtil.copy((EObject)eFeature.getEType().getEAnnotation("teneo.jpa.auditing"));
                    teneoAnnotation.setSource("teneo.jpa");
                    auditingEFeature.getEAnnotations().add((Object)teneoAnnotation);
                } else if (jpaEAnnotation != null && eFeature instanceof EAttribute && !eFeature.isMany() && !(value = String.valueOf((String)jpaEAnnotation.getDetails().get((Object)"value")) + (String)jpaEAnnotation.getDetails().get((Object)"appinfo")).contains("@Id") && !value.contains("@Version")) {
                    auditingEFeature.getEAnnotations().add((Object)((EAnnotation)EcoreUtil.copy((EObject)jpaEAnnotation)));
                }
                if (auditingEFeature instanceof EAttribute) {
                    auditingEFeature.setID(false);
                }
                auditingEFeature.setChangeable(true);
                auditingEFeature.setLowerBound(0);
                auditingEClass.getEStructuralFeatures().add(auditingEFeature);
                this.setAuditingAssociation((EModelElement)eFeature, (EModelElement)auditingEFeature, auditingEClass.getName());
            }
        }
        return eAuditingPackage;
    }

    private boolean hasJPAAnnotation(EModelElement eModelElement, String jpaAnnotation) {
        StringBuffer value = new StringBuffer();
        EAnnotation eAnnotation = eModelElement.getEAnnotation("teneo.jpa");
        if (eAnnotation != null) {
            value.append((String)eAnnotation.getDetails().get((Object)"value"));
            value.append((String)eAnnotation.getDetails().get((Object)"appinfo"));
        }
        if ((eAnnotation = eModelElement.getEAnnotation("teneo.hibernate")) != null) {
            value.append((String)eAnnotation.getDetails().get((Object)"value"));
            value.append((String)eAnnotation.getDetails().get((Object)"appinfo"));
        }
        return value.toString().contains(jpaAnnotation);
    }

    protected EStructuralFeature createEAttribute(EAttribute eAttribute) {
        return (EStructuralFeature)EcoreUtil.copy((EObject)eAttribute);
    }

    protected EAttribute createEReferenceAttribute(EReference eReference) {
        EAttribute auditingEAttribute = EcoreFactory.eINSTANCE.createEAttribute();
        auditingEAttribute.setEType((EClassifier)EcorePackage.eINSTANCE.getEString());
        for (EAnnotation eAnnotation : eReference.getEAnnotations()) {
            auditingEAttribute.getEAnnotations().add((Object)((EAnnotation)EcoreUtil.copy((EObject)eAnnotation)));
        }
        for (EAttribute eSAttribute : EcorePackage.eINSTANCE.getEStructuralFeature().getEAllAttributes()) {
            if (eSAttribute.isDerived() || eSAttribute.isVolatile() || !eReference.eIsSet((EStructuralFeature)eSAttribute)) continue;
            auditingEAttribute.eSet((EStructuralFeature)eSAttribute, eReference.eGet((EStructuralFeature)eSAttribute));
        }
        return auditingEAttribute;
    }

    protected EStructuralFeature createEMapFeature(EStructuralFeature sourceEFeature, EClass eMapEntryEClass) {
        EStructuralFeature auditingEFeature = (EStructuralFeature)EcoreUtil.copy((EObject)sourceEFeature);
        auditingEFeature.setEType((EClassifier)eMapEntryEClass);
        return auditingEFeature;
    }

    private EClass getSuperAuditingEClass(AuditDataStore auditDataStore, EClass superEClass, EPackage.Registry registry, PersistenceOptions po) {
        EClass auditingEClass;
        String auditEClassName;
        EPackage eAuditingPackage;
        EPackage superEPackage = superEClass.getEPackage();
        if (!registry.containsKey((Object)(String.valueOf(superEPackage.getNsURI()) + "Auditing"))) {
            this.createAuditingEPackage(auditDataStore, superEPackage, registry, po);
        }
        if ((eAuditingPackage = registry.getEPackage(String.valueOf(superEPackage.getNsURI()) + "Auditing")).getEClassifier(auditEClassName = String.valueOf(po.getAuditingEntityPrefix()) + superEClass.getName() + po.getAuditingEntityPostfix()) != null) {
            auditingEClass = (EClass)eAuditingPackage.getEClassifier(auditEClassName);
        } else {
            auditingEClass = EcoreFactory.eINSTANCE.createEClass();
            auditingEClass.setName(auditEClassName);
        }
        eAuditingPackage.getEClassifiers().add((Object)auditingEClass);
        return auditingEClass;
    }

    public boolean isEmbedded(EModelElement modelElement) {
        if (modelElement.getEAnnotation("teneo.jpa") != null) {
            EAnnotation eAnnotation = modelElement.getEAnnotation("teneo.jpa");
            for (String value : eAnnotation.getDetails().values()) {
                if (value.contains("@External")) {
                    return true;
                }
                if (value.contains("@Embeddable")) {
                    return true;
                }
                if (value.contains("@Embedded")) {
                    return true;
                }
                if (value.contains("@Type")) {
                    return true;
                }
                if (!value.contains("@TypeDef")) continue;
                return true;
            }
        }
        if (modelElement instanceof EReference) {
            return this.isEmbedded((EModelElement)((EReference)modelElement).getEReferenceType());
        }
        return false;
    }

    public AuditDataStore getDataStore() {
        return this.dataStore;
    }

    public void setDataStore(AuditDataStore dataStore) {
        this.dataStore = dataStore;
    }
}

