/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Date;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.eclipse.emf.teneo.hibernate.HbStoreException;
import org.eclipse.emf.teneo.hibernate.mapping.XSDDateTime;
import org.eclipse.emf.teneo.util.EcoreDataTypes;
import org.hibernate.HibernateException;
import org.hibernate.engine.spi.SharedSessionContractImplementor;

public class XSDDate
extends XSDDateTime {
    static final long serialVersionUID = 1L;
    private static final int[] SQL_TYPES = new int[]{91};
    private final DatatypeFactory dataTypeFactory;

    public XSDDate() {
        try {
            this.dataTypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new HbStoreException("Exception ", e);
        }
    }

    @Override
    public int[] sqlTypes() {
        return SQL_TYPES;
    }

    @Override
    public String getName() {
        return "xmldate";
    }

    @Override
    public Object nullSafeGet(ResultSet rs, String[] names, SharedSessionContractImplementor session, Object owner) throws HibernateException, SQLException {
        java.sql.Date date = rs.getDate(names[0]);
        if (date == null) {
            return null;
        }
        return EcoreDataTypes.INSTANCE.getXMLGregorianCalendar((Date)date);
    }

    @Override
    public void nullSafeSet(PreparedStatement st, Object value, int index, SharedSessionContractImplementor session) throws HibernateException, SQLException {
        if (value == null) {
            st.setDate(index, null);
            return;
        }
        java.sql.Date d = new java.sql.Date(((XMLGregorianCalendar)value).toGregorianCalendar().getTime().getTime());
        st.setDate(index, d);
    }

    @Override
    public Object fromStringValue(String s) throws HibernateException {
        return this.dataTypeFactory.newXMLGregorianCalendar(s);
    }
}

