/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.hibernate.mapping.elist;

import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.teneo.EContainerRepairControl;
import org.eclipse.emf.teneo.extension.ExtensionPoint;
import org.eclipse.emf.teneo.hibernate.HbMapperException;
import org.eclipse.emf.teneo.hibernate.SessionWrapper;
import org.eclipse.emf.teneo.hibernate.resource.HbResource;
import org.eclipse.emf.teneo.mapping.elist.PersistableEList;
import org.eclipse.emf.teneo.resource.StoreResource;
import org.eclipse.emf.teneo.util.AssertUtil;
import org.hibernate.HibernateException;
import org.hibernate.collection.internal.AbstractPersistentCollection;
import org.hibernate.collection.internal.PersistentBag;
import org.hibernate.collection.internal.PersistentIdentifierBag;
import org.hibernate.collection.internal.PersistentList;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.CollectionAliases;
import org.hibernate.persister.collection.CollectionPersister;
import org.hibernate.type.Type;

public class HibernatePersistableEList<E>
extends PersistableEList<E>
implements ExtensionPoint,
PersistentCollection {
    private static final long serialVersionUID = -4553160393592497834L;
    private static Log log = LogFactory.getLog(HibernatePersistableEList.class);
    private int cachedSize = -1;
    private boolean efficientSizeOperation = false;

    public HibernatePersistableEList(InternalEObject owner, EStructuralFeature feature, List<E> list) {
        super(owner, feature, list);
    }

    public boolean isInitialized() {
        return ((PersistentCollection)this.delegate).wasInitialized();
    }

    public boolean isLoaded() {
        boolean isDelegateLoaded;
        boolean bl = isDelegateLoaded = this.delegate instanceof AbstractPersistentCollection && ((AbstractPersistentCollection)this.delegate).wasInitialized();
        if (!super.isLoaded() && !this.isLoading() && isDelegateLoaded) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Persistentlist already initialized, probably eagerly loaded: " + this.getLogString()));
            }
            try {
                this.setIsLoading(true);
                this.doLoad();
                this.setIsLoaded(true);
            }
            finally {
                this.setIsLoading(false);
            }
        }
        return super.isLoaded();
    }

    protected synchronized void doLoad() {
        AssertUtil.assertTrue((String)("EList " + this.logString), (!this.isLoaded() ? 1 : 0) != 0);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Started loading elist " + this.logString));
        }
        SessionWrapper sessionWrapper = null;
        boolean controlsTransaction = false;
        boolean err = true;
        Resource res = null;
        try {
            res = this.owner.eResource();
            if (res != null && res instanceof HbResource) {
                sessionWrapper = ((HbResource)res).getSessionWrapper();
                if (res.isLoaded()) {
                    boolean isDelegateLoaded;
                    boolean bl = isDelegateLoaded = this.delegate instanceof AbstractPersistentCollection && ((AbstractPersistentCollection)this.delegate).wasInitialized();
                    if (!isDelegateLoaded && !sessionWrapper.isTransactionActive()) {
                        log.debug((Object)("Reconnecting session to read a lazy collection, elist: " + this.logString));
                        controlsTransaction = true;
                        sessionWrapper.beginTransaction();
                        sessionWrapper.setFlushModeManual();
                    } else {
                        log.debug((Object)"Delegate loaded or resource session is still active, using it");
                    }
                } else if (log.isDebugEnabled()) {
                    log.debug((Object)("Elist uses session from resource, " + this.logString));
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"EList is not loaded in session context");
            }
            if (controlsTransaction) {
                assert (res instanceof HbResource);
                ((StoreResource)res).setIsLoading(true);
            }
            try {
                Object element;
                int n;
                int n2;
                Object[] objectArray;
                Object[] objs = this.delegate.toArray();
                if (this.isContainment()) {
                    objectArray = objs;
                    n2 = objs.length;
                    n = 0;
                    while (n < n2) {
                        element = objectArray[n];
                        if (element instanceof InternalEObject) {
                            EContainerRepairControl.setContainer((InternalEObject)this.owner, (InternalEObject)((InternalEObject)element), (EStructuralFeature)this.getEStructuralFeature());
                        }
                        ++n;
                    }
                }
                if (res != null && res instanceof StoreResource) {
                    objectArray = objs;
                    n2 = objs.length;
                    n = 0;
                    while (n < n2) {
                        element = objectArray[n];
                        if (element instanceof EObject) {
                            ((StoreResource)res).addToContentOrAttach((InternalEObject)element, (EReference)this.getEStructuralFeature());
                        }
                        ++n;
                    }
                }
                if (log.isDebugEnabled()) {
                    log.debug((Object)("Loaded " + objs.length + " from backend store for " + this.logString));
                }
            }
            finally {
                if (controlsTransaction) {
                    ((StoreResource)res).setIsLoading(false);
                }
            }
            err = false;
        }
        finally {
            if (controlsTransaction) {
                if (err) {
                    sessionWrapper.rollbackTransaction();
                    sessionWrapper.restorePreviousFlushMode();
                } else {
                    sessionWrapper.commitTransaction();
                    sessionWrapper.restorePreviousFlushMode();
                }
            }
            if (sessionWrapper != null) {
                ((HbResource)res).returnSessionWrapper(sessionWrapper);
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)("Finished loading elist " + this.logString));
        }
    }

    public void replaceDelegate(List<E> newDelegate) {
        if (newDelegate instanceof PersistentList) {
            super.replaceDelegate(newDelegate);
        } else if (newDelegate instanceof PersistentBag) {
            super.replaceDelegate(newDelegate);
        } else if (newDelegate instanceof PersistentIdentifierBag) {
            super.replaceDelegate(newDelegate);
        } else if (newDelegate != this.delegate) {
            throw new HbMapperException("Type " + newDelegate.getClass().getName() + " can not be " + " used as a replacement for elist " + this.logString);
        }
    }

    public boolean isPersistencyWrapped() {
        return this.delegate instanceof PersistentCollection;
    }

    public boolean afterInitialize() {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).afterInitialize();
        }
        return false;
    }

    public void afterRowInsert(CollectionPersister persister, Object entry, int i) throws HibernateException {
        if (this.isPersistencyWrapped()) {
            ((PersistentCollection)this.delegate).afterRowInsert(persister, entry, i);
        }
    }

    public void beforeInitialize(CollectionPersister persister, int anticipatedSize) {
        if (this.isPersistencyWrapped()) {
            ((PersistentCollection)this.delegate).beforeInitialize(persister, anticipatedSize);
        }
    }

    public void beginRead() {
        if (this.isPersistencyWrapped()) {
            ((PersistentCollection)this.delegate).beginRead();
        }
    }

    public void clearDirty() {
        if (this.isPersistencyWrapped()) {
            ((PersistentCollection)this.delegate).clearDirty();
        }
    }

    public void dirty() {
        if (this.isPersistencyWrapped()) {
            ((PersistentCollection)this.delegate).dirty();
        }
    }

    public Serializable disassemble(CollectionPersister persister) throws HibernateException {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).disassemble(persister);
        }
        return null;
    }

    public boolean empty() {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).empty();
        }
        return false;
    }

    public boolean endRead() {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).endRead();
        }
        return false;
    }

    public Iterator<?> entries(CollectionPersister persister) {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).entries(persister);
        }
        return null;
    }

    public boolean entryExists(Object entry, int i) {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).entryExists(entry, i);
        }
        return false;
    }

    public boolean equalsSnapshot(CollectionPersister persister) throws HibernateException {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).equalsSnapshot(persister);
        }
        return false;
    }

    public void forceInitialization() throws HibernateException {
        if (this.isPersistencyWrapped()) {
            ((PersistentCollection)this.delegate).forceInitialization();
        }
    }

    public Iterator<?> getDeletes(CollectionPersister persister, boolean indexIsFormula) throws HibernateException {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).getDeletes(persister, indexIsFormula);
        }
        return null;
    }

    public Object getElement(Object entry) {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).getElement(entry);
        }
        return null;
    }

    public Object getIdentifier(Object entry, int i) {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).getIdentifier(entry, i);
        }
        return null;
    }

    public Object getIndex(Object entry, int i, CollectionPersister persister) {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).getIndex(entry, i, persister);
        }
        return null;
    }

    public Serializable getKey() {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).getKey();
        }
        return null;
    }

    public Collection<?> getOrphans(Serializable snapshot, String entityName) throws HibernateException {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).getOrphans(snapshot, entityName);
        }
        return null;
    }

    public Object getOwner() {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).getOwner();
        }
        return this.getEObject();
    }

    public Collection<?> getQueuedOrphans(String entityName) {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).getQueuedOrphans(entityName);
        }
        return null;
    }

    public String getRole() {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).getRole();
        }
        return null;
    }

    public Serializable getSnapshot(CollectionPersister persister) throws HibernateException {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).getSnapshot(persister);
        }
        return null;
    }

    public Object getSnapshotElement(Object entry, int i) {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).getSnapshotElement(entry, i);
        }
        return null;
    }

    public Serializable getStoredSnapshot() {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).getStoredSnapshot();
        }
        return null;
    }

    public Object getValue() {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).getValue();
        }
        return null;
    }

    public boolean hasQueuedOperations() {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).hasQueuedOperations();
        }
        return false;
    }

    public void initializeFromCache(CollectionPersister persister, Serializable disassembled, Object owner) throws HibernateException {
        if (this.isPersistencyWrapped()) {
            ((PersistentCollection)this.delegate).initializeFromCache(persister, disassembled, owner);
        }
    }

    public boolean isDirectlyAccessible() {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).isDirectlyAccessible();
        }
        return false;
    }

    public boolean isDirty() {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).isDirty();
        }
        return false;
    }

    public boolean isRowUpdatePossible() {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).isRowUpdatePossible();
        }
        return false;
    }

    public boolean isSnapshotEmpty(Serializable snapshot) {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).isSnapshotEmpty(snapshot);
        }
        return false;
    }

    public boolean isUnreferenced() {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).isUnreferenced();
        }
        return false;
    }

    public boolean isWrapper(Object collection) {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).isWrapper(collection);
        }
        return false;
    }

    public boolean needsInserting(Object entry, int i, Type elemType) throws HibernateException {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).needsInserting(entry, i, elemType);
        }
        return false;
    }

    public boolean needsRecreate(CollectionPersister persister) {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).needsRecreate(persister);
        }
        return false;
    }

    public boolean needsUpdating(Object entry, int i, Type elemType) throws HibernateException {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).needsUpdating(entry, i, elemType);
        }
        return false;
    }

    public void postAction() {
        if (this.isPersistencyWrapped()) {
            ((PersistentCollection)this.delegate).postAction();
        }
    }

    protected int delegateSize() {
        int computedSize;
        if (this.isEfficientSizeOperation() && (computedSize = this.getSizeNonLoading()) > -1) {
            return computedSize;
        }
        if (this.delegate instanceof AbstractPersistentCollection && !this.isInitialized() && !this.isLoaded()) {
            return this.delegate.size();
        }
        return this.delegateList().size();
    }

    public int getSizeNonLoading() {
        CollectionEntry entry;
        AbstractPersistentCollection persistentCollection;
        SharedSessionContractImplementor session;
        if (this.cachedSize > -1) {
            return this.cachedSize;
        }
        if (this.delegate instanceof AbstractPersistentCollection && !this.isInitialized() && !this.isLoaded() && (session = (persistentCollection = (AbstractPersistentCollection)this.delegate).getSession()) != null && (entry = session.getPersistenceContext().getCollectionEntry((PersistentCollection)persistentCollection)) != null) {
            CollectionPersister persister = entry.getLoadedPersister();
            if (persistentCollection.hasQueuedOperations()) {
                session.flush();
            }
            this.cachedSize = persister.getSize(entry.getLoadedKey(), session);
            return this.cachedSize;
        }
        return -1;
    }

    protected boolean isConnectedToSession() {
        if (!(this.getDelegate() instanceof AbstractPersistentCollection)) {
            return false;
        }
        AbstractPersistentCollection persistentCollection = (AbstractPersistentCollection)this.getDelegate();
        SharedSessionContractImplementor session = persistentCollection.getSession();
        return this.isConnectedToSession(session);
    }

    private final boolean isConnectedToSession(SharedSessionContractImplementor session) {
        PersistentCollection persistentCollection = (PersistentCollection)this.getDelegate();
        return session != null && session.isOpen() && session.getPersistenceContext().containsCollection(persistentCollection);
    }

    protected boolean delegateIsEmpty() {
        return this.delegateSize() == 0;
    }

    public void preInsert(CollectionPersister persister) throws HibernateException {
        if (this.isPersistencyWrapped()) {
            ((PersistentCollection)this.delegate).preInsert(persister);
        }
    }

    public Iterator<?> queuedAdditionIterator() {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).queuedAdditionIterator();
        }
        return null;
    }

    public Object readFrom(ResultSet rs, CollectionPersister role, CollectionAliases descriptor, Object owner) throws HibernateException, SQLException {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).readFrom(rs, role, descriptor, owner);
        }
        return null;
    }

    public boolean setCurrentSession(SharedSessionContractImplementor session) throws HibernateException {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).setCurrentSession(session);
        }
        return false;
    }

    public void setOwner(Object entity) {
        if (this.isPersistencyWrapped()) {
            ((PersistentCollection)this.delegate).setOwner(entity);
        }
    }

    public void setSnapshot(Serializable key, String role, Serializable snapshot) {
        if (this.isPersistencyWrapped()) {
            ((PersistentCollection)this.delegate).setSnapshot(key, role, snapshot);
        }
    }

    public boolean unsetSession(SharedSessionContractImplementor currentSession) {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).unsetSession(currentSession);
        }
        return false;
    }

    public boolean wasInitialized() {
        if (this.isPersistencyWrapped()) {
            return ((PersistentCollection)this.delegate).wasInitialized();
        }
        return false;
    }

    public boolean isEfficientSizeOperation() {
        return this.efficientSizeOperation;
    }

    public void setEfficientSizeOperation(boolean efficientSizeOperation) {
        this.efficientSizeOperation = efficientSizeOperation;
    }
}

