/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.teneo.eclipselink.elistfactory;

import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EEnum;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.teneo.eclipselink.elistfactory.ExtendedMetaDataUtil;
import org.eclipse.emf.teneo.eclipselink.elistfactory.internal.messages.Messages;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class EElementUtil {
    private EElementUtil() {
    }

    public static boolean isListType(EStructuralFeature eStructuralFeature) {
        return eStructuralFeature.isMany() || EElementUtil.isFeatureMapEntryType(eStructuralFeature);
    }

    public static boolean isMapType(EStructuralFeature eStructuralFeature) {
        return !EElementUtil.isContainer(eStructuralFeature) && eStructuralFeature.isMany() && eStructuralFeature.getEType() instanceof EClass && EElementUtil.isJavaUtilMapEntryType(eStructuralFeature);
    }

    public static boolean isFeatureMapType(EStructuralFeature eStructuralFeature) {
        return EElementUtil.isFeatureMapEntryType(eStructuralFeature);
    }

    public static boolean isJavaUtilMapEntryType(EStructuralFeature eStructuralFeature) {
        String instanceClassName = eStructuralFeature.getEType().getInstanceClassName();
        return "java.util.Map.Entry".equals(instanceClassName) || "java.util.Map$Entry".equals(instanceClassName);
    }

    public static boolean isFeatureMapEntryType(EStructuralFeature eStructuralFeature) {
        String instanceClassName = eStructuralFeature.getEType().getInstanceClassName();
        return "org.eclipse.emf.ecore.util.FeatureMap.Entry".equals(instanceClassName) || "org.eclipse.emf.ecore.util.FeatureMap$Entry".equals(instanceClassName);
    }

    public static boolean isContainer(EStructuralFeature eStructuralFeature) {
        boolean result = false;
        if (eStructuralFeature instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            EReference eOppositeReference = eReference.getEOpposite();
            result = eOppositeReference != null && eOppositeReference.isContainment();
        }
        return result;
    }

    public static boolean isContainment(EStructuralFeature eStructuralFeature) {
        boolean result = false;
        if (eStructuralFeature instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            result = eReference.isContainment();
        }
        return result;
    }

    public static boolean isBidirectional(EStructuralFeature eStructuralFeature) {
        boolean result = false;
        if (eStructuralFeature instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            result = eReference.getEOpposite() != null;
        }
        return result;
    }

    public static boolean isResolveProxies(EStructuralFeature eStructuralFeature) {
        return EElementUtil.isResolveProxies(eStructuralFeature, false);
    }

    public static boolean isResolveProxies(EStructuralFeature eStructuralFeature, boolean containmentProxies) {
        boolean result = false;
        if (eStructuralFeature instanceof EReference) {
            EReference eReference = (EReference)eStructuralFeature;
            result = (!EElementUtil.isContainer((EStructuralFeature)eReference) && !EElementUtil.isContainment((EStructuralFeature)eReference) || containmentProxies) && eReference.isResolveProxies();
        }
        return result;
    }

    public static String getQualifiedListItemTypeName(EStructuralFeature eStructuralFeature) {
        String result = "";
        EClassifier eType = eStructuralFeature.getEType();
        if (eType instanceof EClass) {
            result = eType.getInstanceClassName() != null ? eType.getInstanceClassName() : EElementUtil.getQualifiedInterfaceName(eType);
        }
        if (eType instanceof EEnum) {
            return EElementUtil.getQualifiedInterfaceName(eType);
        }
        if (eType instanceof EDataType) {
            if (EElementUtil.isPrimitiveType(eType)) {
                result = EElementUtil.getQualifiedPrimitiveObjectTypeName(eType);
            } else if ("org.eclipse.emf.common.util.Enumerator".equals(eType.getInstanceClassName())) {
                EDataType eBaseType = ExtendedMetaDataUtil.getExtendedMetaData(eType).getBaseType((EDataType)eType);
                if (eBaseType instanceof EEnum) {
                    result = EElementUtil.getQualifiedInterfaceName((EClassifier)eBaseType);
                }
            } else if (eType.getInstanceClassName() != null) {
                result = eType.getInstanceClassName();
            }
        }
        return result;
    }

    public static int getDerivedStructuralFeatureID(EObject eOwnerObject, EStructuralFeature eStructuralFeature) throws ClassNotFoundException {
        int featureID = eStructuralFeature.getFeatureID();
        Class containingClass = eStructuralFeature.getEContainingClass().getInstanceClass();
        return ((InternalEObject)eOwnerObject).eDerivedStructuralFeatureID(featureID, containingClass);
    }

    public static String getQualifiedInterfacePackageName(EClassifier eClassifier) {
        Class<?> ePackageClass = eClassifier.getEPackage().getClass();
        Class<?> ePackageInterface = null;
        int i = 0;
        while (i < ePackageClass.getInterfaces().length && ePackageInterface == null) {
            String interfaceName = ePackageClass.getInterfaces()[i].getSimpleName();
            if (ePackageClass.getSimpleName().startsWith(interfaceName)) {
                ePackageInterface = ePackageClass.getInterfaces()[i];
            }
            ++i;
        }
        Assert.isTrue((ePackageInterface != null ? 1 : 0) != 0, (String)NLS.bind((String)Messages.assert_couldNotFindEPackageInterfaceOfEPackageClass$0, (Object)ePackageClass.getName()));
        return ePackageInterface.getPackage().getName();
    }

    public static String getQualifiedClassPackageName(EClassifier eClassifier) {
        String eQualifiedPackageClassName = eClassifier.getEPackage().getClass().getName();
        return EElementUtil.getPackageName(eQualifiedPackageClassName);
    }

    public static String getQualifiedInterfaceName(EClassifier eClassifier) {
        return String.valueOf(EElementUtil.getQualifiedInterfacePackageName(eClassifier)) + "." + EElementUtil.getSimpleInterfaceName(eClassifier);
    }

    public static String getQualifiedClassName(EClassifier eClassifier) {
        return String.valueOf(EElementUtil.getQualifiedClassPackageName(eClassifier)) + "." + EElementUtil.getSimpleClassName(eClassifier);
    }

    public static String getSimpleInterfaceName(EClassifier eClassifier) {
        return eClassifier.getName();
    }

    public static String getSimpleClassName(EClassifier eClassifier) {
        return String.valueOf(EElementUtil.getSimpleInterfaceName(eClassifier)) + "Impl";
    }

    public static String getPackageName(String qualifiedTypeName) {
        return qualifiedTypeName.substring(0, qualifiedTypeName.lastIndexOf("."));
    }

    public static boolean isPrimitiveType(EClassifier eClassifier) {
        boolean result = false;
        Class instanceClass = eClassifier.getInstanceClass();
        if (instanceClass != null) {
            result = instanceClass.isPrimitive();
        }
        return result;
    }

    public static String getQualifiedPrimitiveObjectTypeName(EClassifier eClassifier) {
        Class instanceClass = eClassifier.getInstanceClass();
        if (instanceClass == Boolean.TYPE) {
            return "java.lang.Boolean";
        }
        if (instanceClass == Byte.TYPE) {
            return "java.lang.Byte";
        }
        if (instanceClass == Character.TYPE) {
            return "java.lang.Character";
        }
        if (instanceClass == Double.TYPE) {
            return "java.lang.Double";
        }
        if (instanceClass == Float.TYPE) {
            return "java.lang.Float";
        }
        if (instanceClass == Integer.TYPE) {
            return "java.lang.Integer";
        }
        if (instanceClass == Long.TYPE) {
            return "java.lang.Long";
        }
        if (instanceClass == Short.TYPE) {
            return "java.lang.Short";
        }
        return null;
    }

    public static EPackage findEPackage(String ePackageNsURI) {
        Assert.isLegal((ePackageNsURI != null && ePackageNsURI.trim().length() > 0 ? 1 : 0) != 0);
        EPackage ePackage = EPackage.Registry.INSTANCE.getEPackage(ePackageNsURI);
        Assert.isTrue((ePackage != null ? 1 : 0) != 0, (String)NLS.bind((String)Messages.assert_couldNotFindEPackageForNamespaceURI$0, (Object)ePackageNsURI));
        return ePackage;
    }

    public static EClass findEClass(EPackage ePackage, Class<?> javaClass) {
        return EElementUtil.findEClass(ePackage, javaClass.getSimpleName().replaceFirst("Impl$", ""));
    }

    public static EClass findEClass(EPackage ePackage, String eClassName) {
        Assert.isNotNull((Object)ePackage);
        Assert.isLegal((eClassName != null && eClassName.trim().length() > 0 ? 1 : 0) != 0);
        EClassifier eOwnerClassifier = ePackage.getEClassifier(eClassName);
        Assert.isTrue((eOwnerClassifier != null ? 1 : 0) != 0, (String)NLS.bind((String)Messages.assert_couldNotFindEClassifier$0InEPackage$1, (Object)eOwnerClassifier, (Object)ePackage.getName()));
        Assert.isTrue((boolean)(eOwnerClassifier instanceof EClass), (String)NLS.bind((String)Messages.assert_typeOfEClassifier$0InEPackage$1IsNotEClass, (Object)eOwnerClassifier.getName(), (Object)ePackage.getName()));
        return (EClass)eOwnerClassifier;
    }
}

