/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.workspace.tests;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.eclipse.core.commands.operations.DefaultOperationHistory;
import org.eclipse.core.commands.operations.IOperationHistory;
import org.eclipse.core.filesystem.EFS;
import org.eclipse.core.filesystem.IFileInfo;
import org.eclipse.core.filesystem.IFileStore;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.examples.extlibrary.AudioVisualItem;
import org.eclipse.emf.examples.extlibrary.Book;
import org.eclipse.emf.examples.extlibrary.Library;
import org.eclipse.emf.examples.extlibrary.Periodical;
import org.eclipse.emf.examples.extlibrary.Person;
import org.eclipse.emf.examples.extlibrary.Writer;
import org.eclipse.emf.examples.extlibrary.util.EXTLibrarySwitch;
import org.eclipse.emf.transaction.RollbackException;
import org.eclipse.emf.transaction.Transaction;
import org.eclipse.emf.transaction.TransactionalCommandStack;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.emf.transaction.impl.InternalTransaction;
import org.eclipse.emf.transaction.impl.InternalTransactionalEditingDomain;
import org.eclipse.emf.validation.model.IConstraintStatus;
import org.eclipse.emf.workspace.WorkspaceEditingDomainFactory;
import org.eclipse.emf.workspace.tests.TestsPlugin;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AbstractTest
extends TestCase {
    public static boolean validationEnabled = false;
    public static final boolean DEBUGGING = TestsPlugin.instance.isDebugging();
    static final Bundle EmfWorkbenchTestsBundle = TestsPlugin.instance.getBundle();
    protected IProject project;
    protected IFile file;
    protected TransactionalEditingDomain domain;
    protected IOperationHistory history;
    protected Resource testResource;
    protected Library root;
    protected static final String PROJECT_NAME = "emfwbtests";
    protected static final String RESOURCE_NAME = "/emfwbtests/testres.extlibrary";
    protected static final String TEST_RESOURCE_NAME = "test_model.extlibrary";
    private final List<InternalTransaction> transactionStack = new ArrayList<InternalTransaction>();

    public AbstractTest() {
    }

    public AbstractTest(String name) {
        super(name);
    }

    protected final void setUp() throws Exception {
        AbstractTest.trace("===> Begin : " + this.getName());
        this.doSetUp();
    }

    protected void doSetUp() throws Exception {
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        if (this.project.exists()) {
            this.delete(this.project);
        }
        this.project.create(null);
        this.project.open(null);
        this.file = this.project.getParent().getFile((IPath)new Path(RESOURCE_NAME));
        ResourceSetImpl rset = new ResourceSetImpl();
        try {
            Resource originalRes = rset.getResource(URI.createURI((String)EmfWorkbenchTestsBundle.getEntry("/test_models/test_model.extlibrary").toString()), true);
            originalRes.setURI(URI.createPlatformResourceURI((String)RESOURCE_NAME, (boolean)true));
            originalRes.save(Collections.EMPTY_MAP);
            this.testResource = originalRes;
            this.root = (Library)this.find("root");
        }
        catch (IOException e) {
            AbstractTest.fail((String)("Failed to load test model: " + e.getLocalizedMessage()));
        }
        this.domain = this.createEditingDomain((ResourceSet)rset);
    }

    protected TransactionalEditingDomain createEditingDomain(ResourceSet rset) {
        this.history = new DefaultOperationHistory();
        return WorkspaceEditingDomainFactory.INSTANCE.createEditingDomain(rset, this.history);
    }

    protected final void tearDown() throws Exception {
        try {
            this.doTearDown();
        }
        finally {
            AbstractTest.trace("===> End   : " + this.getName());
        }
    }

    protected void doTearDown() throws Exception {
        while (!this.transactionStack.isEmpty()) {
            try {
                this.rollback();
            }
            catch (Exception exception) {}
        }
        this.history = null;
        this.root = null;
        if (this.testResource != null) {
            if (this.testResource.isLoaded()) {
                this.testResource.unload();
            }
            if (this.testResource.getResourceSet() != null) {
                this.testResource.getResourceSet().getResources().remove((Object)this.testResource);
            }
            this.testResource = null;
        }
        this.project = ResourcesPlugin.getWorkspace().getRoot().getProject(PROJECT_NAME);
        this.delete(this.project);
        this.project = null;
        this.file = null;
        this.domain = null;
    }

    protected void delete(File file) {
        if (!file.exists()) {
            return;
        }
        try {
            IFileStore store = EFS.getLocalFileSystem().fromLocalFile(file);
            IFileInfo info = store.fetchInfo();
            info.setAttribute(2, false);
            info.setAttribute(16, false);
            info.setAttribute(8, false);
            store.putInfo(info, 1024, null);
        }
        catch (Exception e) {
            AbstractTest.fail((String)("Failed to clean up test file: " + e.getLocalizedMessage()));
        }
    }

    protected void delete(IFile file) {
        if (!file.exists()) {
            return;
        }
        try {
            if (file.isReadOnly()) {
                ResourceAttributes attrs = new ResourceAttributes();
                attrs.setReadOnly(false);
                attrs.setHidden(false);
                attrs.setArchive(false);
                file.setResourceAttributes(attrs);
            }
            file.delete(true, null);
        }
        catch (Exception e) {
            AbstractTest.fail((String)("Failed to clean up test file: " + e.getLocalizedMessage()));
        }
    }

    protected void delete(IProject project) {
        if (!project.exists()) {
            return;
        }
        try {
            project.refreshLocal(2, null);
            project.accept(new IResourceVisitor(){

                public boolean visit(IResource res) throws CoreException {
                    if (res.getType() == 1) {
                        AbstractTest.this.delete((IFile)res);
                    }
                    return true;
                }
            });
            project.delete(true, true, null);
        }
        catch (Exception e) {
            AbstractTest.fail((String)("Failed to clean up test project: " + e.getLocalizedMessage()));
        }
    }

    public static void trace(String message) {
        if (DEBUGGING) {
            System.out.println(message);
            System.out.flush();
        }
    }

    protected Resource createTestResource(String name) {
        Resource result = null;
        try {
            InputStream input = EmfWorkbenchTestsBundle.getEntry("/test_models/" + name).openStream();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("emfwbtests/" + name));
            file.create(input, true, null);
            result = this.domain.createResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)true).toString());
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractTest.fail((String)("Exception creating test resource: " + e.getLocalizedMessage()));
        }
        return result;
    }

    protected Resource createTestResource(String sourceName, String name, boolean encode) {
        Resource result = null;
        try {
            InputStream input = EmfWorkbenchTestsBundle.getEntry("/test_models/" + sourceName).openStream();
            IFile file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path("emfwbtests/" + name));
            file.create(input, true, null);
            result = this.domain.createResource(URI.createPlatformResourceURI((String)file.getFullPath().toString(), (boolean)encode).toString());
            result.load(Collections.EMPTY_MAP);
        }
        catch (Exception e) {
            e.printStackTrace();
            AbstractTest.fail((String)("Exception creating test resource: " + e.getLocalizedMessage()));
        }
        return result;
    }

    protected void fail(Exception e) {
        e.printStackTrace();
        AbstractTest.fail((String)("Should not have thrown: " + e.getLocalizedMessage()));
    }

    protected void assertFound(String name) {
        AbstractTest.assertNotNull((String)("Did not find " + name), (Object)this.find(this.testResource, name));
    }

    protected void assertFound(Object start, String name) {
        AbstractTest.assertNotNull((String)("Did not find " + name), (Object)this.find(this.testResource, name));
    }

    protected void assertNotFound(String name) {
        AbstractTest.assertNull((String)("Found " + name), (Object)this.find(this.testResource, name));
    }

    protected void assertNotFound(Object start, String name) {
        AbstractTest.assertNull((String)("Found " + name), (Object)this.find(this.testResource, name));
    }

    protected EObject find(String qname) {
        return this.find(this.testResource, qname);
    }

    protected EObject find(Object start, String qname) {
        EObject result = null;
        Object current = start;
        String[] names = this.tokenize(qname);
        int i = 0;
        while (current != null && i < names.length) {
            String name = names[i];
            result = null;
            for (EObject child : this.getContents(current)) {
                if (!name.equals(this.getName(child))) continue;
                result = child;
                break;
            }
            current = result;
            ++i;
        }
        return result;
    }

    private String getName(EObject object) {
        return (String)GetName.INSTANCE.doSwitch(object);
    }

    private List<EObject> getContents(Object object) {
        if (object instanceof EObject) {
            return ((EObject)object).eContents();
        }
        if (object instanceof Resource) {
            return ((Resource)object).getContents();
        }
        return Collections.emptyList();
    }

    private String[] tokenize(String qname) {
        return qname.split("/");
    }

    protected TransactionalCommandStack getCommandStack() {
        return (TransactionalCommandStack)this.domain.getCommandStack();
    }

    protected void startWriting() {
        try {
            this.transactionStack.add(((InternalTransactionalEditingDomain)this.domain).startTransaction(false, null));
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    protected void startWriting(String option) {
        this.startWriting(this.makeOptions(option));
    }

    protected void startWriting(Map<?, ?> options) {
        try {
            this.transactionStack.add(((InternalTransactionalEditingDomain)this.domain).startTransaction(false, options));
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    protected void startReading() {
        try {
            this.transactionStack.add(((InternalTransactionalEditingDomain)this.domain).startTransaction(true, null));
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    protected void startReading(String option) {
        this.startReading(this.makeOptions(option));
    }

    protected void startReading(Map<?, ?> options) {
        try {
            this.transactionStack.add(((InternalTransactionalEditingDomain)this.domain).startTransaction(true, options));
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    protected void commitWithRollback() throws RollbackException {
        try {
            ((Transaction)this.transactionStack.remove(this.transactionStack.size() - 1)).commit();
        }
        catch (RollbackException e) {
            throw e;
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    protected void commit() {
        try {
            ((Transaction)this.transactionStack.remove(this.transactionStack.size() - 1)).commit();
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    protected void rollback() {
        try {
            ((Transaction)this.transactionStack.remove(this.transactionStack.size() - 1)).rollback();
        }
        catch (Exception e) {
            this.fail(e);
        }
    }

    protected InternalTransaction getActiveTransaction() {
        return this.transactionStack.isEmpty() ? null : this.transactionStack.get(this.transactionStack.size() - 1);
    }

    protected Map<?, ?> makeOptions(String option) {
        return this.makeOptions(option, true);
    }

    protected Map<?, ?> makeOptions(String option, Object value) {
        if (value == null) {
            return Collections.EMPTY_MAP;
        }
        return Collections.singletonMap(option, value);
    }

    protected Map<?, ?> makeOptions(Object option, Object value, Object ... options) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        result.put(option, value);
        int i = 0;
        while (i < options.length - 1) {
            result.put(options[i], options[i + 1]);
            i += 2;
        }
        return result;
    }

    protected IConstraintStatus findValidationStatus(IStatus status, int severity) {
        IConstraintStatus result = null;
        if (status.isMultiStatus()) {
            IStatus[] children = status.getChildren();
            int i = 0;
            while (result == null && i < children.length) {
                result = this.findValidationStatus(children[i], severity);
                ++i;
            }
        } else if (status instanceof IConstraintStatus && status.getSeverity() == severity) {
            result = (IConstraintStatus)status;
        }
        return result;
    }

    public void test_DoNothing() {
        String why = "Maven wants to find a test to run in this abstract class";
        AbstractTest.assertTrue((boolean)why.contains("Maven"));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class GetName
    extends EXTLibrarySwitch<String> {
        static final GetName INSTANCE = new GetName();

        private GetName() {
        }

        public Object caseAudoVisualItem(AudioVisualItem object) {
            return object.getTitle();
        }

        public String caseBook(Book object) {
            return object.getTitle();
        }

        public String caseLibrary(Library object) {
            return object.getName();
        }

        public String casePeriodical(Periodical object) {
            return object.getTitle();
        }

        public String caseWriter(Writer object) {
            return object.getName();
        }

        public String casePerson(Person object) {
            if (object.getFirstName() == null) {
                if (object.getLastName() == null) {
                    return "";
                }
                return object.getLastName();
            }
            if (object.getLastName() == null) {
                return object.getFirstName();
            }
            StringBuffer result = new StringBuffer();
            result.append(object.getFirstName()).append(' ').append(object.getLastName());
            return result.toString();
        }

        public String defaultCase(EObject object) {
            return "";
        }
    }
}

