/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.views.components;

import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.BasicDiagnostic;
import org.eclipse.emf.common.util.Diagnostic;
import org.eclipse.emf.common.util.WrappedException;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.util.Diagnostician;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.eef.runtime.api.notify.IPropertiesEditionEvent;
import org.eclipse.emf.eef.runtime.context.PropertiesEditingContext;
import org.eclipse.emf.eef.runtime.impl.components.SinglePartPropertiesEditingComponent;
import org.eclipse.emf.eef.runtime.impl.utils.EEFConverterUtil;
import org.eclipse.emf.eef.views.Category;
import org.eclipse.emf.eef.views.ViewsPackage;
import org.eclipse.emf.eef.views.parts.CategoryPropertiesEditionPart;
import org.eclipse.emf.eef.views.parts.ViewsViewsRepository;

public class CategoryBasePropertiesEditionComponent
extends SinglePartPropertiesEditingComponent {
    public static String BASE_PART = "Base";

    public CategoryBasePropertiesEditionComponent(PropertiesEditingContext editingContext, EObject category, String editing_mode) {
        super(editingContext, category, editing_mode);
        this.parts = new String[]{BASE_PART};
        this.repositoryKey = ViewsViewsRepository.class;
        this.partKey = ViewsViewsRepository.Category.class;
    }

    public void initPart(Object key, int kind, EObject elt, ResourceSet allResource) {
        this.setInitializing(true);
        if (this.editingPart != null && key == this.partKey) {
            this.editingPart.setContext(elt, allResource);
            Category category = (Category)elt;
            CategoryPropertiesEditionPart basePart = (CategoryPropertiesEditionPart)this.editingPart;
            if (category.getName() != null) {
                basePart.setName(EEFConverterUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)category.getName()));
            }
        }
        this.setInitializing(false);
    }

    public void updateSemanticModel(IPropertiesEditionEvent event) {
        Category category = (Category)this.semanticObject;
        if (ViewsViewsRepository.Category.Properties.name == event.getAffectedEditor()) {
            category.setName((String)EEFConverterUtil.createFromString((EDataType)EcorePackage.eINSTANCE.getEString(), (String)((String)event.getNewValue())));
        }
    }

    public void updatePart(Notification msg) {
        if (this.editingPart.isVisible()) {
            CategoryPropertiesEditionPart basePart = (CategoryPropertiesEditionPart)this.editingPart;
            if (ViewsPackage.eINSTANCE.getCategory_Name().equals(msg.getFeature()) && basePart != null) {
                if (msg.getNewValue() != null) {
                    basePart.setName(EcoreUtil.convertToString((EDataType)EcorePackage.eINSTANCE.getEString(), (Object)msg.getNewValue()));
                } else {
                    basePart.setName("");
                }
            }
        }
    }

    public boolean isRequired(Object key, int kind) {
        return key == ViewsViewsRepository.Category.Properties.name;
    }

    public String getHelpContent(Object key, int kind) {
        if (key == ViewsViewsRepository.Category.Properties.name) {
            return "The category name";
        }
        return super.getHelpContent(key, kind);
    }

    public Diagnostic validateValue(IPropertiesEditionEvent event) {
        Diagnostic ret = Diagnostic.OK_INSTANCE;
        if (event.getNewValue() != null) {
            try {
                if (ViewsViewsRepository.Category.Properties.name == event.getAffectedEditor()) {
                    Object newValue = event.getNewValue();
                    if (newValue instanceof String) {
                        newValue = EcoreUtil.createFromString((EDataType)ViewsPackage.eINSTANCE.getCategory_Name().getEAttributeType(), (String)((String)newValue));
                    }
                    ret = Diagnostician.INSTANCE.validate(ViewsPackage.eINSTANCE.getCategory_Name().getEAttributeType(), newValue);
                }
            }
            catch (IllegalArgumentException iae) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)iae);
            }
            catch (WrappedException we) {
                ret = BasicDiagnostic.toDiagnostic((Throwable)we);
            }
        }
        return ret;
    }
}

