/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.eef.codegen.core.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ExtensionHelper {
    private static final String POINT_ATTRIBUTE_NAME = "point";
    private static final String EXTENSION_TAG = "extension";
    private static final String PLUGIN_TAG_NAME = "plugin";
    private static final String PLUGIN_XML_FILE_PATH = "plugin.xml";
    private IProject bundleProject;
    private Document document;
    private IFile pluginXML;

    public ExtensionHelper(IProject pluginProject) throws ParserConfigurationException, SAXException, IOException {
        this.bundleProject = pluginProject;
        this.pluginXML = this.pluginXML();
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setIgnoringElementContentWhitespace(false);
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(this.pluginXML.getLocation().toFile());
    }

    public ExtensionHelper(IFile pluginXML) throws ParserConfigurationException, SAXException, IOException {
        this.bundleProject = pluginXML.getProject();
        this.pluginXML = pluginXML;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        this.document = builder.parse(pluginXML.getLocation().toFile());
    }

    public List<Node> extensions() {
        ArrayList<Node> result = new ArrayList<Node>();
        Node pluginTag = this.pluginTag();
        if (pluginTag != null && pluginTag.hasChildNodes()) {
            NodeList elementsByTagName = this.document.getElementsByTagName(EXTENSION_TAG);
            int i = 0;
            Node next = elementsByTagName.item(i);
            while (next != null) {
                result.add(next);
                next = elementsByTagName.item(++i);
            }
        }
        return result;
    }

    public List<Node> extensionsWithID(String id) {
        ArrayList<Node> result = new ArrayList<Node>();
        for (Node node : this.extensions()) {
            NamedNodeMap attributes = node.getAttributes();
            Node namedItem = attributes.getNamedItem(POINT_ATTRIBUTE_NAME);
            if (namedItem == null || !namedItem.getNodeValue().equals(id)) continue;
            result.add(node);
        }
        return result;
    }

    public boolean hasExtension(Node n1) {
        for (Node node : this.extensions()) {
            if (!this.extensionsEqual(n1, node)) continue;
            return true;
        }
        return false;
    }

    public IFile pluginXML() {
        if (this.pluginXML == null) {
            return this.bundleProject.getFile((IPath)new Path(PLUGIN_XML_FILE_PATH));
        }
        return this.pluginXML;
    }

    public List<Node> diff(ExtensionHelper helper) {
        List<Node> extensions = helper.extensions();
        ArrayList<Node> res = new ArrayList<Node>(extensions.size());
        for (Node ext : extensions) {
            if (this.hasExtension(ext)) continue;
            res.add(ext);
        }
        return res;
    }

    public void append(List<Node> extensions) throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        for (Node node : extensions) {
            Node importNode = this.document.importNode(node, true);
            this.pluginTag().appendChild(importNode);
        }
        this.save();
    }

    public void save() throws TransformerConfigurationException, TransformerFactoryConfigurationError, TransformerException {
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        StreamResult result = new StreamResult(this.pluginXML.getLocation().toFile());
        DOMSource source = new DOMSource(this.document);
        transformer.transform(source, result);
    }

    private boolean extensionsEqual(Node n1, Node n2) {
        boolean res = this.extensionAttributesEquals(n1, n2);
        if (res) {
            NodeList childNodes = n1.getChildNodes();
            int i = 0;
            while (i < childNodes.getLength()) {
                Node childNode = childNodes.item(i);
                if (!this.hasAMatchingSubNode(childNode, n2)) {
                    return false;
                }
                ++i;
            }
        }
        return res;
    }

    private boolean extensionAttributesEquals(Node n1, Node n2) {
        NamedNodeMap n1Attributes = n1.getAttributes();
        NamedNodeMap n2Attributes = n2.getAttributes();
        if (n1Attributes == null) {
            return n2Attributes == null;
        }
        if (n2Attributes == null) {
            return false;
        }
        int i = 0;
        while (i < n1Attributes.getLength()) {
            Node item = n1Attributes.item(i);
            String nodeName = item.getNodeName();
            Node matchingItem = n2Attributes.getNamedItem(nodeName);
            if (!item.getNodeValue().equals(matchingItem.getNodeValue())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean hasAMatchingSubNode(Node subNode, Node processingNode) {
        NodeList childNodes = processingNode.getChildNodes();
        int i = 0;
        while (i < childNodes.getLength()) {
            Node childNode = childNodes.item(i);
            if (this.extensionsEqual(subNode, childNode)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Node pluginTag() {
        NodeList pluginTags = this.document.getElementsByTagName(PLUGIN_TAG_NAME);
        if (pluginTags.item(0) != null) {
            return pluginTags.item(0);
        }
        return null;
    }
}

