/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.api;

import java.net.URL;
import org.eclipse.core.runtime.Platform;
import org.eclipse.eef.common.api.utils.Util;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EEFPage;
import org.eclipse.eef.core.api.EEFView;
import org.eclipse.eef.core.api.InputDescriptor;
import org.eclipse.eef.core.api.utils.EvalFactory;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.Updater;
import org.eclipse.eef.ide.ui.internal.widgets.EEFSectionLifecycleManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbenchPart;

public class EEFTab {
    private EEFPage eefPage;
    private EEFSectionLifecycleManager lifecycleManager;
    private Updater updater;
    private IEEFFormContainer formContainer;

    public EEFTab(EEFPage eefPage) {
        this.eefPage = eefPage;
        this.lifecycleManager = new EEFSectionLifecycleManager(eefPage);
    }

    public void createControls(Composite parent, IEEFFormContainer container) {
        EEFIdeUiPlugin.getPlugin().debug("EEFSection#createControls(...)");
        this.formContainer = container;
        Composite composite = container.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(1, false));
        this.lifecycleManager.createControl(composite, container);
        parent.layout();
        this.updater = new Updater(this, container);
    }

    public void aboutToBeShown() {
        EEFIdeUiPlugin.getPlugin().debug("EEFSection#aboutToBeShown(...)");
        this.lifecycleManager.aboutToBeShown();
        this.updater.enable();
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        EEFIdeUiPlugin.getPlugin().debug("EEFSection#setInput(...)");
        if (selection instanceof IStructuredSelection) {
            IStructuredSelection iStructuredSelection = (IStructuredSelection)selection;
            Object object = iStructuredSelection.getFirstElement();
            InputDescriptor input = (InputDescriptor)Platform.getAdapterManager().getAdapter(object, InputDescriptor.class);
            if (input != null) {
                this.eefPage.getView().setInput(input);
            }
        }
    }

    public void refresh() {
        EEFIdeUiPlugin.getPlugin().debug("EEFSection#refresh(...)");
        EEFView eefView = this.eefPage.getView();
        String labelExpression = eefView.getDescription().getLabelExpression();
        String title = (String)EvalFactory.of((IInterpreter)eefView.getInterpreter(), (IVariableManager)eefView.getVariableManager()).logIfInvalidType(String.class).evaluate(labelExpression);
        if (!Util.isBlank((String)title)) {
            this.formContainer.getForm().setText(title);
        }
        String imageExpression = eefView.getDescription().getImageExpression();
        Object object = EvalFactory.of((IInterpreter)eefView.getInterpreter(), (IVariableManager)eefView.getVariableManager()).evaluate(imageExpression);
        if (object instanceof URL) {
            Image image = EEFIdeUiPlugin.getPlugin().getImage((URL)object);
            this.formContainer.getForm().setImage(image);
        }
        this.lifecycleManager.refresh();
    }

    public void aboutToBeHidden() {
        EEFIdeUiPlugin.getPlugin().debug("EEFSection#aboutToBeHidden(...)");
        this.updater.disable();
        this.lifecycleManager.aboutToBeHidden();
    }

    public void dispose() {
        EEFIdeUiPlugin.getPlugin().debug("EEFSection#dispose(...)");
        this.lifecycleManager.dispose();
        this.formContainer = null;
    }

    public EEFPage getEEFPage() {
        return this.eefPage;
    }
}

