/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.eef.EEFContainerDescription;
import org.eclipse.eef.EEFControlDescription;
import org.eclipse.eef.EEFFillLayoutDescription;
import org.eclipse.eef.EEFGridLayoutDescription;
import org.eclipse.eef.EEFGroupDescription;
import org.eclipse.eef.EEFLayoutDescription;
import org.eclipse.eef.EEF_FILL_LAYOUT_ORIENTATION;
import org.eclipse.eef.common.ui.api.EEFWidgetFactory;
import org.eclipse.eef.common.ui.api.IEEFFormContainer;
import org.eclipse.eef.core.api.EditingContextAdapter;
import org.eclipse.eef.ide.ui.api.widgets.IEEFLifecycleManager;
import org.eclipse.eef.ide.ui.internal.widgets.EEFControlSwitch;
import org.eclipse.emf.common.util.EList;
import org.eclipse.sirius.common.interpreter.api.IInterpreter;
import org.eclipse.sirius.common.interpreter.api.IVariableManager;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;

public class EEFContainerLifecycleManager
implements IEEFLifecycleManager {
    private IVariableManager variableManager;
    private IInterpreter interpreter;
    private EditingContextAdapter contextAdapter;
    private EEFContainerDescription description;
    private List<IEEFLifecycleManager> lifecycleManagers = new ArrayList<IEEFLifecycleManager>();

    public EEFContainerLifecycleManager(EEFContainerDescription description, IVariableManager variableManager, IInterpreter interpreter, EditingContextAdapter contextAdapter) {
        this.description = description;
        this.variableManager = variableManager;
        this.interpreter = interpreter;
        this.contextAdapter = contextAdapter;
    }

    @Override
    public void createControl(Composite parent, IEEFFormContainer formContainer) {
        EEFWidgetFactory widgetFactory = formContainer.getWidgetFactory();
        Composite composite = null;
        if (this.description.eContainer() instanceof EEFGroupDescription) {
            widgetFactory.createLabel(parent, "");
            widgetFactory.createLabel(parent, "");
        }
        composite = widgetFactory.createComposite(parent);
        GridData gridData = new GridData(768);
        composite.setLayoutData((Object)gridData);
        GridLayout compositeLayout = new GridLayout(1, true);
        compositeLayout.marginWidth = 1;
        EEFLayoutDescription layout = this.description.getLayout();
        if (layout instanceof EEFFillLayoutDescription) {
            EEFFillLayoutDescription fillLayoutDescription = (EEFFillLayoutDescription)layout;
            if (fillLayoutDescription.getOrientation() == EEF_FILL_LAYOUT_ORIENTATION.HORIZONTAL) {
                compositeLayout = new GridLayout(this.description.getControls().size(), false);
                compositeLayout.marginWidth = 1;
            }
        } else if (layout instanceof EEFGridLayoutDescription) {
            EEFGridLayoutDescription gridLayoutDescription = (EEFGridLayoutDescription)layout;
            compositeLayout = new GridLayout(gridLayoutDescription.getNumberOfColumns(), gridLayoutDescription.isMakeColumnsWithEqualWidth());
            compositeLayout.marginWidth = 1;
        }
        composite.setLayout((Layout)compositeLayout);
        EEFControlSwitch eefControlSwitch = new EEFControlSwitch(this.interpreter, this.contextAdapter);
        EList controls = this.description.getControls();
        for (EEFControlDescription eefControlDescription : controls) {
            this.lifecycleManagers.addAll(eefControlSwitch.doCreate(composite, formContainer, eefControlDescription, this.variableManager));
        }
    }

    @Override
    public void aboutToBeShown() {
        for (IEEFLifecycleManager lifecycleManager : this.lifecycleManagers) {
            lifecycleManager.aboutToBeShown();
        }
    }

    @Override
    public void refresh() {
        for (IEEFLifecycleManager lifecycleManager : this.lifecycleManagers) {
            lifecycleManager.refresh();
        }
    }

    @Override
    public void aboutToBeHidden() {
        for (IEEFLifecycleManager lifecycleManager : this.lifecycleManagers) {
            lifecycleManager.aboutToBeHidden();
        }
    }

    @Override
    public void dispose() {
        for (IEEFLifecycleManager lifecycleManager : this.lifecycleManagers) {
            lifecycleManager.dispose();
        }
    }
}

