/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.eef.ide.ui.internal.widgets.quickfix;

import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.eef.EEFValidationFixDescription;
import org.eclipse.eef.EEFValidationRuleDescription;
import org.eclipse.eef.EefPackage;
import org.eclipse.eef.core.api.InvalidValidationRuleResultData;
import org.eclipse.eef.ide.ui.internal.EEFIdeUiPlugin;
import org.eclipse.eef.ide.ui.internal.Messages;
import org.eclipse.eef.ide.ui.internal.widgets.quickfix.EEFQuickFixTableComparator;
import org.eclipse.eef.ide.ui.internal.widgets.quickfix.EEFQuickFixTableContentProvider;
import org.eclipse.eef.ide.ui.internal.widgets.quickfix.EEFQuickFixTableLabelProvider;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerComparator;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.forms.IMessage;

public class EEFQuickFixPage
extends WizardPage {
    private TableViewer quickFixesList;
    private EEFValidationRuleDescription validationRule;
    private IMessage selectedMessage;
    private InvalidValidationRuleResultData data;

    public EEFQuickFixPage(IMessage message, EEFValidationRuleDescription validationRule, InvalidValidationRuleResultData data) {
        super(message.getMessage());
        this.setTitle(Messages.EEFQuickFixPage_title);
        this.setDescription(MessageFormat.format(Messages.EEFQuickFixPage_description, message.getMessage()));
        this.validationRule = validationRule;
        this.data = data;
        this.selectedMessage = message;
    }

    public IMessage getSelectedMessage() {
        return this.selectedMessage;
    }

    public void createControl(Composite parent) {
        this.initializeDialogUnits((Control)parent);
        Composite control = new Composite(parent, 0);
        control.setLayoutData((Object)new GridData(4, 4, true, true));
        this.setControl((Control)control);
        FormLayout layout = new FormLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.spacing = this.convertHorizontalDLUsToPixels(4);
        control.setLayout((Layout)layout);
        Label label = new Label(control, 0);
        label.setText(Messages.EEFQuickFixPage_label);
        label.setLayoutData((Object)new FormData());
        this.quickFixesList = new TableViewer(control, 2564);
        this.quickFixesList.setContentProvider((IContentProvider)new EEFQuickFixTableContentProvider());
        this.quickFixesList.setLabelProvider((IBaseLabelProvider)new EEFQuickFixTableLabelProvider());
        this.quickFixesList.setComparator((ViewerComparator)new EEFQuickFixTableComparator());
        this.quickFixesList.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                EEFQuickFixPage.this.setPageComplete(true);
            }
        });
        FormData listData = new FormData();
        listData.top = new FormAttachment((Control)label, 0);
        listData.left = new FormAttachment(0);
        listData.right = new FormAttachment(100, 0);
        listData.height = this.convertHeightInCharsToPixels(10);
        this.quickFixesList.getControl().setLayoutData((Object)listData);
        this.quickFixesList.setInput((Object)this.validationRule);
        Dialog.applyDialogFont((Control)control);
        Object firstElement = this.quickFixesList.getElementAt(0);
        if (firstElement != null) {
            this.quickFixesList.setSelection((ISelection)new StructuredSelection(firstElement));
        } else {
            this.setMessage(Messages.EEFQuickFixWizard_noQuickFixAvailable, 3);
        }
    }

    public boolean isPageComplete() {
        return this.quickFixesList != null && this.validationRule.getFixes().size() > 0 && !this.quickFixesList.getSelection().isEmpty();
    }

    public void performFinish(IProgressMonitor monitor) {
        try {
            this.getWizard().getContainer().run(false, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor progressMonitor) throws InvocationTargetException, InterruptedException {
                    progressMonitor.beginTask(Messages.EEFQuickFixWizard_applyQuickFix, 1);
                    EEFQuickFixPage.this.getShell().getDisplay().readAndDispatch();
                    if (progressMonitor.isCanceled()) {
                        return;
                    }
                    EEFQuickFixPage.this.executeQuickFix();
                    progressMonitor.worked(1);
                }
            });
        }
        catch (InvocationTargetException e) {
            EEFIdeUiPlugin.getPlugin().error(e.getMessage(), e);
        }
        catch (InterruptedException e) {
            EEFIdeUiPlugin.getPlugin().error(e.getMessage(), e);
        }
    }

    private void executeQuickFix() {
        IStructuredSelection structuredSelection;
        Object element;
        ISelection selection = this.quickFixesList.getSelection();
        if (selection instanceof IStructuredSelection && (element = (structuredSelection = (IStructuredSelection)selection).getFirstElement()) instanceof EEFValidationFixDescription) {
            final EEFValidationFixDescription validationFix = (EEFValidationFixDescription)element;
            final EAttribute expressionEAttribute = EefPackage.Literals.EEF_VALIDATION_FIX_DESCRIPTION__FIX_EXPRESSION;
            if (this.data.getEditingContextAdapter() != null) {
                this.data.getEditingContextAdapter().performModelChange(new Runnable(){

                    @Override
                    public void run() {
                        EEFQuickFixPage.this.data.getEval().logIfBlank(expressionEAttribute).call(validationFix.getFixExpression());
                    }
                });
            } else {
                this.data.getEval().logIfBlank(expressionEAttribute).call(validationFix.getFixExpression());
            }
        }
    }
}

