/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.actions;

import org.eclipse.emf.henshin.statespace.StateSpaceManager;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.emf.henshin.statespace.explorer.actions.AbstractStateSpaceAction;
import org.eclipse.emf.henshin.statespace.explorer.commands.MergeTerminalStatesCommand;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;

public class MergeTerminalStatesAction
extends AbstractStateSpaceAction {
    public void run(IAction action) {
        Shell shell = this.getExplorer().getSite().getShell();
        boolean confirmed = MessageDialog.openConfirm((Shell)shell, (String)"Merge Terminal States", (String)"Really merge all terminal states?");
        if (confirmed) {
            StateSpaceManager manager = this.getExplorer().getStateSpaceManager();
            MergeTerminalStatesCommand command = new MergeTerminalStatesCommand(manager);
            try {
                int stateCount = manager.getStateSpace().getStateCount();
                this.getExplorer().executeCommand(command);
                int removed = stateCount - manager.getStateSpace().getStateCount();
                MessageDialog.openInformation((Shell)shell, (String)"Merge Terminal States", (String)("Removed " + removed + " states."));
            }
            catch (Throwable t) {
                StateSpaceExplorerPlugin.getInstance().logError("Error merging terminal states", t);
                MessageDialog.openError((Shell)shell, (String)"Error", (String)"Error merging terminal states. See the error log for more information.");
            }
        }
    }
}

