/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.statespace.explorer.parts;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.IJobChangeEvent;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.core.runtime.jobs.JobChangeAdapter;
import org.eclipse.draw2d.FigureCanvas;
import org.eclipse.draw2d.Viewport;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.henshin.statespace.Path;
import org.eclipse.emf.henshin.statespace.StateSpace;
import org.eclipse.emf.henshin.statespace.StateSpacePlugin;
import org.eclipse.emf.henshin.statespace.StateSpaceValidator;
import org.eclipse.emf.henshin.statespace.StateValidator;
import org.eclipse.emf.henshin.statespace.ValidationResult;
import org.eclipse.emf.henshin.statespace.Validator;
import org.eclipse.emf.henshin.statespace.explorer.StateSpaceExplorerPlugin;
import org.eclipse.emf.henshin.statespace.explorer.actions.CreateInitialStateAction;
import org.eclipse.emf.henshin.statespace.explorer.actions.EditPropertiesAction;
import org.eclipse.emf.henshin.statespace.explorer.actions.ExportStateSpaceAction;
import org.eclipse.emf.henshin.statespace.explorer.actions.ImportRulesAction;
import org.eclipse.emf.henshin.statespace.explorer.actions.MergeTerminalStatesAction;
import org.eclipse.emf.henshin.statespace.explorer.actions.ResetStateSpaceAction;
import org.eclipse.emf.henshin.statespace.explorer.edit.StateSpaceEditPart;
import org.eclipse.emf.henshin.statespace.explorer.jobs.LayoutStateSpaceJob;
import org.eclipse.emf.henshin.statespace.explorer.jobs.StateSpaceJobManager;
import org.eclipse.emf.henshin.statespace.explorer.jobs.ValidateStateSpaceJob;
import org.eclipse.emf.henshin.statespace.explorer.parts.StateSpaceExplorer;
import org.eclipse.emf.henshin.statespace.explorer.parts.StateSpaceToolsMenuFactory;
import org.eclipse.emf.henshin.statespace.explorer.parts.StateSpaceXYPlotDialog;
import org.eclipse.emf.henshin.statespace.impl.ShortestPathStateSpaceValidator;
import org.eclipse.emf.henshin.statespace.layout.StateSpaceSpringLayouter;
import org.eclipse.emf.henshin.statespace.util.StateSpaceXYPlot;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.ExpandBar;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Scale;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class StateSpaceToolsMenu
extends Composite {
    public static double[] ZOOM_LEVELS = new double[]{0.1, 0.15, 0.2, 0.25, 0.3, 0.35, 0.4, 0.45, 0.5, 0.55, 0.6, 0.65, 0.7, 0.75, 0.8, 0.85, 0.9, 0.95, 1.0};
    public static final double REPULSION_FACTOR = 2.0;
    public static final double ATTRACTION_FACTOR = 0.05;
    public static final int NATURAL_LENGTH = 25;
    private StateSpaceJobManager jobManager;
    private StateSpaceExplorer explorer;
    private Label statesLabel;
    private Label transitionsLabel;
    private Label rulesLabel;
    private ZoomManager zoomManager;
    private Scale zoomScale;
    private FigureCanvas canvas;
    private Scale repulsionScale;
    private Scale attractionScale;
    private Link layouterLink;
    private Link explorerLink;
    private Link initialStateLink;
    private Link importLink;
    private Link resetLink;
    private Link exportLink;
    private Link propertiesLink;
    private Link mergeTerminalsLink;
    private Button validateButton;
    private Button hideIndizesButton;
    private Button hideLabelsButton;
    private Text validationText;
    private Combo validatorCombo;
    private List<StateSpaceValidator> validators;
    private Adapter adapter = new AdapterImpl(){

        public void notifyChanged(Notification event) {
            StateSpaceToolsMenu.this.refresh();
        }
    };
    private SelectionListener layouterScaleListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            StateSpaceToolsMenu.this.commitMetadata();
            StateSpaceToolsMenu.this.updateLayouterProperties();
        }

        public void widgetSelected(SelectionEvent e) {
            StateSpaceToolsMenu.this.commitMetadata();
            StateSpaceToolsMenu.this.updateLayouterProperties();
        }
    };
    private SelectionListener scrollBarListener = new SelectionListener(){

        public void widgetDefaultSelected(SelectionEvent e) {
            StateSpaceToolsMenu.this.updateLayouterProperties();
        }

        public void widgetSelected(SelectionEvent e) {
            StateSpaceToolsMenu.this.updateLayouterProperties();
        }
    };
    private Listener canvasListener = new Listener(){

        public void handleEvent(Event event) {
            StateSpaceToolsMenu.this.updateLayouterProperties();
        }
    };
    private SelectionListener zoomListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            StateSpaceToolsMenu.this.commitMetadata();
            StateSpaceToolsMenu.this.updateLayouterProperties();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener hideLabelsListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            StateSpaceToolsMenu.this.commitMetadata();
            if (StateSpaceToolsMenu.this.explorer != null) {
                RootEditPart root = StateSpaceToolsMenu.this.explorer.getGraphicalViewer().getRootEditPart();
                ((StateSpaceEditPart)((Object)root.getChildren().get(0))).refreshLabels();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener initialStateListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.explorer != null) {
                CreateInitialStateAction action = new CreateInitialStateAction();
                action.setExplorer(StateSpaceToolsMenu.this.explorer);
                action.run(null);
                StateSpaceToolsMenu.this.refresh();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener importListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.explorer != null) {
                ImportRulesAction action = new ImportRulesAction();
                action.setExplorer(StateSpaceToolsMenu.this.explorer);
                action.run(null);
                StateSpaceToolsMenu.this.refresh();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener exportListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.explorer != null) {
                ExportStateSpaceAction action = new ExportStateSpaceAction();
                action.setExplorer(StateSpaceToolsMenu.this.explorer);
                action.run(null);
                StateSpaceToolsMenu.this.refresh();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener resetListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.explorer != null) {
                ResetStateSpaceAction action = new ResetStateSpaceAction();
                action.setExplorer(StateSpaceToolsMenu.this.explorer);
                action.run(null);
                StateSpaceToolsMenu.this.refresh();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener propertiesListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.explorer != null) {
                EditPropertiesAction action = new EditPropertiesAction();
                action.setExplorer(StateSpaceToolsMenu.this.explorer);
                action.run(null);
                StateSpaceToolsMenu.this.refresh();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener mergeTerminalsListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.explorer != null) {
                MergeTerminalStatesAction action = new MergeTerminalStatesAction();
                action.setExplorer(StateSpaceToolsMenu.this.explorer);
                action.run(null);
                StateSpaceToolsMenu.this.refresh();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener explorerListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.jobManager == null) {
                return;
            }
            if (StateSpaceToolsMenu.this.explorerLink.getText().indexOf("Start") >= 0) {
                StateSpaceToolsMenu.this.jobManager.startExploreJob();
                StateSpaceToolsMenu.this.explorerLink.setText(StateSpaceToolsMenu.this.explorerLink.getText().replaceFirst("Start", "Stop"));
            } else {
                StateSpaceToolsMenu.this.jobManager.getExploreJob().cancel();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener layouterListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.jobManager == null) {
                return;
            }
            if (StateSpaceToolsMenu.this.layouterLink.getText().indexOf("Start") >= 0) {
                StateSpaceToolsMenu.this.updateLayouterProperties();
                StateSpaceToolsMenu.this.jobManager.startLayoutJob();
                StateSpaceToolsMenu.this.layouterLink.setText(StateSpaceToolsMenu.this.layouterLink.getText().replaceFirst("Start", "Stop"));
            } else {
                StateSpaceToolsMenu.this.jobManager.stopLayoutJob();
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
            this.widgetSelected(e);
        }
    };
    private SelectionListener validateListener = new SelectionListener(){

        public void widgetSelected(SelectionEvent e) {
            if (StateSpaceToolsMenu.this.jobManager == null || StateSpaceToolsMenu.this.getActiveValidator() == null) {
                return;
            }
            StateSpaceToolsMenu.this.validateButton.setEnabled(false);
            StateSpaceToolsMenu.this.jobManager.getValidateJob().setProperty(StateSpaceToolsMenu.this.validationText.getText());
            StateSpaceToolsMenu.this.jobManager.getValidateJob().setValidator(StateSpaceToolsMenu.this.getActiveValidator());
            StateSpaceToolsMenu.this.jobManager.startValidateJob();
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }
    };

    public StateSpaceToolsMenu(Composite parent) {
        super(parent, 0);
        this.init();
    }

    private void init() {
        this.setLayout((Layout)new FillLayout());
        ExpandBar bar = new ExpandBar((Composite)this, 512);
        Composite details = StateSpaceToolsMenuFactory.newExpandItemComposite((Composite)bar, 2);
        this.statesLabel = StateSpaceToolsMenuFactory.newDoubleLabel(details, "States:", "0");
        this.transitionsLabel = StateSpaceToolsMenuFactory.newDoubleLabel(details, "Transitions:", "0");
        this.rulesLabel = StateSpaceToolsMenuFactory.newDoubleLabel(details, "Rules:", "0");
        StateSpaceToolsMenuFactory.newExpandItem(bar, details, "Details", 0);
        Composite tasks = StateSpaceToolsMenuFactory.newExpandItemComposite((Composite)bar, 2);
        this.layouterLink = StateSpaceToolsMenuFactory.newLink(tasks, "<a>Start layouter</a>");
        this.initialStateLink = StateSpaceToolsMenuFactory.newLink(tasks, "<a>New initial state</a>");
        this.explorerLink = StateSpaceToolsMenuFactory.newLink(tasks, "<a>Start explorer</a>");
        this.importLink = StateSpaceToolsMenuFactory.newLink(tasks, "<a>Import rules</a>");
        this.resetLink = StateSpaceToolsMenuFactory.newLink(tasks, "<a>Reset state space</a>");
        this.exportLink = StateSpaceToolsMenuFactory.newLink(tasks, "<a>Export state space</a>");
        this.propertiesLink = StateSpaceToolsMenuFactory.newLink(tasks, "<a>Edit properties</a>");
        this.mergeTerminalsLink = StateSpaceToolsMenuFactory.newLink(tasks, "<a>Merge terminal states</a>");
        StateSpaceToolsMenuFactory.newExpandItem(bar, tasks, "Tasks", 1);
        Composite display = StateSpaceToolsMenuFactory.newExpandItemComposite((Composite)bar, 3);
        StateSpaceToolsMenuFactory.newLabel(display, "Zoom: " + (int)(ZOOM_LEVELS[0] * 100.0) + "%", 128);
        this.zoomScale = new Scale(display, 0);
        this.zoomScale.setLayoutData((Object)new GridData(768));
        this.zoomScale.setEnabled(false);
        this.zoomScale.setIncrement(1);
        this.zoomScale.setPageIncrement(2);
        this.zoomScale.setMinimum(0);
        this.zoomScale.setMaximum(ZOOM_LEVELS.length - 1);
        this.zoomScale.setSelection(ZOOM_LEVELS.length - 1);
        StateSpaceToolsMenuFactory.newLabel(display, String.valueOf((int)(ZOOM_LEVELS[ZOOM_LEVELS.length - 1] * 100.0)) + "%", 32);
        this.repulsionScale = StateSpaceToolsMenuFactory.newScale(display, "Repulsion:", 1, 100, 5, 10, false, null);
        this.attractionScale = StateSpaceToolsMenuFactory.newScale(display, "Attraction:", 1, 100, 5, 10, false, null);
        Composite chks = new Composite(display, 0);
        chks.setLayout((Layout)new GridLayout(3, false));
        this.hideIndizesButton = new Button(chks, 32);
        this.hideIndizesButton.setText("Hide indizes");
        this.hideLabelsButton = new Button(chks, 32);
        this.hideLabelsButton.setText("Hide labels");
        GridData data = new GridData(32);
        data.horizontalSpan = 3;
        chks.setLayoutData((Object)data);
        StateSpaceToolsMenuFactory.newExpandItem(bar, display, "Display", 2);
        Composite validation = StateSpaceToolsMenuFactory.newExpandItemComposite((Composite)bar, 2);
        this.validationText = StateSpaceToolsMenuFactory.newMultiText(validation, 2, 80);
        this.validatorCombo = new Combo(validation, 2048);
        this.validatorCombo.setLayoutData((Object)new GridData(768));
        this.validateButton = StateSpaceToolsMenuFactory.newButton(validation, "Run");
        StateSpaceToolsMenuFactory.newExpandItem(bar, validation, "Validation", 3);
        this.initControlsData();
        this.setEnabled(false);
    }

    /*
     * WARNING - void declaration
     */
    private void initControlsData() {
        this.validators = new ArrayList<StateSpaceValidator>();
        Object lastId = null;
        Validator lastValidator = null;
        for (Validator validator : StateSpacePlugin.INSTANCE.getValidators().values()) {
            void var3_4;
            if (lastId != null && StateSpacePlugin.INSTANCE.getValidators().get(lastId) == validator) {
                lastValidator = validator;
            }
            try {
                Validator old = validator;
                Validator validator2 = (Validator)validator.getClass().newInstance();
                if (lastValidator == old) {
                    lastValidator = validator2;
                }
            }
            catch (Throwable t) {
                StateSpaceExplorerPlugin.getInstance().logError("Validator cannot be reinstantiated", t);
            }
            if (var3_4 instanceof StateSpaceValidator) {
                this.validators.add((StateSpaceValidator)var3_4);
                continue;
            }
            this.validators.add((StateSpaceValidator)new ShortestPathStateSpaceValidator((StateValidator)var3_4));
        }
        Collections.sort(this.validators, new Comparator<Validator>(){

            @Override
            public int compare(Validator v1, Validator v2) {
                String n1 = v1.getName();
                String n2 = v2.getName();
                return n1 != null && n2 != null ? n1.compareTo(n2) : 0;
            }
        });
        this.validatorCombo.add("");
        for (Validator validator : this.validators) {
            this.validatorCombo.add(validator.getName());
        }
        this.validatorCombo.select(0);
        String string = "";
        this.validationText.setText(string != null ? string : "");
        this.validationText.setEnabled(this.getActiveValidator() != null && this.getActiveValidator().usesProperty());
    }

    private void updateLayouterProperties() {
        if (this.jobManager == null) {
            return;
        }
        LayoutStateSpaceJob layoutJob = this.jobManager.getLayoutJob();
        StateSpaceSpringLayouter layouter = layoutJob.getLayouter();
        StateSpace stateSpace = this.explorer.getStateSpaceManager().getStateSpace();
        layouter.setStateRepulsion(((double)stateSpace.getLayoutStateRepulsion() + 10.0) * 2.0);
        layouter.setTransitionAttraction(((double)stateSpace.getLayoutTransitionAttraction() + 40.0) * 0.05);
        layouter.setNaturalTransitionLength(25);
        double zoom = ZOOM_LEVELS[stateSpace.getLayoutZoomLevel() * (ZOOM_LEVELS.length - 1) / 100];
        if (this.zoomManager != null) {
            this.zoomManager.setZoom(zoom);
        }
        if (this.canvas != null) {
            Viewport port = this.canvas.getViewport();
            double x = (double)(port.getHorizontalRangeModel().getValue() + port.getHorizontalRangeModel().getExtent() / 2) / zoom;
            double y = (double)(port.getVerticalRangeModel().getValue() + port.getVerticalRangeModel().getExtent() / 2) / zoom;
            layouter.setCenter(new double[]{x, y});
        } else {
            layouter.setCenter(null);
        }
    }

    private void commitMetadata() {
        boolean hideIndizes = this.hideIndizesButton.getSelection();
        boolean hideLabels = this.hideLabelsButton.getSelection();
        StateSpace stateSpace = this.explorer.getStateSpaceManager().getStateSpace();
        stateSpace.setLayoutZoomLevel((this.zoomScale.getSelection() + 1) * 100 / ZOOM_LEVELS.length);
        stateSpace.setLayoutStateRepulsion(this.repulsionScale.getSelection());
        stateSpace.setLayoutTransitionAttraction(this.attractionScale.getSelection());
        stateSpace.setLayoutHideIndizes(hideIndizes);
        stateSpace.setLayoutHideLabels(hideLabels);
    }

    public void refresh() {
        if (this.isDisposed()) {
            return;
        }
        if (this.jobManager == null) {
            this.statesLabel.setText("0");
            this.transitionsLabel.setText("0");
            this.rulesLabel.setText("0");
        } else {
            StateSpace stateSpace = this.jobManager.getStateSpaceManager().getStateSpace();
            this.statesLabel.setText(String.valueOf(stateSpace.getStateCount()) + " (" + stateSpace.getOpenStates().size() + " open)");
            this.transitionsLabel.setText(String.valueOf(stateSpace.getTransitionCount()));
            this.rulesLabel.setText(String.valueOf(stateSpace.getRules().size()));
            this.hideIndizesButton.setSelection(stateSpace.isLayoutHideIndizes());
            this.hideLabelsButton.setSelection(stateSpace.isLayoutHideLabels());
        }
    }

    private void updateScales() {
        StateSpace stateSpace = this.jobManager.getStateSpaceManager().getStateSpace();
        this.zoomScale.setSelection(stateSpace.getLayoutZoomLevel() * ZOOM_LEVELS.length / 100);
        this.repulsionScale.setSelection(stateSpace.getLayoutStateRepulsion());
        this.attractionScale.setSelection(stateSpace.getLayoutTransitionAttraction());
    }

    public void setJobManager(StateSpaceJobManager jobManager) {
        if (this.jobManager != null) {
            this.removeListeners();
        }
        this.jobManager = jobManager;
        this.setEnabled(jobManager != null);
        this.refresh();
        this.updateScales();
        if (jobManager != null) {
            this.addListeners();
        }
    }

    public void setEnabled(boolean enabled) {
        this.initialStateLink.setEnabled(enabled);
        this.importLink.setEnabled(enabled);
        this.resetLink.setEnabled(enabled);
        this.propertiesLink.setEnabled(enabled);
        this.layouterLink.setEnabled(enabled);
        this.explorerLink.setEnabled(enabled);
        this.exportLink.setEnabled(enabled);
        this.mergeTerminalsLink.setEnabled(enabled);
        this.repulsionScale.setEnabled(enabled);
        this.attractionScale.setEnabled(enabled);
        this.validateButton.setEnabled(enabled);
        this.validatorCombo.setEnabled(enabled);
        this.validationText.setEnabled(enabled);
        this.hideIndizesButton.setEnabled(enabled);
        this.hideLabelsButton.setEnabled(enabled);
    }

    public void setZoomManager(ZoomManager zoomManager) {
        this.zoomManager = zoomManager;
        this.zoomScale.setEnabled(zoomManager != null);
        if (zoomManager != null) {
            zoomManager.setZoomLevels(ZOOM_LEVELS);
            zoomManager.setZoomAnimationStyle(1);
        }
    }

    public void setCanvas(FigureCanvas canvas) {
        this.canvas = canvas;
        canvas.getHorizontalBar().addSelectionListener(this.scrollBarListener);
        canvas.getVerticalBar().addSelectionListener(this.scrollBarListener);
        canvas.addListener(11, this.canvasListener);
    }

    public void setExplorer(StateSpaceExplorer explorer) {
        this.explorer = explorer;
    }

    private void validationFinished(ValidationResult result, IStatus status) {
        if (status.isOK() && result != null) {
            if (result.getResult() instanceof Path && this.explorer != null) {
                this.explorer.selectPath((Path)result.getResult());
            }
            if (result.isValid()) {
                if (result.getResult() instanceof StateSpaceXYPlot) {
                    String title = String.valueOf(this.getActiveValidator().getName()) + " Plot";
                    new StateSpaceXYPlotDialog(this.getShell(), (StateSpaceXYPlot)result.getResult(), title).open();
                } else {
                    MessageDialog.openInformation((Shell)this.getShell(), (String)"Validation", (String)result.getMessage());
                }
            } else {
                MessageDialog.openError((Shell)this.getShell(), (String)"Validation", (String)result.getMessage());
            }
        }
        this.validateButton.setEnabled(true);
    }

    private StateSpaceValidator getActiveValidator() {
        int index = this.validatorCombo.getSelectionIndex() - 1;
        return index >= 0 ? this.validators.get(index) : null;
    }

    private void addListeners() {
        this.jobManager.getStateSpaceManager().getStateSpace().eAdapters().add((Object)this.adapter);
        this.repulsionScale.addSelectionListener(this.layouterScaleListener);
        this.attractionScale.addSelectionListener(this.layouterScaleListener);
        this.zoomScale.addSelectionListener(this.zoomListener);
        this.explorerLink.addSelectionListener(this.explorerListener);
        this.layouterLink.addSelectionListener(this.layouterListener);
        this.initialStateLink.addSelectionListener(this.initialStateListener);
        this.importLink.addSelectionListener(this.importListener);
        this.exportLink.addSelectionListener(this.exportListener);
        this.resetLink.addSelectionListener(this.resetListener);
        this.propertiesLink.addSelectionListener(this.propertiesListener);
        this.mergeTerminalsLink.addSelectionListener(this.mergeTerminalsListener);
        this.validateButton.addSelectionListener(this.validateListener);
        this.hideIndizesButton.addSelectionListener(this.hideLabelsListener);
        this.hideLabelsButton.addSelectionListener(this.hideLabelsListener);
        this.addLinkJobListener(this.jobManager.getLayoutJob(), this.layouterLink);
        this.addLinkJobListener(this.jobManager.getExploreJob(), this.explorerLink);
        final ValidateStateSpaceJob validateJob = this.jobManager.getValidateJob();
        this.addButtonJobListener(validateJob, this.validateButton);
        validateJob.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(final IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        StateSpaceToolsMenu.this.validationFinished(validateJob.getValidationResult(), event.getResult());
                    }
                });
            }
        });
    }

    private void removeListeners() {
        this.jobManager.getStateSpaceManager().getStateSpace().eAdapters().remove((Object)this.adapter);
        this.repulsionScale.removeSelectionListener(this.layouterScaleListener);
        this.attractionScale.removeSelectionListener(this.layouterScaleListener);
        this.zoomScale.removeSelectionListener(this.zoomListener);
        this.initialStateLink.removeSelectionListener(this.initialStateListener);
        this.importLink.removeSelectionListener(this.importListener);
        this.exportLink.removeSelectionListener(this.exportListener);
        this.propertiesLink.removeSelectionListener(this.propertiesListener);
        this.resetLink.removeSelectionListener(this.resetListener);
        this.explorerLink.removeSelectionListener(this.explorerListener);
        this.layouterLink.removeSelectionListener(this.layouterListener);
        this.mergeTerminalsLink.removeSelectionListener(this.mergeTerminalsListener);
        this.validateButton.removeSelectionListener(this.validateListener);
        this.hideIndizesButton.removeSelectionListener(this.hideLabelsListener);
        this.hideLabelsButton.removeSelectionListener(this.hideLabelsListener);
    }

    private void addButtonJobListener(Job job, final Button checkbox) {
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        if (checkbox != null && !checkbox.isDisposed()) {
                            checkbox.setEnabled(true);
                            checkbox.setSelection(false);
                        }
                    }
                });
            }
        });
    }

    private void addLinkJobListener(Job job, final Link link) {
        job.addJobChangeListener((IJobChangeListener)new JobChangeAdapter(){

            public void done(IJobChangeEvent event) {
                Display.getDefault().asyncExec(new Runnable(){

                    @Override
                    public void run() {
                        StateSpaceToolsMenu.this.refresh();
                        link.setText(link.getText().replaceFirst("Stop", "Start"));
                    }
                });
            }
        });
    }
}

