/*
 * Decompiled with CFR 0.152.
 */
package agg.convert;

import agg.attribute.impl.ValueTuple;
import agg.xt_basis.Arc;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Node;
import agg.xt_basis.Type;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.List;
import java.util.Vector;

public class AGG2ColorGraph {
    public static void exportAGG2ColorGraph(GraGra gra, String outFileName, Type nodetype, Type edgetype) {
        AGG2ColorGraph.exportAGG2ColorGraph(gra.getGraph(), outFileName, nodetype, edgetype);
    }

    public static void exportAGG2ColorGraph(Graph graph, String outFileName, Type nodeType, Type edgeType) {
        if (outFileName.endsWith(".col")) {
            boolean NODE_TYPE = false;
            boolean EDGE_TYPE = false;
            Hashtable<GraphObject, GraphObject> map = new Hashtable<GraphObject, GraphObject>();
            Vector<Arc> edges = new Vector<Arc>();
            edges.addAll(graph.getArcsSet());
            Vector<Node> nodes = new Vector<Node>();
            nodes.addAll(graph.getNodesSet());
            File f = new File(outFileName);
            ByteArrayOutputStream baOut = null;
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(f);
                baOut = new ByteArrayOutputStream();
                String commentPart1 = "c AGG graph (.ggx) ";
                String commentPart2 = "to GraphColor (.col)\n";
                String commentNodeType = "";
                String commentEdgeType = "";
                if (nodeType != null) {
                    commentNodeType = "NODE_TYPE:" + nodeType.getName() + " ";
                    NODE_TYPE = true;
                }
                if (edgeType != null) {
                    commentEdgeType = "EDGE_TYPE:" + edgeType.getName();
                    EDGE_TYPE = true;
                }
                String comment = commentPart1.concat(commentNodeType).concat(commentEdgeType).concat(commentPart2);
                if (NODE_TYPE) {
                    nodes.clear();
                    nodes.addAll(AGG2ColorGraph.getNodes(graph, nodeType));
                }
                Vector<Arc> edgeList = new Vector<Arc>();
                if (EDGE_TYPE) {
                    if (NODE_TYPE) {
                        edgeList.addAll(AGG2ColorGraph.getArcs(graph, nodeType, edgeType));
                    } else {
                        edgeList.addAll(AGG2ColorGraph.getArcs(graph, null, edgeType));
                    }
                } else if (NODE_TYPE) {
                    edgeList.addAll(AGG2ColorGraph.getArcs(graph, nodeType, null));
                } else {
                    edgeList.addAll(edges);
                }
                edges.clear();
                int i = 0;
                while (i < edgeList.size()) {
                    Arc a = (Arc)edgeList.get(i);
                    if (map.get(a.getSource()) != a.getTarget() && map.get(a.getTarget()) != a.getSource()) {
                        map.put(a.getSource(), a.getTarget());
                        edges.add(a);
                    }
                    ++i;
                }
                baOut.write(comment.getBytes());
                fos.write(baOut.toByteArray());
                baOut.flush();
                baOut = new ByteArrayOutputStream();
                String problem = "p edge ";
                problem = problem.concat(String.valueOf(nodes.size()));
                problem = problem.concat(" ");
                problem = problem.concat(String.valueOf(edges.size()));
                problem = problem.concat("\n");
                baOut.write(problem.getBytes());
                fos.write(baOut.toByteArray());
                baOut.flush();
                int i2 = 0;
                while (i2 < edges.size()) {
                    Arc a = (Arc)edges.get(i2);
                    int src = nodes.indexOf(a.getSource()) + 1;
                    int tar = nodes.indexOf(a.getTarget()) + 1;
                    String str = "e ";
                    str = str.concat(String.valueOf(src)).concat(" ");
                    str = str.concat(String.valueOf(tar).concat("\n"));
                    baOut = new ByteArrayOutputStream();
                    baOut.write(str.getBytes());
                    fos.write(baOut.toByteArray());
                    baOut.flush();
                    ++i2;
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static List<Node> getNodes(Graph graph, Type nodeType) {
        Vector<Node> list = new Vector<Node>();
        for (Node n : graph.getNodesSet()) {
            if (n.getType() != nodeType) continue;
            list.add(n);
        }
        return list;
    }

    private static List<Arc> getArcs(Graph graph, Type nodeType, Type edgeType) {
        Vector<Arc> list = new Vector<Arc>();
        for (Arc a : graph.getArcsSet()) {
            if (a.getType() == edgeType) {
                if (nodeType == null || a.getSource().getType() != nodeType || a.getTarget().getType() != nodeType) continue;
                list.add(a);
                continue;
            }
            if (a.getSource().getType() != nodeType || a.getTarget().getType() != nodeType) continue;
            list.add(a);
        }
        return list;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean importColorGraph2AGG(GraGra gra, Graph graph, String colorFileName, Type nodeType, Type edgeType) {
        block16: {
            if (!colorFileName.endsWith(".res") || !gra.isElement(graph)) break block16;
            result = false;
            size = 0;
            nodes = new Vector<Node>();
            if (nodeType != null) {
                nodes.addAll(AGG2ColorGraph.getNodes(graph, nodeType));
            } else {
                nodes.addAll(graph.getNodesSet());
            }
            fos = null;
            b = new byte[2048];
            count = 0;
            lineEnd = 0;
            str = "";
            try {
                f = new File(colorFileName);
                fos = new FileInputStream(f);
                while (count != -1 && lineEnd != -1) {
                    count = fos.read(b);
                    if (count == -1) continue;
                    s = new String(b);
                    array = s.split("CLRS");
                    i = 0;
                    while (i < array.length) {
                        array[i] = "CLRS" + array[i];
                        ++i;
                    }
                    s = array[array.length - 1];
                    while (lineEnd != -1) {
                        lineEnd = s.indexOf("\n");
                        if (lineEnd != -1) {
                            str = s.substring(0, lineEnd);
                            s = s.substring(lineEnd + 1, s.length() - 1);
                        }
                        if (!str.startsWith("CLRS")) ** GOTO lbl38
                        continue;
lbl-1000:
                        // 1 sources

                        {
                            str = str.substring(1, str.length());
lbl38:
                            // 2 sources

                            ** while (str.charAt((int)0) == ' ')
                        }
lbl39:
                        // 1 sources

                        str_e = str.split("   ");
                        i = 0;
                        while (i < str_e.length) {
                            color = str_e[i].trim();
                            indx = i + size;
                            if (indx < nodes.size() && (node = (Node)nodes.get(indx)).getAttribute() != null) {
                                val = (ValueTuple)node.getAttribute();
                                mem = val.getValueMemberAt("color");
                                if (mem == null) {
                                    mem = val.getValueMemberAt("Color");
                                }
                                if (mem != null) {
                                    result = true;
                                    if (mem.getDeclaration().getTypeName().equals("int")) {
                                        mem.setExprAsText(color);
                                    } else if (mem.getDeclaration().getTypeName().equals("String") || mem.getDeclaration().getTypeName().equals("java.lang.String")) {
                                        mem.setExprAsObject(color);
                                    }
                                }
                            }
                            ++i;
                        }
                        size += str_e.length;
                    }
                }
            }
            catch (IOException var13_14) {
                // empty catch block
            }
            return result;
        }
        return false;
    }

    static void warning() {
        System.out.println("Usage unaliased: java -oss3m -Xmx1000m agg.convert.AGG2ColorGraph grammar.ggx ");
        System.out.println("Usage aliased:");
        System.out.println("agg2color grammar");
        System.out.println("Output file: grammar.ggx.col");
        System.out.println("other usage:");
        System.out.println("agg2color grammar.ggx colorResultImport.res ");
        System.out.println("Overwritten file: grammar.ggx");
    }
}

