/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.popupmenu;

import agg.editor.impl.EdAtomic;
import agg.editor.impl.EdConstraint;
import agg.editor.impl.EdGraGra;
import agg.editor.impl.EdGraph;
import agg.editor.impl.EdRule;
import agg.editor.impl.EdRuleScheme;
import agg.editor.impl.EdType;
import agg.gui.AGGAppl;
import agg.gui.event.TreeViewEvent;
import agg.gui.treeview.GraGraTreeModel;
import agg.gui.treeview.GraGraTreeView;
import agg.gui.treeview.dialog.GraGraConstraintLayerDialog;
import agg.gui.treeview.dialog.GraGraConstraintPriorityDialog;
import agg.gui.treeview.dialog.GraGraDisableLayerDialog;
import agg.gui.treeview.dialog.GraGraLayerDialog;
import agg.gui.treeview.dialog.GraGraPriorityDialog;
import agg.gui.treeview.dialog.GraGraTriggerRuleOfLayerDialog;
import agg.gui.treeview.dialog.NodeEdgeTypeSelectionDialog;
import agg.gui.treeview.dialog.SelectRulesDialog;
import agg.gui.treeview.nodedata.AtomicGraphConstraintTreeNodeData;
import agg.gui.treeview.nodedata.ConclusionTreeNodeData;
import agg.gui.treeview.nodedata.ConstraintTreeNodeData;
import agg.gui.treeview.nodedata.GraGraTextualComment;
import agg.gui.treeview.nodedata.GraGraTreeNodeData;
import agg.gui.treeview.nodedata.GrammarTreeNodeData;
import agg.gui.treeview.nodedata.GraphTreeNodeData;
import agg.gui.treeview.nodedata.KernelRuleTreeNodeData;
import agg.gui.treeview.nodedata.RuleSchemeTreeNodeData;
import agg.gui.treeview.nodedata.RuleSequenceTreeNodeData;
import agg.gui.treeview.nodedata.RuleTreeNodeData;
import agg.gui.treeview.nodedata.TypeGraphTreeNodeData;
import agg.gui.treeview.path.GrammarTreeNode;
import agg.ruleappl.RuleSequence;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.Rule;
import agg.xt_basis.RuleLayer;
import agg.xt_basis.RulePriority;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class GraGraPopupMenu
extends JPopupMenu {
    public static final String EXPORT_BY_TYPE_TO_COLOR_GRAPH = "EXPORT_BY_TYPE_TO_COLOR_GRAPH";
    public static final String EXPORT_TO_COLOR_GRAPH = "EXPORT_TO_COLOR_GRAPH";
    public static final String IMPORT_BY_TYPE_FROM_COLOR_GRAPH = "IMPORT_BY_TYPE_FROM_COLOR_GRAPH";
    public static final String IMPORT_FROM_COLOR_GRAPH = "IMPORT_FROM_COLOR_GRAPH";
    JMenuItem miRuleScheme;
    JMenuItem miParallelRule;
    JMenuItem miReload;
    JMenu menuNew;
    GraGraTreeView treeView;
    TreePath path;
    DefaultMutableTreeNode node;
    GraGraTreeNodeData data;
    EdGraGra gra;
    String msg;
    protected final NodeEdgeTypeSelectionDialog typeSelectionDialog;

    public GraGraPopupMenu(GraGraTreeView tree) {
        super("GraGra");
        this.treeView = tree;
        this.typeSelectionDialog = new NodeEdgeTypeSelectionDialog(this.treeView.getFrame());
        this.menuNew = new JMenu("New");
        this.add(this.menuNew);
        JMenuItem mi = this.menuNew.add(new JMenuItem("Type Graph                    Ctrl+Alt+T"));
        mi.setActionCommand("newTypeGraph");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.createTypeGraph();
            }
        });
        mi = this.menuNew.add(new JMenuItem("Graph                            Ctrl+Alt+G"));
        mi.setActionCommand("newGraph");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.createGraph();
            }
        });
        this.menuNew.addSeparator();
        mi = this.menuNew.add(new JMenuItem("Rule                               Ctrl+Alt+R"));
        mi.setActionCommand("newRule");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.createRule();
            }
        });
        this.miRuleScheme = new JMenuItem("RuleScheme                                ");
        this.menuNew.add(this.miRuleScheme);
        this.miRuleScheme.setActionCommand("newRuleScheme");
        this.miRuleScheme.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.createRuleScheme();
            }
        });
        this.miParallelRule = new JMenuItem("Make Parallel Rule by disjoint Union");
        this.miParallelRule.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.makeParallelRule();
            }
        });
        this.menuNew.addSeparator();
        mi = this.menuNew.add(new JMenuItem("Atomic Constraint         Ctrl+Alt+A"));
        mi.setActionCommand("newAtomic");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.createAtomic();
            }
        });
        mi = this.menuNew.add(new JMenuItem("Constraint                     Ctrl+Alt+C"));
        mi.setActionCommand("newConstraint");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.createGraphConstraint();
            }
        });
        this.menuNew.addSeparator();
        mi = this.menuNew.add(new JMenuItem("Rule Sequence        "));
        mi.setActionCommand("newRuleSequence");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.createRuleSequence();
            }
        });
        mi = this.add(new JMenuItem("Add Copy of Current Host Graph"));
        mi.setActionCommand("addGraph");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.addHostGraph();
            }
        });
        this.addSeparator();
        JMenu m = new JMenu("Layering");
        this.add(m);
        mi = m.add(new JMenuItem("Set Rule Layer"));
        mi.setActionCommand("setLayerOfRules");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.setLayerOfRules();
            }
        });
        mi = m.add(new JMenuItem("Set Trigger Rule for Layer"));
        mi.setActionCommand("setTriggerRuleOfLayer");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.setTriggerRuleOfLayer();
            }
        });
        mi = m.add(new JMenuItem("Select Rule Layer for Constraint"));
        mi.setActionCommand("setLayerOfConstraints");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.setLayerOfConstraints();
            }
        });
        m.addSeparator();
        mi = m.add(new JMenuItem("Sort Rules by Layer"));
        mi.setActionCommand("sortRulesByLayer");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.sortRulesByLayer();
            }
        });
        mi = m.add(new JMenuItem("Sort Constraints by Layer"));
        mi.setActionCommand("sortConstraintsByLayer");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.sortConstraintsByLayer();
            }
        });
        m.addSeparator();
        mi = m.add(new JMenuItem("Disable Rule Layer"));
        mi.setActionCommand("disableLayerOfRules");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.disableLayerOfRules();
            }
        });
        this.addSeparator();
        m = new JMenu("Priority");
        this.add(m);
        mi = m.add(new JMenuItem("Set Rule Priority"));
        mi.setActionCommand("setPriorityOfRules");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.setPriorityOfRules();
            }
        });
        mi = m.add(new JMenuItem("Select Rule Priority for Constraint"));
        mi.setActionCommand("setPriorityOfConstraints");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.setPriorityOfConstraints();
            }
        });
        m.addSeparator();
        mi = m.add(new JMenuItem("Sort Rules by Priority"));
        mi.setActionCommand("sortRulesByPriority");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.sortRulesByPriority();
            }
        });
        mi = m.add(new JMenuItem("Sort Constraints by Priority"));
        mi.setActionCommand("sortConstraintsByPriority");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.sortConstraintsByPriority();
            }
        });
        this.addSeparator();
        mi = this.add(new JMenuItem("Check Rule Applicability"));
        mi.setActionCommand("checkRuleApplicability");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.checkRuleApplicability();
            }
        });
        mi = this.add(new JMenuItem("Dismiss Rule Applicability"));
        mi.setActionCommand("dismissRuleApplicability");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.dismissRuleApplicability();
            }
        });
        this.addSeparator();
        m = new JMenu("Consistency");
        this.add(m);
        mi = m.add(new JMenuItem("Check Atomics"));
        mi.setActionCommand("checkAtomics");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.doAtomics(1);
            }
        });
        mi = m.add(new JMenuItem("Check Constraints"));
        mi.setActionCommand("checkConstraints");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.doAtomics(2);
            }
        });
        m.addSeparator();
        mi = m.add(new JMenuItem("Create Post Application Conditions"));
        mi.setActionCommand("convertConstraints");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.doAtomics(0);
            }
        });
        this.addSeparator();
        mi = this.add(new JMenuItem("Close                               Ctrl+W"));
        mi.setActionCommand("deleteGraGra");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (GraGraPopupMenu.this.treeView.hasMultipleSelection()) {
                    GraGraPopupMenu.this.treeView.delete("selected");
                } else {
                    GraGraPopupMenu.this.treeView.delete("GraGra");
                }
            }
        });
        this.addSeparator();
        mi = this.add(new JMenuItem("Save                                Ctrl+S"));
        mi.setActionCommand("save");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.treeView.saveGraGra();
            }
        });
        mi = this.add(new JMenuItem("Save As                            Alt+S"));
        mi.setActionCommand("saveAs");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.treeView.saveAsGraGra();
            }
        });
        this.addSeparator();
        JMenu submExport = (JMenu)this.add(new JMenu("Export"));
        mi = submExport.add(new JMenuItem("JPEG         Shift+J"));
        mi.setEnabled(true);
        mi.setActionCommand("exportGraphJPEG");
        mi.addActionListener(this.treeView.getActionAdapter());
        mi = submExport.add(new JMenuItem("GXL          Shift+X"));
        mi.setEnabled(true);
        mi.setActionCommand("exportGXL");
        mi.addActionListener(this.treeView.getActionAdapter());
        mi = submExport.add(new JMenuItem("GTXL        Shift+T"));
        mi.setEnabled(true);
        mi.setActionCommand("exportGTXL");
        mi.addActionListener(this.treeView.getActionAdapter());
        mi = this.createMenuExportToColorGraph("COLOR GRAPH        ");
        submExport.add(mi);
        mi.setEnabled(true);
        JMenu submImport = (JMenu)this.add(new JMenu("Import"));
        submImport.setEnabled(true);
        mi = submImport.add(new JMenuItem("GGX                         Shift+Alt+G"));
        mi.setEnabled(true);
        mi.setActionCommand("importGGX");
        mi.addActionListener(this.treeView.getActionAdapter());
        mi = submImport.add(new JMenuItem("GXL                          Shift+Alt+X"));
        mi.setEnabled(true);
        mi.setActionCommand("importGXL");
        mi.addActionListener(this.treeView.getActionAdapter());
        mi = new JMenuItem("GTXL");
        mi.setEnabled(false);
        mi.setActionCommand("importGTXL");
        mi.addActionListener(this.treeView.getActionAdapter());
        mi = submImport.add(new JMenuItem("OMONDO XMI          Shift+Alt+O"));
        mi.setEnabled(true);
        mi.setActionCommand("importOMONDOXMI");
        mi.addActionListener(this.treeView.getActionAdapter());
        mi = this.createMenuImportFromColorGraph("COLOR GRAPH        ");
        submImport.add(mi);
        mi.setEnabled(true);
        this.addSeparator();
        mi = this.add(new JMenuItem("Refresh Attributes"));
        mi.setActionCommand("refresh");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.refreshAttrs();
            }
        });
        this.addSeparator();
        this.miReload = this.add(new JMenuItem("Reload                     Shift+Alt+R"));
        this.miReload.setActionCommand("reload");
        this.miReload.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.treeView.reloadGraGra();
            }
        });
        this.addSeparator();
        mi = this.add(new JMenuItem("Textual Comments"));
        mi.setActionCommand("commentGraGra");
        mi.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.editComments();
            }
        });
        this.pack();
        this.setBorderPainted(true);
    }

    public boolean invoked(int x, int y) {
        if (this.treeView == null) {
            return false;
        }
        if (this.treeView.getTree().getRowForLocation(x, y) != -1 && this.treeView.getTree().getPathForLocation(x, y).getPath().length == 2) {
            this.path = this.treeView.getTree().getPathForLocation(x, y);
            this.node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            this.data = (GraGraTreeNodeData)this.node.getUserObject();
            if (this.data.isGraGra()) {
                this.gra = this.data.getGraGra();
                this.typeSelectionDialog.setGraGra(this.gra);
                if (this.treeView.getGraGra().getRules().size() > 1) {
                    this.miParallelRule.setEnabled(true);
                } else {
                    this.miParallelRule.setEnabled(false);
                }
                return true;
            }
        }
        return false;
    }

    boolean invoke() {
        if (this.treeView == null) {
            return false;
        }
        this.path = this.treeView.getSelectedPath();
        if (this.path != null) {
            this.node = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            this.data = (GraGraTreeNodeData)this.node.getUserObject();
            if (this.data.isGraGra()) {
                this.gra = this.data.getGraGra();
                this.typeSelectionDialog.setGraGra(this.gra);
                if (this.treeView.getGraGra().getRules().size() > 1) {
                    this.miParallelRule.setEnabled(true);
                } else {
                    this.miParallelRule.setEnabled(false);
                }
                return true;
            }
            this.path = null;
        }
        return false;
    }

    @Override
    public void show(Component invoker, int x, int y) {
        super.show(invoker, x, y);
        this.typeSelectionDialog.setNodeType(this.treeView.getNodeTypeForColorGraph());
        this.typeSelectionDialog.setEdgeType(this.treeView.getEdgeTypeForColorGraph());
        this.typeSelectionDialog.setLocation(this.getLocationOnScreen().x + 150, this.getLocationOnScreen().y + 50);
    }

    private JMenu createMenuExportToColorGraph(String title) {
        JMenu expMenu = new JMenu(title);
        JMenuItem miAll = expMenu.add(new JMenuItem("Export Complete Current Host Graph"));
        miAll.setSelected(true);
        miAll.setActionCommand(EXPORT_TO_COLOR_GRAPH);
        miAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.treeView.setNodeTypeForColorGraph(null);
                GraGraPopupMenu.this.treeView.setEdgeTypeForColorGraph(null);
                GraGraPopupMenu.this.treeView.getActionAdapter().actionPerformed(e);
            }
        });
        JMenuItem miSpecial = expMenu.add(new JMenuItem("Export specific Nodes and Edges of Current Host Graph"));
        miSpecial.setSelected(false);
        miSpecial.setActionCommand(EXPORT_BY_TYPE_TO_COLOR_GRAPH);
        miSpecial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.typeSelectionDialog.setVisible(true);
                if (!GraGraPopupMenu.this.typeSelectionDialog.isCancelled()) {
                    EdType nodeType = GraGraPopupMenu.this.typeSelectionDialog.getNodeType();
                    EdType edgeType = GraGraPopupMenu.this.typeSelectionDialog.getEdgeType();
                    if (nodeType != null) {
                        GraGraPopupMenu.this.treeView.setNodeTypeForColorGraph(nodeType);
                    } else {
                        GraGraPopupMenu.this.treeView.setNodeTypeForColorGraph(null);
                    }
                    if (edgeType != null) {
                        GraGraPopupMenu.this.treeView.setEdgeTypeForColorGraph(edgeType);
                    } else {
                        GraGraPopupMenu.this.treeView.setEdgeTypeForColorGraph(null);
                    }
                    GraGraPopupMenu.this.treeView.getActionAdapter().actionPerformed(e);
                }
            }
        });
        return expMenu;
    }

    private JMenu createMenuImportFromColorGraph(String title) {
        JMenu impMenu = new JMenu(title);
        JMenuItem miAll = impMenu.add(new JMenuItem("Import into Current Host Graph"));
        miAll.setSelected(true);
        miAll.setActionCommand(IMPORT_FROM_COLOR_GRAPH);
        miAll.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.treeView.setNodeTypeForColorGraph(null);
                GraGraPopupMenu.this.treeView.setEdgeTypeForColorGraph(null);
                GraGraPopupMenu.this.treeView.getActionAdapter().actionPerformed(e);
            }
        });
        JMenuItem miSpecial = impMenu.add(new JMenuItem("Import specific Nodes into Current Host Graph"));
        miSpecial.setSelected(false);
        miSpecial.setActionCommand(IMPORT_BY_TYPE_FROM_COLOR_GRAPH);
        miSpecial.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                GraGraPopupMenu.this.typeSelectionDialog.setVisible(true);
                if (!GraGraPopupMenu.this.typeSelectionDialog.isCancelled()) {
                    EdType nodeType = GraGraPopupMenu.this.typeSelectionDialog.getNodeType();
                    EdType edgeType = GraGraPopupMenu.this.typeSelectionDialog.getEdgeType();
                    if (nodeType != null) {
                        GraGraPopupMenu.this.treeView.setNodeTypeForColorGraph(nodeType);
                    } else {
                        GraGraPopupMenu.this.treeView.setNodeTypeForColorGraph(null);
                    }
                    if (edgeType != null) {
                        GraGraPopupMenu.this.treeView.setEdgeTypeForColorGraph(edgeType);
                    } else {
                        GraGraPopupMenu.this.treeView.setEdgeTypeForColorGraph(null);
                    }
                    GraGraPopupMenu.this.treeView.getActionAdapter().actionPerformed(e);
                }
            }
        });
        return impMenu;
    }

    public void enableRuleScheme() {
        int i = 0;
        while (i < this.menuNew.getItemCount()) {
            if (this.menuNew.getItem(i).getActionCommand().equals("newRule") && i + 1 < this.menuNew.getItemCount() && !this.menuNew.getItem(i + 1).getActionCommand().equals("newRuleScheme")) {
                this.menuNew.insert(this.miRuleScheme, i + 1);
                break;
            }
            ++i;
        }
    }

    void createTypeGraph() {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.path.getLastPathComponent();
        if (this.gra.getTypeSet().getTypeGraph() != null) {
            JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body> The type graph already exists.</body></html>", "", 2);
            return;
        }
        if (this.gra.isEditable()) {
            EdGraph typeGraph = this.gra.createTypeGraph();
            TypeGraphTreeNodeData sdTypeGraph = new TypeGraphTreeNodeData(typeGraph);
            sdTypeGraph.setString("[D]TypeGraph");
            DefaultMutableTreeNode newTypeGraphNode = new DefaultMutableTreeNode(sdTypeGraph);
            sdTypeGraph.setTreeNode(newTypeGraphNode);
            this.treeView.getTreeModel().insertNodeInto(newTypeGraphNode, parent, 0);
        } else {
            this.treeView.lockWarning();
        }
    }

    void createGraph() {
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.path.getLastPathComponent();
        if (this.gra.isEditable()) {
            EdGraph graph = new EdGraph(BaseFactory.theFactory().createGraph(this.gra.getTypeSet().getBasisTypeSet(), true), this.gra.getTypeSet());
            graph.getBasisGraph().setName(String.valueOf(graph.getBasisGraph().getName()) + this.gra.getGraphs().size());
            this.gra.addGraph(graph);
            graph.setGraGra(this.gra);
            GraphTreeNodeData sdGraph = new GraphTreeNodeData(graph);
            DefaultMutableTreeNode newGraphNode = new DefaultMutableTreeNode(sdGraph);
            sdGraph.setTreeNode(newGraphNode);
            int indx = this.gra.getGraphs().size() - 1;
            if (this.gra.getTypeGraph() != null) {
                ++indx;
            }
            this.treeView.getTreeModel().insertNodeInto(newGraphNode, parent, indx);
        } else {
            this.treeView.lockWarning();
        }
    }

    boolean addHostGraph() {
        if (this.path == null) {
            JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>Bad selection.<br> Please select a grammar.", "", 2);
            return false;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.path.getLastPathComponent();
        if (this.gra != this.treeView.getCurrentGraGra()) {
            JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>Bad selection.<br> Please select an appropriate grammar.", "", 2);
            return false;
        }
        if (this.gra.isEditable()) {
            EdGraph g = this.gra.cloneGraph(true);
            if (g != null) {
                int indx = this.gra.getGraphs().size() - 1;
                if (this.gra.getTypeGraph() != null) {
                    ++indx;
                }
                g.getBasisGraph().setName(String.valueOf(this.gra.getGraph().getBasisGraph().getName()) + (this.gra.getGraphs().size() - 1));
                GraphTreeNodeData sdGraph = new GraphTreeNodeData(g);
                DefaultMutableTreeNode newGraphNode = new DefaultMutableTreeNode(sdGraph);
                sdGraph.setTreeNode(newGraphNode);
                this.treeView.getTreeModel().insertNodeInto(newGraphNode, parent, indx);
                return true;
            }
        } else {
            this.treeView.lockWarning();
        }
        return false;
    }

    void createRule() {
        if (this.gra.isEditable()) {
            String tag;
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            int newIndex = this.gra.getGraphs().size() + this.gra.getRules().size();
            if (this.gra.getTypeSet().getTypeGraph() != null) {
                ++newIndex;
            }
            String name = "Rule" + this.gra.getRules().size();
            name = ((GraGraTreeModel)this.treeView.getTree().getModel()).makeNewName(this.gra, name);
            EdRule newRule = this.gra.createRule(name);
            RuleTreeNodeData sdRule = new RuleTreeNodeData(newRule);
            if (this.gra.getBasisGraGra().isLayered()) {
                tag = "[" + newRule.getBasisRule().getLayer() + "]";
                sdRule.setString(tag, name);
            } else if (this.gra.getBasisGraGra().trafoByPriority()) {
                tag = "[" + newRule.getBasisRule().getPriority() + "]";
                sdRule.setString(tag, name);
            }
            DefaultMutableTreeNode newRuleNode = new DefaultMutableTreeNode(sdRule);
            sdRule.setTreeNode(newRuleNode);
            this.treeView.getTreeModel().insertNodeInto(newRuleNode, parent, newIndex);
            this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this.treeView, 73, this.path));
        } else {
            this.treeView.lockWarning();
        }
    }

    void createRuleScheme() {
        if (this.gra.isEditable()) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            int newIndex = this.gra.getGraphs().size() + this.gra.getRules().size();
            if (this.gra.getTypeSet().getTypeGraph() != null) {
                ++newIndex;
            }
            String name = "RuleScheme" + this.gra.getRules().size();
            name = ((GraGraTreeModel)this.treeView.getTree().getModel()).makeNewName(this.gra, name);
            EdRuleScheme newRuleScheme = this.gra.createRuleScheme(name);
            RuleSchemeTreeNodeData sdRuleScheme = new RuleSchemeTreeNodeData(newRuleScheme);
            DefaultMutableTreeNode newRuleSchemeNode = new DefaultMutableTreeNode(sdRuleScheme);
            sdRuleScheme.setTreeNode(newRuleSchemeNode);
            this.treeView.getTreeModel().insertNodeInto(newRuleSchemeNode, parent, newIndex);
            parent = newRuleSchemeNode;
            KernelRuleTreeNodeData sdKernelRule = new KernelRuleTreeNodeData(newRuleScheme.getKernelRule());
            DefaultMutableTreeNode newKernelRuleNode = new DefaultMutableTreeNode(sdKernelRule);
            sdKernelRule.setTreeNode(newKernelRuleNode);
            newIndex = 0;
            this.treeView.getTreeModel().insertNodeInto(newKernelRuleNode, parent, newIndex);
        } else {
            this.treeView.lockWarning();
        }
    }

    void createAtomic() {
        if (this.gra.isEditable()) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            int newIndex = this.gra.getGraphs().size() + this.gra.getRules().size() + this.gra.getAtomics().size();
            if (this.gra.getTypeSet().getTypeGraph() != null) {
                ++newIndex;
            }
            String name = "Atomic";
            if (this.gra.getAtomics().size() > 0) {
                name = String.valueOf(name) + this.gra.getAtomics().size();
            }
            name = ((GraGraTreeModel)this.treeView.getTree().getModel()).makeNewName(this.gra, name);
            EdAtomic newAtomic = this.gra.createAtomic(name);
            AtomicGraphConstraintTreeNodeData sd = new AtomicGraphConstraintTreeNodeData(newAtomic);
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(newNode);
            this.treeView.getTreeModel().insertNodeInto(newNode, parent, newIndex);
            newIndex = newAtomic.getConclusions().size() - 1;
            EdAtomic aConclusion = newAtomic.getConclusion(0);
            name = aConclusion.getMorphism().getName();
            ConclusionTreeNodeData sdc = new ConclusionTreeNodeData(aConclusion);
            DefaultMutableTreeNode aNode = new DefaultMutableTreeNode(sdc);
            sdc.setTreeNode(aNode);
            this.treeView.getTreeModel().insertNodeInto(aNode, newNode, newIndex);
        } else {
            this.treeView.lockWarning();
        }
    }

    void createGraphConstraint() {
        if (this.gra.isEditable()) {
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            int newIndex = this.gra.getGraphs().size() + this.gra.getRules().size() + this.gra.getAtomics().size() + this.gra.getConstraints().size();
            if (this.gra.getTypeSet().getTypeGraph() != null) {
                ++newIndex;
            }
            String name = "Constraint";
            if (this.gra.getConstraints().size() > 0) {
                name = String.valueOf(name) + this.gra.getConstraints().size();
            }
            name = ((GraGraTreeModel)this.treeView.getTree().getModel()).makeNewName(this.gra, name);
            EdConstraint newConstraint = this.gra.createConstraint(name);
            this.handleRuleConstraints(parent, false, newConstraint);
            ConstraintTreeNodeData sd = new ConstraintTreeNodeData(newConstraint);
            if (this.gra.getBasisGraGra().isLayered() && !newConstraint.getBasisConstraint().getLayer().isEmpty()) {
                String tag = "[" + newConstraint.getBasisConstraint().getLayerAsString() + "]";
                sd.setString(tag, name);
            }
            DefaultMutableTreeNode newNode = new DefaultMutableTreeNode(sd);
            sd.setTreeNode(newNode);
            this.treeView.getTreeModel().insertNodeInto(newNode, parent, newIndex);
        } else {
            this.treeView.lockWarning();
        }
    }

    void createRuleSequence() {
        if (this.gra.isEditable()) {
            DefaultMutableTreeNode newRuleSequenceNode;
            RuleSequenceTreeNodeData sdRuleSequence;
            RuleSequence rseq;
            DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.path.getLastPathComponent();
            int indx = this.gra.getGraphs().size() + this.gra.getRules().size() + this.gra.getAtomics().size() + this.gra.getConstraints().size();
            if (this.gra.getTypeSet().getTypeGraph() != null) {
                ++indx;
            }
            this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this.treeView, 30, this.path));
            if (indx + this.gra.getBasisGraGra().getRuleSequences().size() > parent.getChildCount()) {
                int i = 0;
                while (i < this.gra.getBasisGraGra().getRuleSequences().size()) {
                    rseq = this.gra.getBasisGraGra().getRuleSequences().get(i);
                    rseq.setCriticalPairOption(((AGGAppl)this.treeView.getFrame()).getCPA().getCriticalPairOption());
                    sdRuleSequence = new RuleSequenceTreeNodeData(rseq);
                    newRuleSequenceNode = new DefaultMutableTreeNode(sdRuleSequence);
                    sdRuleSequence.setTreeNode(newRuleSequenceNode);
                    this.treeView.getTreeModel().insertNodeInto(newRuleSequenceNode, parent, indx + i);
                    ++i;
                }
            }
            indx += this.gra.getBasisGraGra().getRuleSequences().size();
            String name = "RuleSequence";
            if (!this.gra.getBasisGraGra().getRuleSequences().isEmpty()) {
                name = "RuleSequence" + this.gra.getBasisGraGra().getRuleSequences().size();
            }
            rseq = new RuleSequence(this.gra.getBasisGraGra(), name);
            this.gra.getBasisGraGra().addRuleSequence(rseq);
            rseq.setCriticalPairOption(((AGGAppl)this.treeView.getFrame()).getCPA().getCriticalPairOption());
            sdRuleSequence = new RuleSequenceTreeNodeData(rseq);
            newRuleSequenceNode = new DefaultMutableTreeNode(sdRuleSequence);
            sdRuleSequence.setTreeNode(newRuleSequenceNode);
            this.treeView.getTreeModel().insertNodeInto(newRuleSequenceNode, parent, indx);
        } else {
            this.treeView.lockWarning();
        }
    }

    void checkRuleApplicability() {
        if (this.path == null) {
            JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>Bad selection.<br> Please select a gragra.", "", 2);
            return;
        }
        if (this.gra != null) {
            this.treeView.fireTreeViewEvent(new TreeViewEvent(this.treeView, 18));
        }
    }

    void dismissRuleApplicability() {
        if (this.path == null) {
            JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>Bad selection.<br> Please select a gragra.", "", 2);
            return;
        }
        if (this.gra != null) {
            this.treeView.fireTreeViewEvent(new TreeViewEvent(this.treeView, 181));
        }
    }

    public void doAtomics(int what) {
        if (this.path == null) {
            this.invoke();
            if (this.path == null) {
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>Bad selection.<br> Please select a gragra.", "", 2);
                return;
            }
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.path.getLastPathComponent();
        switch (what) {
            case 0: {
                this.handleRuleConstraints(parent, false, null);
                if (this.gra.getBasisGraGra().getAtomics().hasMoreElements() && this.gra.getBasisGraGra().getConstraints().hasMoreElements()) {
                    JOptionPane pane = new JOptionPane("Creating post application conditions ... \n Please wait ... ", 2);
                    final JDialog d = pane.createDialog("Creating ...");
                    Thread thread = new Thread(){

                        @Override
                        public void run() {
                            GraGraPopupMenu.this.msg = GraGraPopupMenu.this.gra.getBasisGraGra().convertConstraints();
                            GraGraPopupMenu.this.gra.setChanged(true);
                            d.setVisible(false);
                        }
                    };
                    thread.start();
                    d.setVisible(true);
                    while (thread.isAlive()) {
                    }
                    if (!this.msg.equals("")) {
                        this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this.treeView, 12, "Cannot convert to post application condition.  " + this.msg));
                        JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>Cannot convert to post application condition.<br" + this.msg, "", 0);
                        break;
                    }
                    this.handleRuleConstraints(parent, true, null);
                    this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this.treeView, 12, "Creating post application condition ... done."));
                    break;
                }
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>Cannot convert to post application condition.", "", 0);
                break;
            }
            case 1: {
                if (this.gra.getAtomics().isEmpty()) {
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>Nothing to check!<br>The current grammar doesn't contain any graph constraints.", "", 2);
                    break;
                }
                if (!this.gra.getBasisGraGra().isGraphReadyForTransform()) {
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>The host graph isn't ready.<br>Please check its attributes.", "", 0);
                    break;
                }
                boolean changed = this.gra.isChanged();
                boolean all_good = false;
                TreeViewEvent e = new TreeViewEvent(this.treeView, 13);
                this.treeView.fireTreeViewEvent(e);
                boolean all_valid = this.gra.getBasisGraGra().checkAtomics(true);
                if (all_valid) {
                    all_good = this.gra.getBasisGraGra().checkAtomics(false);
                }
                this.msg = "";
                if (!all_valid) {
                    this.msg = "<html><body>Not all atomic constraints are valid <br>(i.e. atomic morphism : total & injective,<br>attribute value, attribute condition ...).<br>Please check :<br><font color=\"#FF0000\">" + this.gra.getBasisGraGra().getConsistencyErrorMsg() + "</font>" + "</body></html>";
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), this.msg, "", 0);
                } else if (!all_good) {
                    this.msg = "<html><body>All atomics are valid, <br>but the graph doesn't fulfill all of them :<br><font color=\"#FF0000\">" + this.gra.getBasisGraGra().getConsistencyErrorMsg() + "</font>" + "</body></html>";
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), this.msg, "", 0);
                } else {
                    this.msg = "The graph fulfills all atomic graph constraints.";
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), this.msg);
                }
                this.gra.setChanged(changed);
                break;
            }
            case 2: {
                if (this.gra.getAtomics().isEmpty()) {
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><bodyNothing to check!<br>The current grammar doesn't contain any graph constraints.", "", 2);
                    break;
                }
                if (!this.gra.getBasisGraGra().isGraphReadyForTransform()) {
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><bodyThe host graph is not ready!<br>Please check its attributes.", "", 0);
                    break;
                }
                boolean changed = this.gra.isChanged();
                boolean all_good = false;
                TreeViewEvent e = new TreeViewEvent(this.treeView, 13);
                this.treeView.fireTreeViewEvent(e);
                boolean all_valid = this.gra.getBasisGraGra().checkGraphConstraints(true);
                if (all_valid) {
                    all_good = this.gra.getBasisGraGra().checkGraphConstraints(false);
                }
                if (!all_valid) {
                    this.msg = "<html><body>Not all constraints were valid.<br>Please check :<br><font color=\"#FF0000\">" + this.gra.getBasisGraGra().getConsistencyErrorMsg() + "</font>" + "</body></html>";
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), this.msg, "", 0);
                } else if (!all_good) {
                    this.msg = "<html><body>All constraints were valid, <br>but the graph doesn't fulfill all of them :<br><font color=\"#FF0000\">" + this.gra.getBasisGraGra().getConsistencyErrorMsg() + "</font>" + "</body></html>";
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), this.msg, "", 0);
                } else {
                    this.msg = "The graph fulfills all constraints.";
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), this.msg);
                }
                this.gra.setChanged(changed);
            }
        }
        this.path = null;
    }

    private void handleRuleConstraints(DefaultMutableTreeNode node, boolean insert, Object objToCheck) {
        GraGraTreeNodeData sd = (GraGraTreeNodeData)node.getUserObject();
        if (sd.isGraGra()) {
            Enumeration<TreeNode> en = node.children();
            while (en.hasMoreElements()) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)en.nextElement();
                GraGraTreeNodeData csd = (GraGraTreeNodeData)child.getUserObject();
                if (!csd.isRule()) continue;
                if (insert) {
                    this.treeView.addRuleConstraints(child, objToCheck);
                    continue;
                }
                this.treeView.removeRuleConstraints(child, objToCheck);
            }
        } else if (sd.isRule()) {
            if (insert) {
                this.treeView.addRuleConstraints(node, objToCheck);
            } else {
                this.treeView.removeRuleConstraints(node, objToCheck);
            }
        }
    }

    void setLayerOfRules() {
        if (this.gra != null) {
            RuleLayer rl = new RuleLayer(this.gra.getBasisGraGra().getListOfRules());
            GraGraLayerDialog lg = new GraGraLayerDialog(this.treeView.getFrame(), rl);
            Point p = this.treeView.getPopupMenuLocation();
            if (p != null) {
                lg.setLocation(p);
            }
            lg.showGUI();
            if (!lg.isCancelled() && lg.hasChanged()) {
                this.gra.setChanged(true);
                this.gra.getBasisGraGra().oneRuleHasChangedLayer();
                this.gra.getBasisGraGra().refreshConstraintsForLayer();
                if (this.gra.getBasisGraGra().isLayered()) {
                    this.treeView.getTreeModel().ruleNameChanged(this.gra, true);
                    this.treeView.getTreeModel().constraintNameChanged(this.gra, true);
                    this.treeView.getTree().treeDidChange();
                    this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this.treeView, 26, this.path));
                }
            }
        }
    }

    void setLayerOfConstraints() {
        if (this.gra != null) {
            if (!this.gra.getBasisGraGra().getConstraints().hasMoreElements()) {
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "There isn't any graph constraints (formulae) available.");
            } else {
                GraGraConstraintLayerDialog lg = new GraGraConstraintLayerDialog(this.treeView.getFrame(), this.gra.getBasisGraGra().getConstraintsVec(), this.gra.getBasisGraGra().getLayers());
                Point p = this.treeView.getPopupMenuLocation();
                if (p != null) {
                    lg.setLocation(p);
                }
                lg.showGUI();
                if (!lg.isCancelled()) {
                    this.gra.setChanged(true);
                    if (this.gra.getBasisGraGra().isLayered()) {
                        this.treeView.getTreeModel().constraintNameChanged(this.gra, true);
                        this.treeView.getTree().treeDidChange();
                    }
                }
            }
        }
    }

    void setTriggerRuleOfLayer() {
        if (this.gra != null) {
            RuleLayer rl = new RuleLayer(this.gra.getBasisGraGra().getEnabledRules());
            GraGraTriggerRuleOfLayerDialog trlGUI = new GraGraTriggerRuleOfLayerDialog(this.treeView.getFrame(), rl);
            trlGUI.setGraGra(this.gra);
            Point p = this.treeView.getPopupMenuLocation();
            if (p != null) {
                trlGUI.setLocation(p);
            }
            trlGUI.showGUI();
            if (!trlGUI.isCancelled()) {
                this.gra.setChanged(true);
                if (this.gra.getBasisGraGra().isLayered()) {
                    this.treeView.getTreeModel().ruleNameChanged(this.gra, true);
                    this.treeView.getTree().treeDidChange();
                }
            }
        }
    }

    void sortRulesByLayer() {
        EdRule currRule = this.treeView.getCurrentRule();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.treeView.getTreeModel().getRoot();
        if (this.gra != null) {
            DefaultMutableTreeNode ruleNode;
            int row = 0;
            int i = 0;
            while (i < this.treeView.getTree().getRowCount()) {
                TreePath path = this.treeView.getTree().getPathForRow(i);
                DefaultMutableTreeNode inode = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (inode == this.node) {
                    if (this.treeView.getTree().isExpanded(row)) {
                        this.treeView.getTree().collapseRow(i);
                    }
                    row = i;
                    break;
                }
                ++i;
            }
            int indx = this.treeView.getTreeModel().getIndexOfChild(parent, this.node);
            this.node.removeAllChildren();
            this.treeView.getTreeModel().removeNodeFromParent(this.node);
            this.gra.sortRulesByLayer();
            GrammarTreeNodeData sdGra = new GrammarTreeNodeData(this.gra);
            this.node = new DefaultMutableTreeNode(sdGra);
            sdGra.setTreeNode(this.node);
            this.treeView.getTreeModel().insertNodeInto(this.node, parent, indx);
            GrammarTreeNode tmpTreeNode = new GrammarTreeNode();
            tmpTreeNode.updateTreeNodeData(this.treeView, this.node, this.gra);
            this.treeView.getTreeModel().nodeChanged(this.node);
            if (indx == 0) {
                this.treeView.getTree().expandRow(indx);
            }
            this.treeView.getTree().expandRow(row);
            if (currRule != null && (ruleNode = this.treeView.getTreeModel().getTreeNodeOfGraGraRule(this.node, currRule)) != null) {
                int i2 = 0;
                while (i2 < this.treeView.getTree().getRowCount()) {
                    TreePath ipath = this.treeView.getTree().getPathForRow(i2);
                    DefaultMutableTreeNode inode = (DefaultMutableTreeNode)ipath.getLastPathComponent();
                    if (inode.equals(ruleNode)) {
                        this.treeView.getTree().setSelectionPath(ipath);
                    }
                    ++i2;
                }
            }
            if (this.gra.getBasisGraGra().isLayered()) {
                this.treeView.getTreeModel().ruleNameChanged(this.gra, true);
                this.treeView.getTreeModel().constraintNameChanged(this.gra, true);
            }
            this.treeView.getTree().treeDidChange();
        }
    }

    void sortConstraintsByLayer() {
        EdConstraint currConstraint = this.treeView.getCurrentConstraint();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.treeView.getTreeModel().getRoot();
        if (this.gra != null) {
            int row = 0;
            int i = 0;
            while (i < this.treeView.getTree().getRowCount()) {
                TreePath path = this.treeView.getTree().getPathForRow(i);
                DefaultMutableTreeNode inode = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (inode == this.node) {
                    if (this.treeView.getTree().isExpanded(row)) {
                        this.treeView.getTree().collapseRow(i);
                    }
                    row = i;
                    break;
                }
                ++i;
            }
            int indx = this.treeView.getTreeModel().getIndexOfChild(parent, this.node);
            this.node.removeAllChildren();
            this.treeView.getTreeModel().removeNodeFromParent(this.node);
            this.gra.sortConstraintsByLayer();
            GrammarTreeNodeData sdGra = new GrammarTreeNodeData(this.gra);
            this.node = new DefaultMutableTreeNode(sdGra);
            sdGra.setTreeNode(this.node);
            this.treeView.getTreeModel().insertNodeInto(this.node, parent, indx);
            GrammarTreeNode tmpTreeNode = new GrammarTreeNode();
            tmpTreeNode.updateTreeNodeData(this.treeView, this.node, this.gra);
            this.treeView.getTreeModel().nodeChanged(this.node);
            if (indx == 0) {
                this.treeView.getTree().expandRow(indx);
            }
            this.treeView.getTree().expandRow(row);
            DefaultMutableTreeNode constraintNode = this.treeView.getTreeModel().getTreeNodeOfGraGraRule(this.node, currConstraint);
            if (constraintNode != null) {
                int i2 = 0;
                while (i2 < this.treeView.getTree().getRowCount()) {
                    TreePath path = this.treeView.getTree().getPathForRow(i2);
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node.equals(constraintNode)) {
                        this.treeView.getTree().setSelectionPath(path);
                    }
                    ++i2;
                }
            }
            if (this.gra.getBasisGraGra().isLayered()) {
                this.treeView.getTreeModel().ruleNameChanged(this.gra, true);
                this.treeView.getTreeModel().constraintNameChanged(this.gra, true);
            }
            this.treeView.getTree().treeDidChange();
        }
    }

    void disableLayerOfRules() {
        if (this.gra != null) {
            GraGraDisableLayerDialog lg = new GraGraDisableLayerDialog(this.treeView.getFrame(), this.gra.getBasisGraGra().getLayers());
            lg.setGraGra(this.gra);
            Point p = this.treeView.getPopupMenuLocation();
            if (p != null) {
                lg.setLocation(p);
            }
            lg.showGUI();
            if (!lg.isCancelled() && lg.hasChanged()) {
                this.gra.setChanged(true);
                this.gra.getBasisGraGra().oneRuleHasChangedEvailability();
                if (this.gra.getBasisGraGra().isLayered()) {
                    this.treeView.getTreeModel().ruleNameChanged(this.gra, true);
                }
                this.treeView.getTree().treeDidChange();
            }
        }
    }

    void setPriorityOfRules() {
        if (this.gra != null) {
            RulePriority rp = new RulePriority(this.gra.getBasisGraGra().getListOfRules());
            GraGraPriorityDialog pg = new GraGraPriorityDialog(this.treeView.getFrame(), rp);
            Point p = this.treeView.getPopupMenuLocation();
            if (p != null) {
                pg.setLocation(p);
            }
            pg.showGUI();
            if (!pg.isCancelled() && pg.hasChanged()) {
                this.gra.setChanged(true);
                this.gra.getBasisGraGra().oneRuleHasChangedPriority();
                if (this.gra.getBasisGraGra().trafoByPriority()) {
                    this.treeView.getTreeModel().ruleNameChanged(this.gra, false, true);
                    this.treeView.getTree().treeDidChange();
                    this.treeView.fireTreeViewEvent(new TreeViewEvent((Object)this.treeView, 27, this.path));
                }
            }
        }
    }

    void setPriorityOfConstraints() {
        if (this.gra != null) {
            if (!this.gra.getBasisGraGra().getConstraints().hasMoreElements()) {
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "There isn't any graph constraints (formulae) available.");
            } else {
                GraGraConstraintPriorityDialog lg = new GraGraConstraintPriorityDialog(this.treeView.getFrame(), this.gra.getBasisGraGra().getConstraintsVec(), this.gra.getBasisGraGra().getPriorities());
                Point p = this.treeView.getPopupMenuLocation();
                if (p != null) {
                    lg.setLocation(p);
                }
                lg.showGUI();
                if (!lg.isCancelled()) {
                    this.gra.setChanged(true);
                    if (this.gra.getBasisGraGra().trafoByPriority()) {
                        this.treeView.getTreeModel().constraintNameChanged(this.gra, false, true);
                        this.treeView.getTree().treeDidChange();
                    }
                }
            }
        }
    }

    void sortRulesByPriority() {
        EdRule currRule = this.treeView.getCurrentRule();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.treeView.getTreeModel().getRoot();
        if (this.gra != null) {
            DefaultMutableTreeNode ruleNode;
            int row = 0;
            int i = 0;
            while (i < this.treeView.getTree().getRowCount()) {
                TreePath path = this.treeView.getTree().getPathForRow(i);
                DefaultMutableTreeNode inode = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (inode == this.node) {
                    if (this.treeView.getTree().isExpanded(row)) {
                        this.treeView.getTree().collapseRow(i);
                    }
                    row = i;
                    break;
                }
                ++i;
            }
            int indx = this.treeView.getTreeModel().getIndexOfChild(parent, this.node);
            this.node.removeAllChildren();
            this.treeView.getTreeModel().removeNodeFromParent(this.node);
            this.gra.sortRulesByPriority();
            GrammarTreeNodeData sdGra = new GrammarTreeNodeData(this.gra);
            this.node = new DefaultMutableTreeNode(sdGra);
            sdGra.setTreeNode(this.node);
            this.treeView.getTreeModel().insertNodeInto(this.node, parent, indx);
            GrammarTreeNode tmpTreeNode = new GrammarTreeNode();
            tmpTreeNode.updateTreeNodeData(this.treeView, this.node, this.gra);
            this.treeView.getTreeModel().nodeChanged(this.node);
            if (indx == 0) {
                this.treeView.getTree().expandRow(indx);
            }
            this.treeView.getTree().expandRow(row);
            if (currRule != null && (ruleNode = this.treeView.getTreeModel().getTreeNodeOfGraGraRule(this.node, currRule)) != null) {
                int i2 = 0;
                while (i2 < this.treeView.getTree().getRowCount()) {
                    TreePath ipath = this.treeView.getTree().getPathForRow(i2);
                    DefaultMutableTreeNode inode = (DefaultMutableTreeNode)ipath.getLastPathComponent();
                    if (inode.equals(ruleNode)) {
                        this.treeView.getTree().setSelectionPath(ipath);
                    }
                    ++i2;
                }
            }
            if (this.gra.getBasisGraGra().trafoByPriority()) {
                this.treeView.getTreeModel().ruleNameChanged(this.gra, false, true);
            }
            this.treeView.getTree().treeDidChange();
        }
    }

    void sortConstraintsByPriority() {
        EdConstraint currConstraint = this.treeView.getCurrentConstraint();
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)this.treeView.getTreeModel().getRoot();
        if (this.gra != null) {
            int row = 0;
            int i = 0;
            while (i < this.treeView.getTree().getRowCount()) {
                TreePath path = this.treeView.getTree().getPathForRow(i);
                DefaultMutableTreeNode inode = (DefaultMutableTreeNode)path.getLastPathComponent();
                if (inode == this.node) {
                    if (this.treeView.getTree().isExpanded(row)) {
                        this.treeView.getTree().collapseRow(i);
                    }
                    row = i;
                    break;
                }
                ++i;
            }
            int indx = this.treeView.getTreeModel().getIndexOfChild(parent, this.node);
            this.node.removeAllChildren();
            this.treeView.getTreeModel().removeNodeFromParent(this.node);
            this.gra.sortConstraintsByPriority();
            GrammarTreeNodeData sdGra = new GrammarTreeNodeData(this.gra);
            this.node = new DefaultMutableTreeNode(sdGra);
            sdGra.setTreeNode(this.node);
            this.treeView.getTreeModel().insertNodeInto(this.node, parent, indx);
            GrammarTreeNode tmpTreeNode = new GrammarTreeNode();
            tmpTreeNode.updateTreeNodeData(this.treeView, this.node, this.gra);
            this.treeView.getTreeModel().nodeChanged(this.node);
            if (indx == 0) {
                this.treeView.getTree().expandRow(indx);
            }
            this.treeView.getTree().expandRow(row);
            DefaultMutableTreeNode constraintNode = this.treeView.getTreeModel().getTreeNodeOfGraGraRule(this.node, currConstraint);
            if (constraintNode != null) {
                int i2 = 0;
                while (i2 < this.treeView.getTree().getRowCount()) {
                    TreePath path = this.treeView.getTree().getPathForRow(i2);
                    DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
                    if (node.equals(constraintNode)) {
                        this.treeView.getTree().setSelectionPath(path);
                    }
                    ++i2;
                }
            }
            if (this.gra.getBasisGraGra().trafoByPriority()) {
                this.treeView.getTreeModel().ruleNameChanged(this.gra, false, true);
                this.treeView.getTreeModel().constraintNameChanged(this.gra, false, true);
                this.treeView.getTree().treeDidChange();
            }
        }
    }

    void refreshAttrs() {
        if (this.gra != null) {
            this.gra.getTypeSet().refreshAttrInstances();
        }
    }

    void editComments() {
        if (this.gra != null) {
            GraGraTextualComment comments;
            this.treeView.cancelCommentsEdit();
            Point p = this.treeView.getPopupMenuLocation();
            if (p == null) {
                p = new Point(200, 200);
            }
            if ((comments = new GraGraTextualComment(this.treeView.getFrame(), p.x, p.y, this.gra.getBasisGraGra())) != null) {
                comments.setVisible(true);
            }
        }
    }

    void makeParallelRule() {
        if (this.gra != null) {
            int indxOfLastRule = this.node.getIndex(this.treeView.getTreeNodeOfRule(this.data.getGraGra().getRules().lastElement()));
            SelectRulesDialog dialog = new SelectRulesDialog(this.treeView.getFrame(), this.data.getGraGra().getBasisGraGra(), null, new Point(300, 200));
            dialog.setVisible(true);
            if (dialog.getRuleList() != null && !dialog.getRuleList().isEmpty()) {
                if (dialog.rulesContainsRuleScheme()) {
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), "Currently selected rule list contains at least one Rule Scheme.\nBuilding a parallel rule is not available in this case.\nOnly plain rules will be supported. ", "Feature not available", 1);
                    return;
                }
                Rule failedRule = BaseFactory.theFactory().checkApplCondsOfRules(dialog.getRuleList());
                if (failedRule != null) {
                    JOptionPane.showMessageDialog(this.treeView.getFrame(), "Currently selected rule list contains at least one invalid rule.\n" + failedRule.getName() + ":    " + failedRule.getErrorMsg(), "Parallel Rule Failed", 0);
                    return;
                }
                this.makeParallelRuleOfRules(this.data.getGraGra(), dialog.getRuleList(), this.node, indxOfLastRule);
            }
        }
    }

    private void makeParallelRuleOfRules(EdGraGra gra, List<Rule> rules, DefaultMutableTreeNode node, int indxOfLastRule) {
        EdRule parallelRule = gra.makeParallelRuleOfRules(rules, true);
        if (parallelRule != null) {
            if (parallelRule.getBasisRule().isApplicable()) {
                this.treeView.putRuleIntoTree(parallelRule, node, indxOfLastRule + 1);
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>Building a parallel rule was successful.\n\nThe rule:  " + parallelRule.getName() + "\n" + "is added at the end of the rule set.\n\n", "Parallel Rule:  " + parallelRule.getName(), 1);
            } else {
                JOptionPane.showMessageDialog(this.treeView.getFrame(), "Building a parallel rule failed!", "Parallel Rule:  " + parallelRule.getName(), 0);
            }
        } else {
            JOptionPane.showMessageDialog(this.treeView.getFrame(), "<html><body>It was not possible to build a parallel rule.", "Parallel Rule", 0);
        }
    }
}

