/*
 * Decompiled with CFR 0.152.
 */
package agg.gui.treeview.nodedata;

import agg.editor.impl.EdNAC;
import agg.gui.treeview.nodedata.GraGraTreeNodeDataAdapter;
import javax.swing.tree.DefaultMutableTreeNode;

public class NACTreeNodeData
extends GraGraTreeNodeDataAdapter {
    private Object data;
    private EdNAC eNAC;
    private String string = "";
    private DefaultMutableTreeNode treeNode;

    public NACTreeNodeData(EdNAC nac) {
        this.setNAC(nac);
    }

    private void setNAC(EdNAC nac) {
        this.data = nac;
        this.string = !nac.getMorphism().isEnabled() ? "[D]" + nac.getName() : nac.getName();
        this.eNAC = nac;
    }

    public NACTreeNodeData(String s) {
        this.data = s;
        this.string = s;
    }

    public NACTreeNodeData(Object obj) {
        if (obj instanceof EdNAC) {
            this.setNAC((EdNAC)obj);
        } else if (obj instanceof String) {
            new NACTreeNodeData((String)obj);
        }
    }

    @Override
    public void dispose() {
        this.data = null;
        this.eNAC = null;
        this.string = null;
        this.treeNode = null;
    }

    @Override
    public void setData(Object obj) {
        if (obj instanceof EdNAC) {
            this.setNAC((EdNAC)obj);
        } else if (obj instanceof String) {
            this.string = (String)obj;
            this.data = obj;
        } else {
            this.data = null;
            this.eNAC = null;
            this.string = null;
        }
    }

    @Override
    public Object getData() {
        return this.data;
    }

    @Override
    public void setString(String str) {
        String newString;
        if (str == null) {
            return;
        }
        this.string = newString = str.replaceAll(" ", "");
        String newNacName = "";
        String sD = "";
        if (!this.eNAC.getMorphism().isEnabled()) {
            sD = "[D]";
        }
        if (newString.indexOf("[D]") != -1) {
            newString = newString.substring(3, newString.length());
        }
        newNacName = newString;
        if (!this.eNAC.getName().equals(newNacName)) {
            this.eNAC.setName(newNacName);
            this.eNAC.getGraGra().setChanged(true);
        }
        this.string = String.valueOf(sD) + this.eNAC.getBasisGraph().getName();
    }

    @Override
    public void setString(String tag, String newString) {
        if (tag.equals("[]")) {
            tag = "";
        }
        this.string = String.valueOf(tag) + newString;
        if (!this.eNAC.getName().equals(newString)) {
            this.eNAC.setName(newString);
            this.eNAC.getGraGra().setChanged(true);
        }
    }

    @Override
    public String string() {
        return this.string;
    }

    @Override
    public String toString() {
        return this.string();
    }

    @Override
    public EdNAC getNAC() {
        return this.eNAC;
    }

    @Override
    public void setTreeNode(DefaultMutableTreeNode node) {
        this.treeNode = node;
    }

    @Override
    public DefaultMutableTreeNode getTreeNode() {
        return this.treeNode;
    }

    @Override
    public boolean isNAC() {
        return true;
    }

    @Override
    public String getToolTipText() {
        String toolTipText = " Negative application condition ";
        if (!this.eNAC.getMorphism().getTextualComment().equals("")) {
            toolTipText = " " + this.eNAC.getMorphism().getTextualComment();
        }
        return toolTipText;
    }
}

