/*
 * Decompiled with CFR 0.152.
 */
package agg.parser;

import agg.attribute.AttrType;
import agg.attribute.facade.InformationFacade;
import agg.attribute.facade.impl.DefaultInformationFacade;
import agg.attribute.handler.AttrHandler;
import agg.attribute.impl.ValueTuple;
import agg.parser.ExcludePairContainer;
import agg.util.Pair;
import agg.xt_basis.Arc;
import agg.xt_basis.BaseFactory;
import agg.xt_basis.GraGra;
import agg.xt_basis.Graph;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Rule;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import agg.xt_basis.TypeSet;
import agg.xt_basis.agt.RuleScheme;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class ConflictsDependenciesBasisGraph {
    ExcludePairContainer conflictCont;
    ExcludePairContainer dependCont;
    GraGra grammar;
    Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> conflicts;
    Hashtable<Rule, Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>>> dependencies;
    Graph conflictGraph;
    Graph dependGraph;
    Graph combiGraph;
    Hashtable<Node, Rule> node2rule;

    public ConflictsDependenciesBasisGraph(ExcludePairContainer conflictsContainer, ExcludePairContainer dependenciesContainer) {
        this.conflictCont = conflictsContainer;
        this.dependCont = dependenciesContainer;
        this.initTables();
        this.createGraphs();
        if (this.combiGraph != null) {
            this.optimizeLayout(this.combiGraph);
        } else if (this.conflictGraph != null) {
            this.optimizeLayout(this.conflictGraph);
        } else if (this.dependGraph != null) {
            this.optimizeLayout(this.dependGraph);
        }
    }

    public ConflictsDependenciesBasisGraph(ExcludePairContainer conflictsContainer, ExcludePairContainer dependenciesContainer, Graph combiCPAgraph) {
        this.conflictCont = conflictsContainer;
        this.dependCont = dependenciesContainer;
        this.initTables();
        if (combiCPAgraph != null && !combiCPAgraph.isEmpty()) {
            this.combiGraph = combiCPAgraph;
            this.createGraphs(this.combiGraph);
        } else {
            this.createGraphs();
        }
        if (this.combiGraph != null) {
            this.optimizeLayout(this.combiGraph);
        } else if (this.conflictGraph != null) {
            this.optimizeLayout(this.conflictGraph);
        } else if (this.dependGraph != null) {
            this.optimizeLayout(this.dependGraph);
        }
    }

    public Graph getConflictsGraph() {
        return this.conflictGraph;
    }

    public Graph getDependenciesGraph() {
        return this.dependGraph;
    }

    public Graph getConflictsDependenciesGraph() {
        return this.combiGraph;
    }

    private void collapseRuleSchemes(Graph g) {
        if (g != null) {
            this.collapseRuleSchemes(g, "c");
            this.collapseRuleSchemes(g, "d");
        }
    }

    public void collapseRuleSchemes(Graph g, String tname) {
        if (this.node2rule == null) {
            return;
        }
        Hashtable map = new Hashtable();
        for (Node n : g.getNodesSet()) {
            Rule r = this.node2rule.get(n);
            if (r == null || r.getRuleScheme() == null) continue;
            Vector<Node> l = (Vector<Node>)map.get(r.getRuleScheme());
            if (l == null) {
                l = new Vector<Node>(5);
                map.put(r.getRuleScheme(), l);
            }
            if (l.contains(n)) continue;
            l.add(n);
        }
        Type nt = g.getTypeSet().getTypeByName("RuleScheme");
        if (nt == null) {
            nt = g.getTypeSet().createNodeType(true);
            nt.setStringRepr("RuleScheme");
            nt.setAdditionalRepr("[NODE]");
            nt.getAttrType().addMember(DefaultInformationFacade.self().getJavaHandler(), "String", "name");
        }
        Vector<Arc> ll = new Vector<Arc>();
        for (RuleScheme rs : map.keySet()) {
            List l = (List)map.get(rs);
            try {
                Node rsn = g.createNode(nt);
                Iterator vt = (ValueTuple)rsn.getAttribute();
                ((ValueTuple)((Object)vt)).getValueMemberAt("name").setExprAsObject(rs.getName());
                Iterator iterator = l.iterator();
                while (iterator.hasNext()) {
                    Node n = (Node)iterator.next();
                    for (Arc a : n.getIncomingArcsSet()) {
                        if (!ll.contains(a)) {
                            ll.add(a);
                        }
                        if (!a.getType().getName().equals(tname)) continue;
                        if (!a.isDirected()) {
                            if (g.getArcs(a.getSource(), rsn) == null) {
                                g.createArc(a.getType(), (Node)a.getSource(), rsn);
                            }
                            if (g.getArcs(rsn, a.getSource()) != null) continue;
                            g.createArc(a.getType(), rsn, (Node)a.getSource());
                            continue;
                        }
                        if (!a.isVisible() || !a.isDirected() || g.getArcs(a.getSource(), rsn) != null) continue;
                        g.createArc(a.getType(), (Node)a.getSource(), rsn);
                    }
                    for (Arc a : n.getOutgoingArcsSet()) {
                        if (a.isLoop()) continue;
                        if (!ll.contains(a)) {
                            ll.add(a);
                        }
                        if (!a.getType().getName().equals(tname)) continue;
                        if (!a.isDirected()) {
                            if (g.getArcs(rsn, a.getTarget()) == null) {
                                g.createArc(a.getType(), rsn, (Node)a.getTarget());
                            }
                            if (g.getArcs(a.getTarget(), rsn) != null) continue;
                            g.createArc(a.getType(), (Node)a.getTarget(), rsn);
                            continue;
                        }
                        if (!a.isVisible() || !a.isDirected() || g.getArcs(rsn, a.getTarget()) != null) continue;
                        g.createArc(a.getType(), rsn, (Node)a.getTarget());
                    }
                }
            }
            catch (TypeException rsn) {
                // empty catch block
            }
        }
        for (Arc a : ll) {
            try {
                g.destroyArc(a, false);
            }
            catch (TypeException rsn) {
                // empty catch block
            }
        }
        ll.clear();
        Vector<Arc> la = new Vector<Arc>();
        Vector<Arc> arcs = new Vector<Arc>(g.getArcsSet());
        for (Arc a : arcs) {
            if (!a.getType().getName().equals(tname)) {
                if (la.contains(a)) continue;
                la.add(a);
                continue;
            }
            if (!a.isVisible() && !la.contains(a)) {
                la.add(a);
            }
            if (a.isDirected()) continue;
            try {
                g.createArc(a.getType(), (Node)a.getSource(), (Node)a.getTarget());
                g.createArc(a.getType(), (Node)a.getTarget(), (Node)a.getSource());
                if (la.contains(a)) continue;
                la.add(a);
            }
            catch (TypeException n) {
                // empty catch block
            }
        }
        for (Arc a : la) {
            try {
                g.destroyArc(a, false);
            }
            catch (TypeException n) {
                // empty catch block
            }
        }
        la.clear();
        for (List l : map.values()) {
            for (Node n : l) {
                try {
                    g.destroyNode(n, false);
                }
                catch (TypeException typeException) {
                    // empty catch block
                }
            }
        }
    }

    private void initTables() {
        if (this.conflictCont != null) {
            this.conflicts = this.conflictCont.getExcludeContainer();
            this.grammar = this.conflictCont.getGrammar();
        }
        if (this.dependCont != null) {
            this.dependencies = this.dependCont.getExcludeContainer();
            if (this.grammar == null) {
                this.grammar = this.dependCont.getGrammar();
            }
        }
    }

    private void createGraphs() {
        if (this.conflicts == null && this.dependencies == null) {
            return;
        }
        Hashtable<String, Node> common = new Hashtable<String, Node>();
        Hashtable<String, Node> local = new Hashtable<String, Node>();
        this.node2rule = new Hashtable();
        TypeSet types = null;
        if (this.conflicts != null) {
            this.conflictGraph = BaseFactory.theFactory().createGraph();
            this.conflictGraph.setName("Conflicts of Rules");
            types = this.conflictGraph.getTypeSet();
        }
        if (this.dependencies != null) {
            if (types != null) {
                this.dependGraph = BaseFactory.theFactory().createGraph(types);
            } else {
                this.dependGraph = BaseFactory.theFactory().createGraph();
                types = this.dependGraph.getTypeSet();
            }
            this.dependGraph.setName("Dependencies of Rules");
        }
        if (this.conflictGraph != null && this.dependGraph != null) {
            this.combiGraph = BaseFactory.theFactory().createGraph(types);
            this.combiGraph.setName("CPA Graph: Conflicts (red) - Dependencies (blue) of Rules");
        }
        if (types != null) {
            boolean rel;
            Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>> p;
            Node nr;
            Node nr2;
            Node nr3;
            Node nr1;
            ExcludePairContainer.Entry entry;
            Rule r2;
            Enumeration<Rule> keys2;
            Hashtable<Rule, Pair<Boolean, Vector<Pair<Pair<OrdinaryMorphism, OrdinaryMorphism>, Pair<OrdinaryMorphism, OrdinaryMorphism>>>>> table;
            Rule r1;
            Enumeration<Rule> keys1;
            Type nodeType = types.createNodeType(true);
            Type arcTypeConflict = types.createArcType(false);
            Type arcTypeDepend = types.createArcType(false);
            nodeType.setStringRepr("Rule");
            nodeType.setAdditionalRepr("[NODE]");
            arcTypeConflict.setStringRepr("c");
            arcTypeConflict.setAdditionalRepr(":SOLID_LINE:java.awt.Color[r=255,g=0,b=0]::[EDGE]:");
            arcTypeDepend.setStringRepr("d");
            arcTypeDepend.setAdditionalRepr(":DOT_LINE:java.awt.Color[r=0,g=0,b=255]::[EDGE]:");
            InformationFacade info = DefaultInformationFacade.self();
            AttrHandler javaHandler = info.getJavaHandler();
            AttrType attrType = nodeType.getAttrType();
            attrType.addMember(javaHandler, "String", "name");
            if (this.conflicts != null) {
                keys1 = this.conflicts.keys();
                while (keys1.hasMoreElements()) {
                    r1 = keys1.nextElement();
                    if (!r1.isEnabled()) continue;
                    table = this.conflicts.get(r1);
                    keys2 = table.keys();
                    while (keys2.hasMoreElements()) {
                        r2 = keys2.nextElement();
                        if (!r2.isEnabled()) continue;
                        entry = this.conflictCont.getEntry(r1, r2);
                        nr1 = (Node)local.get(r1.getQualifiedName());
                        if (nr1 == null) {
                            nr1 = this.createNode(this.conflictGraph, nodeType, r1);
                            local.put(r1.getQualifiedName(), nr1);
                            this.node2rule.put(nr1, r1);
                            if (r1 == r2) {
                                nr1.setVisible(entry.isRuleVisible());
                            }
                        }
                        if (this.combiGraph != null && (nr3 = (Node)common.get(r1.getQualifiedName())) == null) {
                            nr3 = this.createNode(this.combiGraph, nodeType, r1);
                            common.put(r1.getQualifiedName(), nr3);
                            this.node2rule.put(nr3, r1);
                            if (r1 == r2) {
                                nr3.setVisible(entry.isRuleVisible());
                            }
                        }
                        if ((nr2 = (Node)local.get(r2.getQualifiedName())) == null) {
                            nr2 = this.createNode(this.conflictGraph, nodeType, r2);
                            local.put(r2.getQualifiedName(), nr2);
                            this.node2rule.put(nr2, r2);
                        }
                        if (this.combiGraph != null && (nr = (Node)common.get(r2.getQualifiedName())) == null) {
                            nr = this.createNode(this.combiGraph, nodeType, r2);
                            common.put(r2.getQualifiedName(), nr);
                            this.node2rule.put(nr, r2);
                        }
                        p = table.get(r2);
                        rel = (Boolean)p.first;
                        if (!rel) continue;
                        this.createEdge(this.conflictGraph, arcTypeConflict, nr1, nr2);
                        if (this.combiGraph == null) continue;
                        this.createEdge(this.combiGraph, arcTypeConflict, (Node)common.get(r1.getQualifiedName()), (Node)common.get(r2.getQualifiedName()));
                    }
                }
            }
            if (this.dependencies != null) {
                local.clear();
                keys1 = this.dependencies.keys();
                while (keys1.hasMoreElements()) {
                    r1 = keys1.nextElement();
                    if (!r1.isEnabled()) continue;
                    table = this.dependencies.get(r1);
                    keys2 = table.keys();
                    while (keys2.hasMoreElements()) {
                        r2 = keys2.nextElement();
                        if (!r2.isEnabled()) continue;
                        entry = this.dependCont.getEntry(r1, r2);
                        nr1 = (Node)local.get(r1.getQualifiedName());
                        if (nr1 == null) {
                            nr1 = this.createNode(this.dependGraph, nodeType, r1);
                            local.put(r1.getQualifiedName(), nr1);
                            this.node2rule.put(nr1, r1);
                            if (r1 == r2) {
                                nr1.setVisible(entry.isRuleVisible());
                            }
                        }
                        if (this.combiGraph != null && (nr3 = (Node)common.get(r1.getQualifiedName())) == null) {
                            nr3 = this.createNode(this.combiGraph, nodeType, r1);
                            common.put(r1.getQualifiedName(), nr3);
                            this.node2rule.put(nr3, r1);
                            if (r1 == r2) {
                                nr3.setVisible(entry.isRuleVisible());
                            }
                        }
                        if ((nr2 = (Node)local.get(r2.getQualifiedName())) == null) {
                            nr2 = this.createNode(this.dependGraph, nodeType, r2);
                            local.put(r2.getQualifiedName(), nr2);
                            this.node2rule.put(nr2, r2);
                        }
                        if (this.combiGraph != null && (nr = (Node)common.get(r2.getQualifiedName())) == null) {
                            nr = this.createNode(this.combiGraph, nodeType, r2);
                            common.put(r2.getQualifiedName(), nr);
                            this.node2rule.put(nr, r2);
                        }
                        p = table.get(r2);
                        rel = (Boolean)p.first;
                        if (!rel) continue;
                        this.createEdge(this.dependGraph, arcTypeDepend, nr1, nr2);
                        if (this.combiGraph == null) continue;
                        this.createEdge(this.combiGraph, arcTypeDepend, (Node)common.get(r1.getQualifiedName()), (Node)common.get(r2.getQualifiedName()));
                    }
                }
            }
            common.clear();
            common = null;
            local.clear();
            local = null;
        }
    }

    private void createGraphs(Graph combiCPAGraph) {
        Rule r;
        String name;
        Vector<Arc> list;
        if (this.conflicts == null && this.dependencies == null) {
            return;
        }
        List<Rule> rlist = this.grammar.getRulesWithIntegratedRulesOfRuleScheme();
        Hashtable<String, Rule> name2rule = new Hashtable<String, Rule>();
        for (Rule r2 : rlist) {
            name2rule.put(r2.getQualifiedName(), r2);
        }
        this.node2rule = new Hashtable();
        TypeSet types = combiCPAGraph.getTypeSet();
        Type arcTypeConflict = types.getTypeByName("c");
        Type arcTypeDepend = types.getTypeByName("d");
        if (this.conflicts != null) {
            this.conflictGraph = combiCPAGraph.copy();
            this.conflictGraph.setName("Conflicts of Rules");
            list = this.conflictGraph.getArcs(arcTypeDepend);
            if (list != null) {
                for (Arc a : list) {
                    try {
                        this.conflictGraph.destroyArc(a);
                    }
                    catch (TypeException typeException) {
                        // empty catch block
                    }
                }
            }
        }
        if (this.dependencies != null) {
            this.dependGraph = combiCPAGraph.copy();
            this.dependGraph.setName("Dependencies of Rules");
            list = this.dependGraph.getArcs(arcTypeConflict);
            if (list != null) {
                for (Arc a : list) {
                    try {
                        this.dependGraph.destroyArc(a);
                    }
                    catch (TypeException typeException) {
                        // empty catch block
                    }
                }
            }
        }
        for (Node n : this.dependGraph.getNodesSet()) {
            name = n.getAttribute().getValueAsString(0).replace("\"", "");
            r = (Rule)name2rule.get(name);
            if (r == null) continue;
            this.node2rule.put(n, r);
        }
        for (Node n : this.conflictGraph.getNodesSet()) {
            name = n.getAttribute().getValueAsString(0).replace("\"", "");
            r = (Rule)name2rule.get(name);
            if (r == null) continue;
            this.node2rule.put(n, r);
        }
    }

    private void optimizeLayout(Graph g) {
        block0: for (Arc a : g.getArcsSet()) {
            if (a.getSource() == a.getTarget() || !a.isDirected()) continue;
            for (Arc a1 : g.getArcsSet()) {
                if (a1.getSource() == a1.getTarget() || !a1.isDirected() || a == a1 || !a.getType().getName().equals(a1.getType().getName()) || a.getSource() != a1.getTarget() || a.getTarget() != a1.getSource()) continue;
                a.setVisible(false);
                a1.setDirected(false);
                continue block0;
            }
        }
    }

    private Node createNode(Graph g, Type t, Rule r) {
        Node n = this.getNode(g, r);
        if (n == null) {
            try {
                n = g.createNode(t);
                ValueTuple vt = (ValueTuple)n.getAttribute();
                String rname = r.getQualifiedName();
                vt.getValueMemberAt("name").setExprAsObject(rname);
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        return n;
    }

    private Node getNode(Graph g, Rule r) {
        for (Node n : g.getNodesSet()) {
            if (!((String)n.getAttribute().getValueAt("name")).equals(r.getQualifiedName())) continue;
            return n;
        }
        return null;
    }

    private Arc createEdge(Graph g, Type t, Node n1, Node n2) {
        if (t == null || n1 == null || n2 == null) {
            return null;
        }
        Arc a = this.getEdge(g, t, n1, n2);
        if (a == null) {
            try {
                Arc a1;
                a = g.createArc(t, n1, n2);
                if (n1 != n2 && (a1 = this.getEdge(g, t, n2, n1)) != null) {
                    a.setDirected(false);
                    a1.setVisible(false);
                }
            }
            catch (TypeException typeException) {
                // empty catch block
            }
        }
        return a;
    }

    private Arc createEdge(Graph g, Type t, Rule r1, Rule r2) {
        if (t == null || r1 == null || r2 == null) {
            return null;
        }
        Node n1 = this.getNode(g, r1);
        Node n2 = this.getNode(g, r2);
        return this.createEdge(g, t, n1, n2);
    }

    private Arc getEdge(Graph g, Type t, Node n1, Node n2) {
        if (t == null || n1 == null || n2 == null) {
            return null;
        }
        for (Arc a : g.getArcsSet()) {
            if (!a.getType().getName().equals(t.getName())) continue;
            Object src = a.getSource().getAttribute().getValueAt("name");
            Object tar = a.getTarget().getAttribute().getValueAt("name");
            Object name1 = n1.getAttribute().getValueAt("name");
            Object name2 = n2.getAttribute().getValueAt("name");
            if (src == null || !((String)src).equals(name1) || tar == null || !((String)tar).equals(name2)) continue;
            return a;
        }
        return null;
    }
}

