/*
 * Decompiled with CFR 0.152.
 */
package agg.xt_basis;

import agg.attribute.impl.ContextView;
import agg.attribute.impl.TupleMapping;
import agg.attribute.impl.ValueTuple;
import agg.xt_basis.Arc;
import agg.xt_basis.BadMappingException;
import agg.xt_basis.Graph;
import agg.xt_basis.GraphObject;
import agg.xt_basis.Morphism;
import agg.xt_basis.Node;
import agg.xt_basis.OrdinaryMorphism;
import agg.xt_basis.Type;
import agg.xt_basis.TypeException;
import agg.xt_basis.colim.ALPHA_DIAGRAM;
import agg.xt_basis.colim.COLIM_DEFS;
import agg.xt_basis.colim.COLIM_VECTOR;
import agg.xt_basis.colim.INT_VECTOR;
import agg.xt_basis.colim.SET_DIAGRAM;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;

public class ColimDiagram
implements COLIM_DEFS {
    private Graph itsColimGraph;
    private Dictionary<Graph, Integer> itsGraphIndexMap;
    private ALPHA_DIAGRAM itsDiagram;
    private Vector<OrdinaryMorphism> itsColimMorphisms;
    private boolean itsInplaceFlag;
    private boolean adoptEntriesWhereEmpty = false;
    private final Vector<GraphObject> createdNodes = new Vector();

    public ColimDiagram(Graph result) {
        this.itsDiagram = new ALPHA_DIAGRAM();
        this.itsColimGraph = result;
        this.itsColimMorphisms = new Vector();
        this.itsGraphIndexMap = new Hashtable<Graph, Integer>(8);
        this.itsInplaceFlag = false;
    }

    public void addNode(Graph graph) {
        COLIM_VECTOR allObjects = new COLIM_VECTOR(32);
        COLIM_VECTOR allObjectsRefs = new COLIM_VECTOR(32);
        COLIM_VECTOR allObjectsAttrs = new COLIM_VECTOR(32);
        Hashtable<GraphObject, Integer> anIndexMap = new Hashtable<GraphObject, Integer>(32);
        if (graph == this.itsColimGraph) {
            this.itsInplaceFlag = true;
        }
        this.fillObjects(allObjects, allObjectsRefs, allObjectsAttrs, anIndexMap, graph.getNodesSet().iterator());
        this.fillObjects(allObjects, allObjectsRefs, allObjectsAttrs, anIndexMap, graph.getArcsSet().iterator());
        allObjects.trimToSize();
        allObjectsRefs.trimToSize();
        allObjectsAttrs.trimToSize();
        int i = this.itsDiagram.insert_object(allObjects, allObjectsRefs, allObjectsAttrs, graph.getName());
        this.itsGraphIndexMap.put(graph, new Integer(i));
    }

    private void fillObjects(COLIM_VECTOR allObjects, COLIM_VECTOR allObjectsRefs, COLIM_VECTOR allObjectsAttrs, Dictionary<GraphObject, Integer> anIndexMap, Iterator<?> anObjectIter) {
        int count;
        int i = count = allObjects.size();
        while (anObjectIter.hasNext()) {
            GraphObject anObject = (GraphObject)anObjectIter.next();
            allObjects.push_back(anObject);
            anIndexMap.put(anObject, new Integer(i));
            INT_VECTOR anObjectsRefs = new INT_VECTOR(2);
            if (anObject.isNode()) {
                anObjectsRefs.push_back(i);
                anObjectsRefs.push_back(i);
                anObjectsRefs.trimToSize();
            } else {
                anObjectsRefs.push_back(anIndexMap.get(((Arc)anObject).getSource()));
                anObjectsRefs.push_back(anIndexMap.get(((Arc)anObject).getTarget()));
                anObjectsRefs.trimToSize();
            }
            allObjectsRefs.push_back(anObjectsRefs);
            COLIM_VECTOR anObjectsAttrs = new COLIM_VECTOR(1);
            anObjectsAttrs.push_back(anObject.getType());
            anObjectsAttrs.trimToSize();
            allObjectsAttrs.push_back(anObjectsAttrs);
            ++i;
        }
    }

    public void addEdge(Morphism morph) {
        Graph aSourceGraph = morph.getOriginal();
        Graph aTargetGraph = morph.getImage();
        GraphObject anObject = null;
        Hashtable<GraphObject, Integer> aTargetIndexMap = new Hashtable<GraphObject, Integer>(32);
        int count = 0;
        Iterator<GraphObject> anObjectIter = aTargetGraph.getNodesSet().iterator();
        int i = count;
        while (anObjectIter.hasNext()) {
            ((Dictionary)aTargetIndexMap).put(anObjectIter.next(), new Integer(i));
            ++i;
        }
        count = ((Dictionary)aTargetIndexMap).size();
        anObjectIter = aTargetGraph.getArcsSet().iterator();
        i = count;
        while (anObjectIter.hasNext()) {
            ((Dictionary)aTargetIndexMap).put(anObjectIter.next(), new Integer(i));
            ++i;
        }
        INT_VECTOR aMorphism = new INT_VECTOR(64);
        anObjectIter = aSourceGraph.getNodesSet().iterator();
        while (anObjectIter.hasNext()) {
            anObject = morph.getImage(anObjectIter.next());
            if (anObject != null) {
                if (((Dictionary)aTargetIndexMap).get(anObject) != null) {
                    aMorphism.push_back((Integer)((Dictionary)aTargetIndexMap).get(anObject));
                    continue;
                }
                aMorphism.push_back(-1);
                continue;
            }
            aMorphism.push_back(-1);
        }
        anObjectIter = aSourceGraph.getArcsSet().iterator();
        while (anObjectIter.hasNext()) {
            anObject = morph.getImage(anObjectIter.next());
            if (anObject != null) {
                if (((Dictionary)aTargetIndexMap).get(anObject) != null) {
                    aMorphism.push_back((Integer)((Dictionary)aTargetIndexMap).get(anObject));
                    continue;
                }
                aMorphism.push_back(-1);
                continue;
            }
            aMorphism.push_back(-1);
        }
        this.itsDiagram.insert_morphism(aMorphism, this.itsGraphIndexMap.get(aSourceGraph), this.itsGraphIndexMap.get(aTargetGraph));
    }

    public final void computeColimit() throws TypeException {
        this.adoptEntriesWhereEmpty = false;
        COLIM_VECTOR items = this.itsDiagram.get_colimit_items_total();
        COLIM_VECTOR refs = this.itsDiagram.get_colimit_refs_total();
        COLIM_VECTOR attrs = this.itsDiagram.get_colimit_attrs_total();
        this.convertColimit(items, refs, attrs);
    }

    public final void computeColimit(boolean adoptEntries) throws TypeException {
        this.adoptEntriesWhereEmpty = adoptEntries;
        COLIM_VECTOR items = this.itsDiagram.get_colimit_items_total();
        COLIM_VECTOR refs = this.itsDiagram.get_colimit_refs_total();
        COLIM_VECTOR attrs = this.itsDiagram.get_colimit_attrs_total();
        this.convertColimit(items, refs, attrs);
    }

    public final void requestEdge(OrdinaryMorphism morph) {
        Graph aTargetGraph = morph.getImage();
        if (aTargetGraph == this.itsColimGraph) {
            this.itsColimMorphisms.add(morph);
        }
    }

    private final void convertColimit(COLIM_VECTOR items, COLIM_VECTOR refs, COLIM_VECTOR attrs) throws TypeException {
        Vector allOrigs;
        SET_DIAGRAM anItemDiagram = this.itsDiagram.get_item_diagram();
        Vector allColimItems = null;
        if (this.itsInplaceFlag) {
            boolean anObjectLeftToCreate;
            allOrigs = new Vector(items.size());
            int i = 0;
            while (i < items.size()) {
                allOrigs.addElement(new Vector(2));
                ++i;
            }
            int aColimGraphIndex = this.itsGraphIndexMap.get(this.itsColimGraph);
            int aFirstIndex = anItemDiagram.set_at_node((int)aColimGraphIndex).lower;
            int aLastIndex = anItemDiagram.set_at_node((int)aColimGraphIndex).upper;
            Vector<Node> nodestodestroy = new Vector<Node>();
            int anObjIndex = aFirstIndex;
            while (anObjIndex <= aLastIndex) {
                GraphObject anOrigObj = (GraphObject)anItemDiagram.get_element(anObjIndex);
                int anImgIndex = anItemDiagram.get_colimit_pos(anObjIndex);
                if (anImgIndex == -1) {
                    if (anOrigObj.isNode()) {
                        nodestodestroy.add((Node)anOrigObj);
                    } else {
                        this.itsColimGraph.destroyArc((Arc)anOrigObj, false, false);
                    }
                } else {
                    ((Vector)allOrigs.elementAt(anImgIndex)).addElement(anOrigObj);
                }
                ++anObjIndex;
            }
            int d = 0;
            while (d < nodestodestroy.size()) {
                this.itsColimGraph.destroyNode((Node)nodestodestroy.get(d), false, false);
                ++d;
            }
            do {
                anObjectLeftToCreate = false;
                int i2 = 0;
                while (i2 < items.size()) {
                    Vector aCurOrigs = (Vector)allOrigs.elementAt(i2);
                    switch (aCurOrigs.size()) {
                        case 0: {
                            INT_VECTOR anObjectsRefs = (INT_VECTOR)refs.item(i2);
                            Vector aSrcOrigs = (Vector)allOrigs.elementAt(anObjectsRefs.item(0));
                            Vector aTarOrigs = (Vector)allOrigs.elementAt(anObjectsRefs.item(1));
                            GraphObject gobj = (GraphObject)items.item(i2);
                            Type aType = gobj.getType();
                            if (gobj.getContext().getTypeSet() != this.itsColimGraph.getTypeSet()) {
                                aType = this.itsColimGraph.getTypeSet().getSimilarType(gobj.getType());
                            }
                            if (gobj.isNode()) {
                                Node n = this.itsColimGraph.createNode(aType);
                                n.setContextUsage(gobj.getContextUsage());
                                ((Vector)allOrigs.elementAt(i2)).addElement(n);
                                this.createdNodes.add(n);
                                break;
                            }
                            if (aSrcOrigs.size() > 0 && aTarOrigs.size() > 0) {
                                Arc a = this.itsColimGraph.createArc(aType, (Node)aSrcOrigs.firstElement(), (Node)aTarOrigs.firstElement());
                                ((Vector)allOrigs.elementAt(i2)).addElement(a);
                                break;
                            }
                            anObjectLeftToCreate = true;
                            break;
                        }
                        case 1: {
                            break;
                        }
                        default: {
                            int j = 1;
                            while (j < aCurOrigs.size()) {
                                this.itsColimGraph.glue((GraphObject)aCurOrigs.get(0), (GraphObject)aCurOrigs.get(j));
                                ++j;
                            }
                            break block2;
                        }
                    }
                    ++i2;
                }
            } while (anObjectLeftToCreate);
        } else {
            System.out.println("agg.xt_basis.ColimDiagram:  Sorry, only inplace computation is supported yet");
            return;
        }
        allColimItems = allOrigs;
        Enumeration<OrdinaryMorphism> aMorphIter = this.itsColimMorphisms.elements();
        while (aMorphIter.hasMoreElements()) {
            OrdinaryMorphism aColimMorph = aMorphIter.nextElement();
            int aSrcGraph = this.itsGraphIndexMap.get(aColimMorph.getOriginal());
            int anObjIndex = anItemDiagram.set_at_node((int)aSrcGraph).lower;
            while (anObjIndex <= anItemDiagram.set_at_node((int)aSrcGraph).upper) {
                int aTarPos = anItemDiagram.get_colimit_pos(anObjIndex);
                if (aTarPos != -1) {
                    GraphObject aSrc = (GraphObject)anItemDiagram.get_element(anObjIndex);
                    GraphObject aTar = (GraphObject)((Vector)allColimItems.elementAt(aTarPos)).firstElement();
                    try {
                        aColimMorph.addMapping(aSrc, aTar);
                    }
                    catch (BadMappingException ex) {
                        return;
                    }
                    if (this.adoptEntriesWhereEmpty) {
                        this.adoptEntriesWhereEmpty(aColimMorph, aSrc, aTar);
                    }
                }
                ++anObjIndex;
            }
        }
    }

    private void adoptEntriesWhereEmpty(OrdinaryMorphism morph, GraphObject from, GraphObject to) {
        ContextView context;
        Vector<TupleMapping> mappings;
        if (!morph.getImage().isAttributed() || from.getAttribute() == null || to.getAttribute() == null) {
            return;
        }
        if (morph.getImage(from) != null && (mappings = (context = (ContextView)morph.getAttrContext()).getMappingsToTarget((ValueTuple)to.getAttribute())) != null) {
            mappings.elementAt(0).adoptEntriesWhereEmpty((ValueTuple)from.getAttribute(), (ValueTuple)to.getAttribute());
        }
    }

    public Vector<GraphObject> getCreatedNodes() {
        return this.createdNodes;
    }
}

