/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.provider;

import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.util.ResourceLocator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.AdapterFactoryItemDelegator;
import org.eclipse.emf.edit.provider.ComposeableAdapterFactory;
import org.eclipse.emf.edit.provider.IEditingDomainItemProvider;
import org.eclipse.emf.edit.provider.IItemColorProvider;
import org.eclipse.emf.edit.provider.IItemLabelProvider;
import org.eclipse.emf.edit.provider.IItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.IItemPropertySource;
import org.eclipse.emf.edit.provider.IStructuredItemContentProvider;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ItemPropertyDescriptor;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.henshin.model.Annotation;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.HenshinPackage;
import org.eclipse.emf.henshin.model.ModelElement;
import org.eclipse.emf.henshin.provider.HenshinEditPlugin;
import org.eclipse.emf.henshin.provider.HenshinItemProviderAdapter;
import org.eclipse.emf.henshin.provider.descriptors.AnnotationPropertyDescriptor;

public class ModelElementItemProvider
extends HenshinItemProviderAdapter
implements IEditingDomainItemProvider,
IStructuredItemContentProvider,
ITreeItemContentProvider,
IItemLabelProvider,
IItemPropertySource,
IItemColorProvider {
    AdapterFactoryItemDelegator itemDelegator;

    public ModelElementItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
        this.itemDelegator = new AdapterFactoryItemDelegator((AdapterFactory)((ComposeableAdapterFactory)adapterFactory).getRootAdapterFactory());
    }

    public List<IItemPropertyDescriptor> getPropertyDescriptors(Object object) {
        if (this.itemPropertyDescriptors == null) {
            super.getPropertyDescriptors(object);
        }
        if (object instanceof ModelElement) {
            ModelElement modelElement = (ModelElement)object;
            for (Annotation annotation : modelElement.getAnnotations()) {
                this.itemPropertyDescriptors.add(new AnnotationPropertyDescriptor((AdapterFactory)((ComposeableAdapterFactory)this.adapterFactory).getRootAdapterFactory(), this.getResourceLocator(), this.toPropertyLabel(annotation.getKey()), String.valueOf(annotation.getKey()) + " Annotation value", (EStructuralFeature)HenshinPackage.Literals.ANNOTATION__VALUE, true, false, false, ItemPropertyDescriptor.GENERIC_VALUE_IMAGE, null, null, annotation.getKey()));
            }
        }
        return this.itemPropertyDescriptors;
    }

    private String toPropertyLabel(String annotationKey) {
        if (annotationKey == null || annotationKey.isEmpty()) {
            return annotationKey;
        }
        String result = annotationKey.replaceAll("([a-z]+)([A-Z]+)", "$1_$2").replace('_', ' ');
        result = String.valueOf(result.substring(0, 1).toUpperCase()) + result.substring(1);
        return result;
    }

    public Collection<? extends EStructuralFeature> getChildrenFeatures(Object object) {
        if (this.childrenFeatures == null) {
            super.getChildrenFeatures(object);
            this.childrenFeatures.add(HenshinPackage.Literals.MODEL_ELEMENT__ANNOTATIONS);
        }
        return this.childrenFeatures;
    }

    protected EStructuralFeature getChildFeature(Object object, Object child) {
        return super.getChildFeature(object, child);
    }

    public String getText(Object object) {
        return this.getString("_UI_ModelElement_type");
    }

    public void notifyChanged(Notification notification) {
        this.updateChildren(notification);
        switch (notification.getFeatureID(ModelElement.class)) {
            case 0: {
                this.fireNotifyChanged((Notification)new ViewerNotification(notification, notification.getNotifier(), true, false));
                return;
            }
        }
        super.notifyChanged(notification);
    }

    protected void collectNewChildDescriptors(Collection<Object> newChildDescriptors, Object object) {
        super.collectNewChildDescriptors(newChildDescriptors, object);
        newChildDescriptors.add(this.createChildParameter(HenshinPackage.Literals.MODEL_ELEMENT__ANNOTATIONS, HenshinFactory.eINSTANCE.createAnnotation()));
    }

    public ResourceLocator getResourceLocator() {
        return HenshinEditPlugin.INSTANCE;
    }
}

