/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.editor.commands;

import java.util.Collection;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.henshin.model.ConditionalUnit;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.IndependentUnit;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.Parameter;
import org.eclipse.emf.henshin.model.ParameterMapping;
import org.eclipse.emf.henshin.model.PriorityUnit;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.Unit;

public class ChangeUnitTypeCommand
extends AbstractCommand {
    protected Unit unit;
    protected Unit newUnit;
    protected int oldUnitType;
    protected int newUnitType;
    protected Collection<?> affectedObjects;
    protected Module module;

    public ChangeUnitTypeCommand(Unit unit, int newUnitType) {
        this.unit = unit;
        this.newUnitType = newUnitType;
        if (unit != null) {
            this.module = (Module)unit.eContainer();
        }
    }

    public void execute() {
        if (this.unit instanceof IndependentUnit) {
            this.oldUnitType = 1;
        } else if (this.unit instanceof SequentialUnit) {
            this.oldUnitType = 2;
        } else if (this.unit instanceof PriorityUnit) {
            this.oldUnitType = 3;
        }
        this.redo();
    }

    private void replaceUnit() {
        Module theModule = this.module;
        int unitIndex = theModule.getUnits().indexOf((Object)this.unit);
        if (unitIndex == -1) {
            unitIndex = theModule.getUnits().indexOf((Object)this.newUnit);
            System.err.println("unit index -1:" + this.unit + "\n trying [result: " + unitIndex + "] " + this.newUnit);
        }
        this.newUnit = null;
        EList subUnitList = null;
        switch (this.newUnitType) {
            case 1: {
                this.newUnit = HenshinFactory.eINSTANCE.createIndependentUnit();
                subUnitList = ((IndependentUnit)this.newUnit).getSubUnits();
                break;
            }
            case 2: {
                this.newUnit = HenshinFactory.eINSTANCE.createSequentialUnit();
                subUnitList = ((SequentialUnit)this.newUnit).getSubUnits();
                break;
            }
            case 3: {
                this.newUnit = HenshinFactory.eINSTANCE.createPriorityUnit();
                subUnitList = ((PriorityUnit)this.newUnit).getSubUnits();
                break;
            }
            default: {
                return;
            }
        }
        subUnitList.addAll((Collection)this.unit.getSubUnits(false));
        this.newUnit.setName(this.unit.getName());
        this.newUnit.setActivated(this.unit.isActivated());
        this.newUnit.setDescription(this.unit.getDescription());
        this.newUnit.getParameters().addAll((Collection)this.unit.getParameters());
        this.newUnit.getParameterMappings().addAll((Collection)this.unit.getParameterMappings());
        if (unitIndex != -1) {
            theModule.getUnits().remove(unitIndex);
            theModule.getUnits().add(unitIndex, (Object)this.newUnit);
        } else {
            System.err.println("COULDN'T FIND UNITS IN MODULE, ADDING A NEW ONE");
            System.err.println(this.unit);
            System.err.println(this.newUnit);
            theModule.getUnits().add((Object)this.newUnit);
        }
        for (Unit tu : theModule.getUnits()) {
            if (!tu.getSubUnits(true).contains((Object)this.unit)) continue;
            this.changeParameterMappingsRec(tu, this.unit, this.newUnit);
            this.replaceUnitRec(tu, this.unit, this.newUnit);
        }
    }

    private void changeParameterMappingsRec(Unit parentUnit, Unit oldUnit, Unit newUnit) {
        for (Unit tu : parentUnit.getSubUnits(false)) {
            if (tu == parentUnit) continue;
            if (tu.equals(oldUnit)) {
                this.changeParameterMappings(parentUnit, tu, newUnit);
            }
            if (tu.getSubUnits(false).size() <= 0) continue;
            this.changeParameterMappingsRec(tu, oldUnit, newUnit);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void replaceUnitRec(Unit parentUnit, Unit oldUnit, Unit newUnit) {
        block7: {
            block6: {
                block5: {
                    subUnitList = null;
                    if (!(parentUnit instanceof SequentialUnit)) break block5;
                    subUnitList = ((SequentialUnit)parentUnit).getSubUnits();
                    ** GOTO lbl27
                }
                if (!(parentUnit instanceof IndependentUnit)) break block6;
                subUnitList = ((IndependentUnit)parentUnit).getSubUnits();
                ** GOTO lbl27
            }
            if (!(parentUnit instanceof PriorityUnit)) break block7;
            subUnitList = ((PriorityUnit)parentUnit).getSubUnits();
            ** GOTO lbl27
        }
        if (!(parentUnit instanceof ConditionalUnit)) ** GOTO lbl27
        cu = (ConditionalUnit)parentUnit;
        if (cu.getIf().equals(oldUnit)) {
            cu.setIf(newUnit);
        }
        if (cu.getThen().equals(oldUnit)) {
            cu.setThen(newUnit);
        }
        if (cu.getElse().equals(oldUnit)) {
            cu.setElse(newUnit);
        }
        return;
lbl-1000:
        // 1 sources

        {
            i = subUnitList.indexOf((Object)oldUnit);
            subUnitList.remove(i);
            subUnitList.add(i, (Object)newUnit);
lbl27:
            // 5 sources

            ** while (subUnitList.contains((Object)oldUnit))
        }
lbl28:
        // 3 sources

        for (Unit tu : subUnitList) {
            if (tu.equals(newUnit) || !tu.getSubUnits(true).contains((Object)oldUnit) || tu == parentUnit) continue;
            this.replaceUnitRec(tu, oldUnit, newUnit);
        }
    }

    private void changeParameterMappings(Unit parentUnit, Unit oldUnit, Unit newUnit) {
        EList parameterMappings = parentUnit.getParameterMappings();
        for (ParameterMapping pm : parameterMappings) {
            Parameter newParameter;
            int oldParameterIndex;
            if (pm.getSource().getUnit().equals(oldUnit)) {
                oldParameterIndex = oldUnit.getParameters().indexOf((Object)pm.getSource());
                newParameter = (Parameter)newUnit.getParameters().get(oldParameterIndex);
                pm.setSource(newParameter);
            }
            if (!pm.getTarget().getUnit().equals(oldUnit)) continue;
            oldParameterIndex = oldUnit.getParameters().indexOf((Object)pm.getTarget());
            newParameter = (Parameter)newUnit.getParameters().get(oldParameterIndex);
            pm.setTarget(newParameter);
        }
    }

    public void redo() {
        if (this.newUnit != null) {
            Unit tmpUnit = this.unit;
            this.unit = this.newUnit;
            this.newUnit = tmpUnit;
            int unitIndex = this.module.getUnits().indexOf((Object)this.unit);
            this.module.getUnits().remove(unitIndex);
            this.module.getUnits().add(unitIndex, (Object)this.newUnit);
            for (Unit tu : this.module.getUnits()) {
                if (!tu.getSubUnits(true).contains((Object)this.unit)) continue;
                this.changeParameterMappingsRec(tu, this.unit, this.newUnit);
                this.replaceUnitRec(tu, this.unit, this.newUnit);
            }
        } else {
            this.replaceUnit();
        }
    }

    public void undo() {
        Unit tmpUnit = this.unit;
        this.unit = this.newUnit;
        this.newUnit = tmpUnit;
        int unitIndex = this.module.getUnits().indexOf((Object)this.unit);
        this.module.getUnits().remove(unitIndex);
        this.module.getUnits().add(unitIndex, (Object)this.newUnit);
        for (Unit current : this.module.getUnits()) {
            if (!current.getSubUnits(true).contains((Object)this.unit)) continue;
            this.changeParameterMappingsRec(current, this.unit, this.newUnit);
            this.replaceUnitRec(current, this.unit, this.newUnit);
        }
    }

    protected boolean prepare() {
        return this.unit instanceof IndependentUnit || this.unit instanceof SequentialUnit || this.unit instanceof PriorityUnit;
    }
}

