/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.compact;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.henshin.model.ConditionalUnit;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.IndependentUnit;
import org.eclipse.emf.henshin.model.IteratedUnit;
import org.eclipse.emf.henshin.model.LoopUnit;
import org.eclipse.emf.henshin.model.Module;
import org.eclipse.emf.henshin.model.PriorityUnit;
import org.eclipse.emf.henshin.model.Rule;
import org.eclipse.emf.henshin.model.SequentialUnit;
import org.eclipse.emf.henshin.model.Unit;
import org.eclipse.emf.henshin.model.compact.CRule;
import org.eclipse.emf.henshin.model.compact.CUnit;
import org.eclipse.emf.henshin.model.resource.HenshinResourceSet;

public class CModule {
    private Module module;

    public CModule(Module module) {
        this.setModule(module);
    }

    public CModule(String name) {
        this(HenshinFactory.eINSTANCE.createModule());
        this.getModule().setName(name);
    }

    public static CModule loadFromFile(String filePath) {
        CharSequence[] path = filePath.split("/");
        String name = path[path.length - 1];
        path[path.length - 1] = "";
        HenshinResourceSet res = new HenshinResourceSet(String.join((CharSequence)"/", path));
        Module mod = res.getModule(name);
        return new CModule(mod);
    }

    public CModule addImport(EPackage pack) {
        this.module.getImports().add((Object)pack);
        new HenshinResourceSet().getPackageRegistry().putIfAbsent((Object)pack.getNsURI(), (Object)pack);
        return this;
    }

    public CModule addImportsFromFile(String filePath) {
        CharSequence[] path = filePath.split("/");
        String name = path[path.length - 1];
        path[path.length - 1] = "";
        HenshinResourceSet res = new HenshinResourceSet(String.join((CharSequence)"/", path));
        for (EPackage pack : res.registerDynamicEPackages(name)) {
            this.addImport(pack);
        }
        return this;
    }

    public void save(String fileName) {
        CharSequence[] path = fileName.split("/");
        String name = path[path.length - 1];
        path[path.length - 1] = "";
        HenshinResourceSet res = new HenshinResourceSet(String.join((CharSequence)"/", path));
        res.saveEObject((EObject)this.module, String.valueOf(name) + ".henshin");
    }

    public void save() {
        this.save(this.module.getName());
    }

    public CRule addRule(Rule rule) {
        CRule cr = new CRule(rule);
        this.module.getUnits().add((Object)rule);
        return cr;
    }

    public CUnit addUnit(Unit unit) {
        CUnit cu = new CUnit(unit);
        this.module.getUnits().add((Object)unit);
        return cu;
    }

    public CRule createRule(String name) {
        CRule rule = new CRule(name);
        this.module.getUnits().add((Object)rule.getUnit());
        return rule;
    }

    public CUnit createLoop(CUnit unit) {
        LoopUnit loop = HenshinFactory.eINSTANCE.createLoopUnit();
        loop.setName(String.valueOf(unit.getUnit().getName()) + "-Loop");
        loop.setSubUnit(unit.getUnit());
        this.module.getUnits().add((Object)loop);
        return new CUnit(loop);
    }

    public CUnit createIteration(CUnit unit, String iterations) {
        IteratedUnit iter = HenshinFactory.eINSTANCE.createIteratedUnit();
        iter.setName(String.valueOf(unit.getUnit().getName()) + "-Iteration");
        iter.setSubUnit(unit.getUnit());
        iter.setIterations(iterations);
        this.module.getUnits().add((Object)iter);
        return new CUnit(iter);
    }

    public CUnit createConditional(CUnit unitIf, CUnit unitThen, CUnit unitElse, String name) {
        ConditionalUnit cond = HenshinFactory.eINSTANCE.createConditionalUnit();
        cond.setName(name);
        cond.setIf(unitIf.getUnit());
        cond.setThen(unitThen.getUnit());
        if (unitElse != null) {
            cond.setElse(unitElse.getUnit());
        }
        this.module.getUnits().add((Object)cond);
        return new CUnit(cond);
    }

    public CUnit addToPriority(CUnit unit, String name) {
        PriorityUnit prio = (PriorityUnit)this.module.getUnit(name);
        if (prio == null) {
            prio = HenshinFactory.eINSTANCE.createPriorityUnit();
            prio.setName(name);
        }
        prio.getSubUnits().add((Object)unit.getUnit());
        this.module.getUnits().add((Object)prio);
        return new CUnit(prio);
    }

    public CUnit addToSequence(CUnit unit, String name) {
        SequentialUnit seq = (SequentialUnit)this.module.getUnit(name);
        if (seq == null) {
            seq = HenshinFactory.eINSTANCE.createSequentialUnit();
            seq.setName(name);
            this.module.getUnits().add((Object)seq);
        }
        seq.getSubUnits().add((Object)unit.getUnit());
        return new CUnit(seq);
    }

    public CUnit addToIndependent(CUnit unit, String name) {
        IndependentUnit ind = (IndependentUnit)this.module.getUnit(name);
        if (ind == null) {
            ind = HenshinFactory.eINSTANCE.createIndependentUnit();
            ind.setName(name);
        }
        ind.getSubUnits().add((Object)unit.getUnit());
        this.module.getUnits().add((Object)ind);
        return new CUnit(ind);
    }

    public List<CUnit> getAllCUnits() {
        ArrayList<CUnit> res = new ArrayList<CUnit>();
        for (Unit u : this.module.getUnits()) {
            res.add(new CUnit(u));
        }
        return res;
    }

    public Module getModule() {
        return this.module;
    }

    public void setModule(Module module) {
        this.module = module;
    }
}

