/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.model.util;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EcorePackage;
import org.eclipse.emf.henshin.model.Action;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Rule;

public class RuleGeneralizer {
    public static void generalizeRule(Rule rule) {
        rule.eAllContents().forEachRemaining(element -> {
            if (element instanceof Node) {
                Node node = (Node)element;
                if (node.getActionNode().getAction().getType().equals((Object)Action.Type.DELETE)) {
                    node.setType(RuleGeneralizer.selectMostAbstractType(RuleGeneralizer.getRequiredTypes(node)));
                } else if (node != node.getActionNode() && node.getActionNode().getAction().getType().equals((Object)Action.Type.PRESERVE)) {
                    Node lhsNode = node.getActionNode();
                    Set<EClass> requiredTypes = RuleGeneralizer.getRequiredTypes(node);
                    requiredTypes.addAll(RuleGeneralizer.getRequiredTypes(lhsNode));
                    EClass mostAbstractType = RuleGeneralizer.selectMostAbstractType(requiredTypes);
                    node.setType(mostAbstractType);
                    lhsNode.setType(mostAbstractType);
                }
            }
        });
    }

    private static Set<EClass> getRequiredTypes(Node node) {
        HashSet<EClass> types = new HashSet<EClass>();
        for (Edge ougoing : node.getOutgoing()) {
            types.add(ougoing.getType().getEContainingClass());
        }
        for (Edge incoming : node.getIncoming()) {
            types.add(incoming.getType().getEReferenceType());
        }
        for (Attribute attribute : node.getAttributes()) {
            types.add(attribute.getType().getEContainingClass());
        }
        return types;
    }

    private static EClass selectMostAbstractType(Collection<EClass> types) {
        if (!types.isEmpty()) {
            EClass mostSpecific = types.iterator().next();
            for (EClass type : types) {
                if (!type.getEAllSuperTypes().contains((Object)mostSpecific)) continue;
                mostSpecific = type;
            }
            return mostSpecific;
        }
        return EcorePackage.eINSTANCE.getEObject();
    }
}

