/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.emf.henshin.ocl2ac.utils.henshin.simplification;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.henshin.model.And;
import org.eclipse.emf.henshin.model.Attribute;
import org.eclipse.emf.henshin.model.BinaryFormula;
import org.eclipse.emf.henshin.model.Edge;
import org.eclipse.emf.henshin.model.Formula;
import org.eclipse.emf.henshin.model.Graph;
import org.eclipse.emf.henshin.model.HenshinFactory;
import org.eclipse.emf.henshin.model.NestedCondition;
import org.eclipse.emf.henshin.model.Node;
import org.eclipse.emf.henshin.model.Or;
import org.eclipse.emf.henshin.model.UnaryFormula;
import org.eclipse.emf.henshin.ocl2ac.utils.henshin.simplification.EdgeMapping;
import org.eclipse.emf.henshin.ocl2ac.utils.henshin.simplification.Intersection;
import org.eclipse.emf.henshin.ocl2ac.utils.henshin.simplification.NodeMapping;

public class EquivalencesSimplifier {
    private Formula formula;
    private HenshinFactory factory;

    public EquivalencesSimplifier(Formula formula) {
        this.formula = formula;
        this.factory = HenshinFactory.eINSTANCE;
    }

    public boolean simplify() {
        if (this.simplifyExists()) {
            return this.simplify();
        }
        return true;
    }

    private boolean insert(EObject container, Formula oldContent, Formula newContent) {
        if (container instanceof NestedCondition) {
            NestedCondition constraint = (NestedCondition)container;
            constraint.getConclusion().setFormula(newContent);
            return true;
        }
        if (container instanceof Graph) {
            Graph qlc = (Graph)container;
            qlc.setFormula(newContent);
            return true;
        }
        if (container instanceof Formula) {
            Formula f = (Formula)container;
            if (f instanceof UnaryFormula) {
                UnaryFormula not = (UnaryFormula)f;
                not.setChild(newContent);
                return true;
            }
            if (f instanceof BinaryFormula) {
                BinaryFormula binaryFormula = (BinaryFormula)f;
                if (binaryFormula.getLeft() == oldContent) {
                    binaryFormula.setLeft(newContent);
                    return true;
                }
                if (binaryFormula.getRight() == oldContent) {
                    binaryFormula.setRight(newContent);
                    return true;
                }
            }
        }
        return false;
    }

    public boolean simplifyExists() {
        TreeIterator iter = this.formula.eAllContents();
        while (iter.hasNext()) {
            Graph gr2;
            Graph gr1;
            And andFormula;
            EObject eObject = (EObject)iter.next();
            if (this.isExistsCondition(eObject)) {
                And andFormula2;
                NestedCondition outerCondition = (NestedCondition)eObject;
                if (this.isExistsCondition((EObject)outerCondition.getConclusion().getFormula())) {
                    NestedCondition innerCondition = (NestedCondition)outerCondition.getConclusion().getFormula();
                    if (this.isLeaf(innerCondition)) {
                        String name2;
                        String name1;
                        Node innerNode;
                        Graph innerGraph;
                        Graph outerGraph = outerCondition.getConclusion();
                        if (this.isSubGraph(outerGraph, innerGraph = innerCondition.getConclusion())) {
                            outerCondition.setConclusion(innerGraph);
                            System.out.println("(1) Equivalence E1.c");
                            return true;
                        }
                        if (this.isSubGraph(innerGraph, outerGraph)) {
                            outerCondition.getConclusion().setFormula(null);
                            System.out.println("(2) Equivalence E1.c");
                            return true;
                        }
                        if (this.areClanDisjoint(innerGraph, outerGraph)) {
                            EList innerNodes = innerGraph.getNodes();
                            innerGraph.getNodes().clear();
                            outerGraph.getNodes().addAll((Collection)innerNodes);
                            EList innerEdges = innerGraph.getEdges();
                            innerGraph.getEdges().clear();
                            outerGraph.getEdges().addAll((Collection)innerEdges);
                            outerCondition.getConclusion().setFormula(null);
                            System.out.println("Equivalence E1.b");
                            return true;
                        }
                        if (this.haveIntersection(innerGraph, outerGraph)) {
                            EList<Intersection> intersections = this.getIntersections(outerGraph, innerGraph);
                            EObject container = outerCondition.eContainer();
                            if (intersections.size() == 1) {
                                NestedCondition condition = this.factory.createNestedCondition();
                                condition.setConclusion(this.glue(outerGraph, (Intersection)intersections.get(0), innerGraph));
                                this.insert(container, (Formula)outerCondition, (Formula)condition);
                                System.out.println("(1) Equivalence E1.a");
                                return true;
                            }
                            Or orFormula = this.factory.createOr();
                            Or orRight = null;
                            for (Intersection intersection : intersections) {
                                NestedCondition condition = this.factory.createNestedCondition();
                                condition.setConclusion(this.glue(outerCondition.getConclusion(), intersection, innerCondition.getConclusion()));
                                orFormula.setLeft((Formula)condition);
                                orFormula.setLeft((Formula)condition);
                                orRight = this.factory.createOr();
                                orFormula.setRight((Formula)orRight);
                                orFormula = orRight;
                            }
                            this.insert(container, (Formula)outerCondition, (Formula)orFormula);
                            System.out.println("(2) Equivalence E1.a");
                            return true;
                        }
                        if (this.hasOnlyOneNode(innerGraph) && this.hasTwoNames(innerNode = (Node)innerGraph.getNodes().get(0)) && this.containsExactlyOne(outerGraph, name1 = this.getNames(innerNode.getName()).get(0), name2 = this.getNames(innerNode.getName()).get(1))) {
                            this.rename(outerGraph, name1, name2);
                            outerCondition.getConclusion().setFormula(null);
                            System.out.println("Equivalence E3'");
                            return true;
                        }
                    }
                    System.err.println("not a leaf");
                }
                if (this.isAndFormula((EObject)outerCondition.getConclusion().getFormula()) && this.isExistsCondition((EObject)(andFormula2 = (And)outerCondition.getConclusion().getFormula()).getLeft()) && this.isExistsCondition((EObject)andFormula2.getRight())) {
                    NestedCondition cond1 = (NestedCondition)andFormula2.getLeft();
                    NestedCondition cond2 = (NestedCondition)andFormula2.getRight();
                    if (this.isLeaf(cond1) && this.isLeaf(cond2)) {
                        Node node1;
                        String name2;
                        String name1;
                        String name;
                        Node node2;
                        Node node;
                        Graph gr = outerCondition.getConclusion();
                        Graph gr12 = cond1.getConclusion();
                        Graph gr22 = cond2.getConclusion();
                        if (this.hasOnlyOneNode(gr) && this.hasOnlyOneNode(gr22) && this.haveSameTypes(node = (Node)gr.getNodes().get(0), node2 = (Node)gr22.getNodes().get(0)) && this.hasOneName(node) && this.hasTwoNames(node2)) {
                            name = node.getName();
                            name1 = node2.getName().split("=")[0];
                            name2 = node2.getName().split("=")[1];
                            if ((name.equals(name1) || name.equals(name2)) && this.containsExactlyOne(gr12, name1, name2)) {
                                this.rename(gr12, name1, name2);
                                outerCondition.getConclusion().setFormula((Formula)cond1);
                                System.out.println("Equivalence E3");
                                return true;
                            }
                        }
                        if (this.hasOnlyOneNode(gr) && this.hasOnlyOneNode(gr12) && this.haveSameTypes(node = (Node)gr.getNodes().get(0), node1 = (Node)gr12.getNodes().get(0)) && this.hasOneName(node) && this.hasTwoNames(node1)) {
                            name = node.getName();
                            name1 = node1.getName().split("=")[0];
                            name2 = node1.getName().split("=")[1];
                            if ((name.equals(name1) || name.equals(name2)) && this.containsExactlyOne(gr22, name1, name2)) {
                                this.rename(gr22, name1, name2);
                                outerCondition.getConclusion().setFormula((Formula)cond2);
                                System.out.println("Equivalence E3");
                                return true;
                            }
                        }
                        System.out.println("=> haveRecurringNodes: " + this.haveRecurringNodes(gr12, gr22));
                        System.out.println("=> containsEachRecurringNode: " + this.containsEachRecurringNode(gr, gr12, gr22));
                        if (this.haveRecurringNodes(gr12, gr22) && (this.containsEachRecurringNode(gr, gr12, gr22) || this.containsNoRecurringNodeType(gr, gr12, gr22)) && this.haveIntersection(gr12, gr22)) {
                            EList<Intersection> intersections = this.getIntersections(gr12, gr22);
                            if (intersections.size() == 1) {
                                NestedCondition condition = this.factory.createNestedCondition();
                                condition.setConclusion(this.glue(gr12, (Intersection)intersections.get(0), gr22));
                                outerCondition.getConclusion().setFormula((Formula)condition);
                                System.out.println("Equivalence E2.a");
                                return true;
                            }
                            Or or = this.factory.createOr();
                            Or orRight = null;
                            for (Intersection intersection : intersections) {
                                NestedCondition condition = this.factory.createNestedCondition();
                                condition.setConclusion(this.glue(gr12, intersection, gr22));
                                or.setLeft((Formula)condition);
                                orRight = this.factory.createOr();
                                or.setRight((Formula)orRight);
                                or = orRight;
                            }
                            outerCondition.getConclusion().setFormula((Formula)or);
                            System.out.println("Equivalence E2.a");
                            return true;
                        }
                    }
                }
            }
            if (!this.isAndFormula(eObject) || !this.isExistsCondition((EObject)(andFormula = (And)eObject).getLeft()) || !this.isExistsCondition((EObject)andFormula.getRight())) continue;
            NestedCondition cond1 = (NestedCondition)andFormula.getLeft();
            NestedCondition cond2 = (NestedCondition)andFormula.getRight();
            if (!this.isLeaf(cond1) || !this.isLeaf(cond2) || !this.areClanDisjoint(gr1 = cond1.getConclusion(), gr2 = cond2.getConclusion()) || !this.areNodeNameDisjoint(gr1, gr2)) continue;
            EList nodes = gr2.getNodes();
            gr2.getNodes().clear();
            gr1.getNodes().addAll((Collection)nodes);
            EList edges = gr2.getEdges();
            gr2.getEdges().clear();
            gr1.getEdges().addAll((Collection)edges);
            EObject container = andFormula.eContainer();
            this.insert(container, (Formula)andFormula, (Formula)cond1);
            System.out.println("Equivalence E2.b");
            return true;
        }
        System.err.println("return false");
        return false;
    }

    private boolean haveRecurringNodes(Graph gr1, Graph gr2) {
        EList<Node> recurringNodes = this.collectRecurringNodes(gr1, gr2);
        return !recurringNodes.isEmpty();
    }

    private boolean containsEachRecurringNode(Graph gr, Graph gr1, Graph gr2) {
        EList<Node> recurringNodes = this.collectRecurringNodes(gr1, gr2);
        for (Node recurringNode : recurringNodes) {
            boolean occurs = false;
            String nodeName = recurringNode.getName();
            EClass type = recurringNode.getType();
            for (Node node : gr.getNodes()) {
                if (!node.getName().equals(nodeName) || node.getType() != type) continue;
                occurs = true;
                break;
            }
            if (occurs) continue;
            return false;
        }
        return true;
    }

    private boolean containsNoRecurringNodeType(Graph gr, Graph gr1, Graph gr2) {
        EList<Node> recurringNodes = this.collectRecurringNodes(gr1, gr2);
        boolean occurs = false;
        block0: for (Node recurringNode : recurringNodes) {
            EClass type = recurringNode.getType();
            for (Node node : gr.getNodes()) {
                if (node.getType() != type) continue;
                occurs = true;
                continue block0;
            }
        }
        return !occurs;
    }

    private EList<Node> collectRecurringNodes(Graph gr1, Graph gr2) {
        BasicEList recurringNodes = new BasicEList();
        block0: for (Node node1 : gr1.getNodes()) {
            String nodeName = node1.getName();
            EClass type = node1.getType();
            for (Node node2 : gr2.getNodes()) {
                if (!node2.getName().equals(nodeName) || node2.getType() != type) continue;
                recurringNodes.add((Object)node1);
                continue block0;
            }
        }
        return recurringNodes;
    }

    private void rename(Graph graph, String name1, String name2) {
        String newName = String.valueOf(name1) + "=" + name2;
        for (Node node : graph.getNodes()) {
            if (!node.getName().equals(name1) && !node.getName().equals(name2)) continue;
            node.setName(newName);
        }
    }

    private boolean containsExactlyOne(Graph graph, String name1, String name2) {
        boolean exists1 = false;
        boolean exists2 = false;
        for (Node node : graph.getNodes()) {
            if (node.getName().equals(name1)) {
                exists1 = true;
            }
            if (!node.getName().equals(name2)) continue;
            exists2 = true;
        }
        return exists1 && !exists2 || !exists1 && exists2;
    }

    private boolean hasTwoNames(Node node) {
        return node.getName().split("=").length == 2;
    }

    private boolean hasOneName(Node node) {
        return node.getName().split("=").length == 1;
    }

    private boolean haveSameTypes(Node node1, Node node2) {
        return node1.getType() == node2.getType();
    }

    private boolean hasOnlyOneNode(Graph graph) {
        return graph.getNodes().size() == 1 && graph.getEdges().isEmpty();
    }

    private Graph glue(Graph gr1, Intersection intersection, Graph gr2) {
        Edge edgeCopy;
        Node nodeCopy;
        Graph graph = intersection.getSourceGraph();
        for (Node node : gr1.getNodes()) {
            if (intersection.containsSource(node)) continue;
            nodeCopy = (Node)EcoreUtil.copy((EObject)node);
            intersection.addNodeMapping(new NodeMapping(nodeCopy, node));
            graph.getNodes().add((Object)nodeCopy);
        }
        for (Node node : gr2.getNodes()) {
            if (intersection.containsTarget(node)) continue;
            nodeCopy = (Node)EcoreUtil.copy((EObject)node);
            intersection.addNodeMapping(new NodeMapping(nodeCopy, node));
            graph.getNodes().add((Object)nodeCopy);
        }
        for (Edge edge : gr1.getEdges()) {
            if (intersection.containsTarget(edge)) continue;
            edgeCopy = (Edge)EcoreUtil.copy((EObject)edge);
            edgeCopy.setSource(intersection.getSourceNode1(edge.getSource()));
            edgeCopy.setTarget(intersection.getSourceNode1(edge.getTarget()));
            graph.getEdges().add((Object)edgeCopy);
        }
        for (Edge edge : gr2.getEdges()) {
            if (intersection.containsTarget(edge)) continue;
            edgeCopy = (Edge)EcoreUtil.copy((EObject)edge);
            edgeCopy.setSource(intersection.getSourceNode(edge.getSource()));
            edgeCopy.setTarget(intersection.getSourceNode(edge.getTarget()));
            graph.getEdges().add((Object)edgeCopy);
        }
        return graph;
    }

    private EList<Intersection> getIntersections(Graph gr1, Graph gr2) {
        BasicEList intersections = new BasicEList();
        BasicEList subGraphs = new BasicEList();
        this.fillSubGraphs((EList<Graph>)subGraphs, gr1);
        for (Graph graph : subGraphs) {
            if (!this.isSubGraph(graph, gr2)) continue;
            intersections.add((Object)this.getIntersection(graph, gr2));
        }
        return intersections;
    }

    private Intersection getIntersection(Graph subGraph, Graph graph) {
        Intersection intersection = new Intersection();
        for (Node n1 : subGraph.getNodes()) {
            for (Node n2 : graph.getNodes()) {
                if (n1.getType() != n2.getType() || !n1.getName().equals(n2.getName())) continue;
                intersection.addNodeMapping(new NodeMapping(n1, n2));
            }
        }
        block2: for (Edge e1 : subGraph.getEdges()) {
            Node src1 = e1.getSource();
            NodeMapping srcMapping = this.getMapping(intersection.getNodeMappings(), src1);
            Node tgt1 = e1.getTarget();
            NodeMapping tgtMapping = this.getMapping(intersection.getNodeMappings(), tgt1);
            for (Edge e2 : graph.getEdges()) {
                Node src2 = e2.getSource();
                Node tgt2 = e2.getTarget();
                if (e1.getType() != e2.getType() || srcMapping.getTargetNode() != src2 || tgtMapping.getTargetNode() != tgt2) continue;
                intersection.addEdgeMapping(new EdgeMapping(e1, e2));
                continue block2;
            }
        }
        return intersection;
    }

    private void fillSubGraphs(EList<Graph> subGraphs, Graph graph) {
        EList<Edge> edges = this.cloneEdges(graph);
        for (Edge edge : edges) {
            graph.getEdges().remove((Object)edge);
            Graph gr = (Graph)EcoreUtil.copy((EObject)graph);
            graph.getEdges().add((Object)edge);
            this.testAndFill(subGraphs, gr);
        }
        EList<Node> nodes = this.cloneNodes(graph);
        for (Node node : nodes) {
            if (this.isConnected(node, graph)) continue;
            graph.getNodes().remove((Object)node);
            Graph gr = (Graph)EcoreUtil.copy((EObject)graph);
            graph.getNodes().add((Object)node);
            if (this.isEmptyGraph(gr)) continue;
            this.testAndFill(subGraphs, gr);
        }
    }

    private boolean isEmptyGraph(Graph graph) {
        return graph.getNodes().isEmpty() && graph.getEdges().isEmpty();
    }

    private boolean isConnected(Node node, Graph graph) {
        for (Edge edge : graph.getEdges()) {
            if (edge.getSource() == node) {
                return true;
            }
            if (edge.getTarget() != node) continue;
            return true;
        }
        return false;
    }

    private void testAndFill(EList<Graph> graphs, Graph graph) {
        if (!this.contains(graphs, graph)) {
            graphs.add((Object)graph);
            this.fillSubGraphs(graphs, graph);
        }
    }

    private boolean contains(EList<Graph> graphs, Graph graph) {
        for (Graph gr : graphs) {
            if (!this.isSameGraph(gr, graph)) continue;
            return true;
        }
        return false;
    }

    private boolean isSameGraph(Graph gr1, Graph gr2) {
        return this.isSubGraph(gr1, gr2) && this.isSubGraph(gr2, gr1);
    }

    private EList<Node> cloneNodes(Graph graph) {
        BasicEList nodes = new BasicEList();
        for (Node node : graph.getNodes()) {
            nodes.add((Object)node);
        }
        return nodes;
    }

    private EList<Edge> cloneEdges(Graph graph) {
        BasicEList edges = new BasicEList();
        for (Edge edge : graph.getEdges()) {
            edges.add((Object)edge);
        }
        return edges;
    }

    private boolean areNodeNameDisjoint(Graph gr1, Graph gr2) {
        List<String> names1 = this.getNodeNames(gr1);
        List<String> names2 = this.getNodeNames(gr2);
        for (String str1 : names1) {
            for (String str2 : names2) {
                if (!str1.equals(str2)) continue;
                return false;
            }
        }
        return true;
    }

    private List<String> getNodeNames(Graph graph) {
        ArrayList<String> names = new ArrayList<String>();
        for (Node node : graph.getNodes()) {
            names.addAll(this.getNames(node.getName()));
        }
        return names;
    }

    private List<String> getNames(String name) {
        String[] names = name.split("=");
        return Arrays.asList(names);
    }

    private boolean haveIntersection(Graph gr1, Graph gr2) {
        EList<Intersection> intersections = this.getIntersections(gr1, gr2);
        return !intersections.isEmpty();
    }

    private boolean areClanDisjoint(Graph gr1, Graph gr2) {
        for (Node n1 : gr1.getNodes()) {
            EList<EClass> clan1 = this.getClan(n1.getType());
            for (Node n2 : gr2.getNodes()) {
                if (!clan1.contains((Object)n2.getType())) continue;
                return false;
            }
        }
        for (Node n2 : gr2.getNodes()) {
            EList<EClass> clan2 = this.getClan(n2.getType());
            for (Node n1 : gr1.getNodes()) {
                if (!clan2.contains((Object)n1.getType())) continue;
                return false;
            }
        }
        return true;
    }

    private EList<EClass> getClan(EClass eClass) {
        BasicEList eClasses = new BasicEList();
        eClasses.add((Object)eClass);
        eClasses.addAll(this.getAllSubclasses(eClass));
        return eClasses;
    }

    private EList<EClass> getAllSubclasses(EClass eClass) {
        BasicEList eClasses = new BasicEList();
        EPackage ePackage = eClass.getEPackage();
        TreeIterator iter = ePackage.eAllContents();
        while (iter.hasNext()) {
            EClass clazz;
            EObject eObject = (EObject)iter.next();
            if (!(eObject instanceof EClass) || !(clazz = (EClass)eObject).getEAllSuperTypes().contains((Object)eClass)) continue;
            eClasses.add((Object)clazz);
        }
        return eClasses;
    }

    public boolean isSubGraph(Graph graphA, Graph graphB) {
        HashMap<Node, Node> mappingNodeA2NodeB = new HashMap<Node, Node>();
        for (Node nodeA : graphA.getNodes()) {
            for (Node nodeB : graphB.getNodes()) {
                if (nodeA.getType() != nodeB.getType() || !this.getNames(nodeB.getName()).containsAll(this.getNames(nodeA.getName())) || !nodeB.getAttributes().containsAll((Collection)nodeA.getAttributes())) continue;
                boolean attISO = true;
                for (Attribute a : nodeA.getAttributes()) {
                    if (this.getBy(a, (EList<Attribute>)nodeB.getAttributes()) != null) continue;
                    attISO = false;
                }
                if (!attISO) continue;
                mappingNodeA2NodeB.put(nodeA, nodeB);
            }
        }
        if (graphA.getNodes().size() != mappingNodeA2NodeB.size()) {
            return false;
        }
        for (Edge edgeA : graphA.getEdges()) {
            Node srcEdgeA = edgeA.getSource();
            Node tgtEdgeA = edgeA.getTarget();
            boolean edgeIsMapped = false;
            for (Edge edgeB : graphB.getEdges()) {
                Node srcEdgeB = edgeB.getSource();
                Node tgtEdgeB = edgeB.getTarget();
                if (edgeA.getType() != edgeB.getType() || mappingNodeA2NodeB.get(srcEdgeA) != srcEdgeB || mappingNodeA2NodeB.get(tgtEdgeA) != tgtEdgeB) continue;
                edgeIsMapped = true;
                break;
            }
            if (edgeIsMapped) continue;
            return false;
        }
        return true;
    }

    private Attribute getBy(Attribute a, EList<Attribute> ls) {
        for (Attribute b : ls) {
            if (b.getType() != a.getType() || b.getValue() != a.getValue()) continue;
            return b;
        }
        return null;
    }

    private NodeMapping getMapping(EList<NodeMapping> nodeMappings, Node node) {
        for (NodeMapping nm : nodeMappings) {
            if (nm.getSourceNode() != node) continue;
            return nm;
        }
        return null;
    }

    private boolean isLeaf(NestedCondition nestedCondition) {
        if (nestedCondition.getConclusion() == null) {
            return true;
        }
        return nestedCondition.getConclusion() != null && nestedCondition.getConclusion().getFormula() == null;
    }

    private boolean isAndFormula(EObject eObject) {
        return eObject instanceof And;
    }

    private boolean isExistsCondition(EObject eObject) {
        return eObject instanceof NestedCondition;
    }
}

