/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gmf.runtime.diagram.ui.editpolicies;

import java.util.Iterator;
import org.eclipse.core.commands.operations.IUndoableOperation;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.transaction.TransactionalEditingDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.requests.ChangeBoundsRequest;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.rulers.RulerProvider;
import org.eclipse.gmf.runtime.common.core.command.ICommand;
import org.eclipse.gmf.runtime.diagram.ui.commands.ICommandProxy;
import org.eclipse.gmf.runtime.diagram.ui.commands.SetBoundsCommand;
import org.eclipse.gmf.runtime.diagram.ui.editparts.IGraphicalEditPart;
import org.eclipse.gmf.runtime.diagram.ui.editparts.ShapeEditPart;
import org.eclipse.gmf.runtime.diagram.ui.figures.LayoutHelper;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.DiagramGuide;
import org.eclipse.gmf.runtime.diagram.ui.internal.ruler.commands.ChangeGuideCommand;
import org.eclipse.gmf.runtime.diagram.ui.l10n.DiagramUIMessages;
import org.eclipse.gmf.runtime.diagram.ui.requests.CreateViewRequest;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.IMapMode;
import org.eclipse.gmf.runtime.draw2d.ui.mapmode.MapModeUtil;
import org.eclipse.gmf.runtime.emf.commands.core.command.CompositeTransactionalCommand;
import org.eclipse.gmf.runtime.emf.core.util.EObjectAdapter;
import org.eclipse.gmf.runtime.notation.Guide;
import org.eclipse.gmf.runtime.notation.View;

public class XYLayoutEditPolicy
extends org.eclipse.gef.editpolicies.XYLayoutEditPolicy {
    LayoutHelper layoutHelper = null;

    protected Command createAddCommand(EditPart child, Object constraint) {
        if (child instanceof ShapeEditPart && constraint instanceof Rectangle) {
            Rectangle rect = (Rectangle)constraint;
            SetBoundsCommand boundsCommand = new SetBoundsCommand(((ShapeEditPart)child).getEditingDomain(), DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)((View)child.getModel())), rect.getTopLeft());
            return new ICommandProxy((ICommand)boundsCommand);
        }
        return null;
    }

    protected Command createChangeConstraintCommand(ChangeBoundsRequest request, EditPart child, Object constraint) {
        ChangeGuideCommand cgm;
        int alignment;
        ChangeGuideCommand cgm2;
        Integer guidePos;
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Command cmd = this.createChangeConstraintCommand(child, constraint);
        View view = (View)child.getModel();
        if ((request.getResizeDirection() & 5) != 0) {
            guidePos = (Integer)request.getExtendedData().get("SnapToGuides.HorizontalGuide");
            if (guidePos != null) {
                int hAlignment = (Integer)request.getExtendedData().get("SnapToGuides.HorizontalAttachment");
                cgm2 = new ChangeGuideCommand(editingDomain, view, true);
                cgm2.setNewGuide(this.findGuideAt(guidePos, true), hAlignment);
                cmd = cmd.chain((Command)new ICommandProxy((ICommand)cgm2));
            } else if (DiagramGuide.getInstance().getHorizontalGuide(view) != null) {
                alignment = DiagramGuide.getInstance().getHorizontalAlignment(view);
                int edgeBeingResized = 0;
                edgeBeingResized = (request.getResizeDirection() & 1) != 0 ? -1 : 1;
                if (alignment == edgeBeingResized) {
                    cgm = new ChangeGuideCommand(editingDomain, view, true);
                    cmd = cmd.chain((Command)new ICommandProxy((ICommand)cgm));
                }
            }
        }
        if ((request.getResizeDirection() & 0x18) != 0) {
            guidePos = (Integer)request.getExtendedData().get("SnapToGuides.VerticalGuide");
            if (guidePos != null) {
                int vAlignment = (Integer)request.getExtendedData().get("SnapToGuides.VerticalAttachment");
                cgm2 = new ChangeGuideCommand(editingDomain, view, false);
                cgm2.setNewGuide(this.findGuideAt(guidePos, false), vAlignment);
                cmd = cmd.chain((Command)new ICommandProxy((ICommand)cgm2));
            } else if (DiagramGuide.getInstance().getVerticalGuide(view) != null) {
                alignment = DiagramGuide.getInstance().getVerticalAlignment(view);
                int edgeBeingResized = 0;
                edgeBeingResized = (request.getResizeDirection() & 8) != 0 ? -1 : 1;
                if (alignment == edgeBeingResized) {
                    cgm = new ChangeGuideCommand(editingDomain, view, false);
                    cmd = cmd.chain((Command)new ICommandProxy((ICommand)cgm));
                }
            }
        }
        if (request.getType().equals("move children") || request.getType().equals("align children")) {
            guidePos = (Integer)request.getExtendedData().get("SnapToGuides.HorizontalGuide");
            ChangeGuideCommand cgm3 = null;
            if (guidePos != null) {
                cgm3 = new ChangeGuideCommand(editingDomain, view, true);
                int hAlignment = (Integer)request.getExtendedData().get("SnapToGuides.HorizontalAttachment");
                cgm3.setNewGuide(this.findGuideAt(guidePos, true), hAlignment);
            } else {
                Guide theOldGuide = DiagramGuide.getInstance().getHorizontalGuide(view);
                if (theOldGuide != null) {
                    cgm3 = new ChangeGuideCommand(editingDomain, view, true);
                }
            }
            if (cgm3 != null) {
                cmd = cmd.chain((Command)new ICommandProxy((ICommand)cgm3));
            }
            guidePos = (Integer)request.getExtendedData().get("SnapToGuides.VerticalGuide");
            cgm3 = null;
            if (guidePos != null) {
                cgm3 = new ChangeGuideCommand(editingDomain, view, false);
                int vAlignment = (Integer)request.getExtendedData().get("SnapToGuides.VerticalAttachment");
                cgm3.setNewGuide(this.findGuideAt(guidePos, false), vAlignment);
            } else {
                Guide theOldGuide = DiagramGuide.getInstance().getVerticalGuide(view);
                if (theOldGuide != null) {
                    cgm3 = new ChangeGuideCommand(editingDomain, view, true);
                }
            }
            if (cgm3 != null) {
                cmd = cmd.chain((Command)new ICommandProxy((ICommand)cgm3));
            }
        }
        return cmd;
    }

    protected Command createChangeConstraintCommand(EditPart child, Object constraint) {
        Rectangle newBounds = (Rectangle)constraint;
        View shapeView = (View)child.getModel();
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        SetBoundsCommand boundsCommand = new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)new EObjectAdapter((EObject)shapeView), newBounds);
        return new ICommandProxy((ICommand)boundsCommand);
    }

    protected Object getConstraintFor(ChangeBoundsRequest request, GraphicalEditPart child) {
        Rectangle rect = (Rectangle)super.getConstraintFor(request, child);
        Rectangle cons = this.getCurrentConstraintFor(child);
        Dimension requestSizeDelta = request.getSizeDelta();
        if (requestSizeDelta.width == 0 && cons != null) {
            rect.width = cons.width;
        }
        if (requestSizeDelta.height == 0 && cons != null) {
            rect.height = cons.height;
        }
        return rect;
    }

    protected Command getCreateCommand(CreateRequest request) {
        CreateViewRequest req = (CreateViewRequest)request;
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        CompositeTransactionalCommand cc = new CompositeTransactionalCommand(editingDomain, DiagramUIMessages.AddCommand_Label);
        Iterator<? extends CreateViewRequest.ViewDescriptor> iter = req.getViewDescriptors().iterator();
        Rectangle BOUNDS = (Rectangle)this.getConstraintFor(request);
        while (iter.hasNext()) {
            CreateViewRequest.ViewDescriptor viewDescriptor = iter.next();
            Rectangle rect = this.getBoundsOffest(req, BOUNDS, viewDescriptor);
            cc.compose((IUndoableOperation)new SetBoundsCommand(editingDomain, DiagramUIMessages.SetLocationCommand_Label_Resize, (IAdaptable)viewDescriptor, rect));
        }
        if (cc.reduce() == null) {
            return null;
        }
        return this.chainGuideAttachmentCommands((Request)request, new ICommandProxy(cc.reduce()));
    }

    protected Rectangle getBoundsOffest(CreateViewRequest request, Rectangle bounds, CreateViewRequest.ViewDescriptor viewDescriptor) {
        int translate = request.getViewDescriptors().indexOf(viewDescriptor) * 10;
        return bounds.getCopy().translate(translate, translate);
    }

    protected Command getDeleteDependantCommand(Request request) {
        return null;
    }

    protected Command getOrphanChildrenCommand(Request request) {
        return null;
    }

    protected EditPolicy createChildEditPolicy(EditPart child) {
        if (child instanceof ShapeEditPart) {
            return ((ShapeEditPart)child).getPrimaryDragEditPolicy();
        }
        return null;
    }

    public Command getCommand(Request request) {
        if ("create child".equals(request.getType())) {
            if (request instanceof CreateViewRequest) {
                return this.getCreateCommand((CreateViewRequest)request);
            }
            return null;
        }
        return super.getCommand(request);
    }

    protected Object getConstraintFor(CreateRequest request) {
        Object constraint = super.getConstraintFor(request);
        if (LayoutHelper.UNDEFINED.getLocation().equals((Object)request.getLocation())) {
            Rectangle rect = (Rectangle)constraint;
            rect.setLocation(this.getLayoutHelper().getReferencePosition(this.getHostFigure()));
            Point point = this.getLayoutHelper().validatePosition(this.getHostFigure(), rect);
            rect.setLocation(point);
            return rect;
        }
        return constraint;
    }

    protected IFigure getHostFigure() {
        return this.getHost().getContentPane();
    }

    private LayoutHelper getLayoutHelper() {
        if (this.layoutHelper == null) {
            this.layoutHelper = new LayoutHelper();
        }
        return this.layoutHelper;
    }

    protected Command chainGuideAttachmentCommands(Request request, Command cmd) {
        ChangeGuideCommand cgm;
        Guide guide;
        Assert.isNotNull((Object)request);
        Assert.isNotNull((Object)cmd);
        EditPartViewer editPartViewer = this.getHost().getRoot().getViewer();
        Command result = cmd;
        CreateViewRequest req = (CreateViewRequest)request;
        TransactionalEditingDomain editingDomain = ((IGraphicalEditPart)this.getHost()).getEditingDomain();
        Integer guidePos = (Integer)request.getExtendedData().get("SnapToGuides.HorizontalGuide");
        if (guidePos != null) {
            int hAlignment = (Integer)request.getExtendedData().get("SnapToGuides.HorizontalAttachment");
            guide = this.findGuideAt(guidePos, true);
            for (IAdaptable iAdaptable : req.getViewDescriptors()) {
                cgm = new ChangeGuideCommand(editingDomain, editPartViewer, iAdaptable, true);
                cgm.setNewGuide(guide, hAlignment);
                result = result.chain((Command)new ICommandProxy((ICommand)cgm));
            }
        }
        if ((guidePos = (Integer)request.getExtendedData().get("SnapToGuides.VerticalGuide")) != null) {
            int vAlignment = (Integer)request.getExtendedData().get("SnapToGuides.VerticalAttachment");
            guide = this.findGuideAt(guidePos, false);
            for (IAdaptable iAdaptable : req.getViewDescriptors()) {
                cgm = new ChangeGuideCommand(editingDomain, editPartViewer, iAdaptable, false);
                cgm.setNewGuide(guide, vAlignment);
                result = result.chain((Command)new ICommandProxy((ICommand)cgm));
            }
        }
        return result;
    }

    protected Guide findGuideAt(int pos, boolean horizontal) {
        RulerProvider provider = (RulerProvider)this.getHost().getViewer().getProperty(horizontal ? "vertical ruler" : "horizontal ruler");
        IMapMode mm = MapModeUtil.getMapMode((IFigure)this.getHost().getFigure());
        return (Guide)provider.getGuideAt(mm.LPtoDP(pos));
    }

    public void eraseTargetFeedback(Request request) {
        super.eraseTargetFeedback(request);
        if ("drop".equals(request.getType())) {
            this.eraseLayoutTargetFeedback(request);
        }
    }
}

