/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.middleend.xtend.internal.types;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.uml2.uml.NamedElement;
import org.eclipse.uml2.uml.Stereotype;
import org.eclipse.xtend.backend.common.BackendType;
import org.eclipse.xtend.backend.common.BackendTypesystem;
import org.eclipse.xtend.backend.types.CompositeTypesystem;
import org.eclipse.xtend.backend.types.uml2.UmlTypesystem;
import org.eclipse.xtend.middleend.xtend.internal.types.TypeToBackendTypeMapper;
import org.eclipse.xtend.typesystem.Type;
import org.eclipse.xtend.typesystem.uml2.profile.EnumType;
import org.eclipse.xtend.typesystem.uml2.profile.MultipleStereotypeType;
import org.eclipse.xtend.typesystem.uml2.profile.StereotypeType;

public class UmlTypeToBackendTypeMapper
extends TypeToBackendTypeMapper {
    private static final Log _log = LogFactory.getLog(UmlTypeToBackendTypeMapper.class);
    private UmlTypesystem _umlTypes = null;

    public UmlTypeToBackendTypeMapper(BackendTypesystem ts) {
        try {
            if (ts instanceof UmlTypesystem) {
                this._umlTypes = (UmlTypesystem)ts;
            } else if (ts instanceof CompositeTypesystem) {
                for (BackendTypesystem bts : ((CompositeTypesystem)ts).getInner()) {
                    if (!(bts instanceof UmlTypesystem)) continue;
                    this._umlTypes = (UmlTypesystem)bts;
                }
            }
        }
        catch (Exception e) {
            _log.error((Object)"Check your project setup for typesystems", (Throwable)e);
        }
    }

    public BackendType convertToBackendType(Type t) {
        if (t instanceof StereotypeType) {
            return this.convertStereotypeType(t);
        }
        if (t instanceof MultipleStereotypeType) {
            return this.convertMultipleStereotypeType(t);
        }
        if (t instanceof EnumType) {
            return this.convertEnumType(t);
        }
        return null;
    }

    private BackendType convertEnumType(Type t) {
        if (t instanceof EnumType) {
            return this._umlTypes.findType((Object)((EnumType)t).getEnumeration());
        }
        return null;
    }

    private BackendType convertMultipleStereotypeType(Type t) {
        if (t instanceof StereotypeType) {
            List stTypes = ((MultipleStereotypeType)t).getStereotypes();
            ArrayList<Stereotype> st = new ArrayList<Stereotype>();
            for (StereotypeType stType : stTypes) {
                st.add(stType.getStereoType());
            }
            return this._umlTypes.findType(st);
        }
        return null;
    }

    private BackendType convertStereotypeType(Type t) {
        if (t instanceof StereotypeType) {
            Stereotype st = ((StereotypeType)t).getStereoType();
            return this._umlTypes.findType(UmlTypesystem.getUniqueIdentifier((NamedElement)st));
        }
        return null;
    }
}

