/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtend.backend.ui.builder;

import java.util.ArrayList;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNature;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;

public class BackendNature
implements IProjectNature {
    private static final Log _log = LogFactory.getLog(BackendNature.class);
    public static final String NATURE_ID = "org.eclipse.xtend.backend.BackendNature";
    private IProject project;

    public void configure() throws CoreException {
        ICommand[] commands;
        IProjectDescription desc = this.project.getDescription();
        ICommand[] iCommandArray = commands = desc.getBuildSpec();
        int n = commands.length;
        int n2 = 0;
        while (n2 < n) {
            ICommand command = iCommandArray[n2];
            if (command.getBuilderName().equals("org.eclipse.xtend.backend.compiler.BackendBuilder")) {
                return;
            }
            ++n2;
        }
        ICommand[] newCommands = new ICommand[commands.length + 1];
        System.arraycopy(commands, 0, newCommands, 0, commands.length);
        ICommand command = desc.newCommand();
        command.setBuilderName("org.eclipse.xtend.backend.compiler.BackendBuilder");
        newCommands[newCommands.length - 1] = command;
        desc.setBuildSpec(newCommands);
        this.project.setDescription(desc, null);
        IJavaProject jp = JavaCore.create((IProject)this.getProject());
        IFolder backendGenFolder = this.getProject().getFolder("backend-gen");
        if (!backendGenFolder.exists()) {
            try {
                backendGenFolder.create(true, true, null);
            }
            catch (CoreException e) {
                _log.error((Object)("Error creating folder " + backendGenFolder.getLocation().toOSString()));
            }
        }
        IClasspathEntry srcEntry = JavaCore.newSourceEntry((IPath)new Path("/" + this.getProject().getName() + "/" + "backend-gen"));
        IClasspathEntry[] oldEntries = jp.getRawClasspath();
        ArrayList<IClasspathEntry> entries = new ArrayList<IClasspathEntry>(oldEntries.length + 1);
        boolean hasBackendGenClasspathEntry = false;
        IClasspathEntry[] iClasspathEntryArray = oldEntries;
        int n3 = oldEntries.length;
        int n4 = 0;
        while (n4 < n3) {
            IClasspathEntry entry = iClasspathEntryArray[n4];
            entries.add(entry);
            if (entry.getPath().equals((Object)srcEntry.getPath())) {
                hasBackendGenClasspathEntry = true;
            }
            ++n4;
        }
        if (!hasBackendGenClasspathEntry) {
            entries.add(srcEntry);
            IClasspathEntry[] newClasspathEntries = entries.toArray(new IClasspathEntry[entries.size()]);
            try {
                jp.setRawClasspath(newClasspathEntries, null);
            }
            catch (CoreException e) {
                _log.error((Object)("Error adding " + backendGenFolder.getLocation().toOSString() + " to classpath"));
            }
        }
    }

    public void deconfigure() throws CoreException {
        IProjectDescription description = this.getProject().getDescription();
        ICommand[] commands = description.getBuildSpec();
        int i = 0;
        while (i < commands.length) {
            if (commands[i].getBuilderName().equals("org.eclipse.xtend.backend.compiler.BackendBuilder")) {
                ICommand[] newCommands = new ICommand[commands.length - 1];
                System.arraycopy(commands, 0, newCommands, 0, i);
                System.arraycopy(commands, i + 1, newCommands, i, commands.length - i - 1);
                description.setBuildSpec(newCommands);
                this.project.setDescription(description, null);
                return;
            }
            ++i;
        }
    }

    public IProject getProject() {
        return this.project;
    }

    public void setProject(IProject project) {
        this.project = project;
    }
}

