/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.papyrus.aas.tables.configurations.manager.cell;

import java.util.Collections;
import java.util.List;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.uml2.uml.Constraint;
import org.eclipse.uml2.uml.Element;
import org.eclipse.uml2.uml.Namespace;
import org.eclipse.uml2.uml.OpaqueBehavior;
import org.eclipse.uml2.uml.OpaqueExpression;
import org.eclipse.uml2.uml.Trigger;
import org.eclipse.uml2.uml.UMLFactory;
import org.eclipse.uml2.uml.UMLPackage;
import org.eclipse.uml2.uml.ValueSpecification;

public final class CodeSnippetUtils {
    private CodeSnippetUtils() {
    }

    public static Constraint createGuard(Namespace owner) {
        return CodeSnippetUtils.createGuard(owner, Collections.EMPTY_LIST);
    }

    public static Constraint createGuard(Namespace owner, List<Element> constrainedElements) {
        Constraint result = owner.createOwnedRule(null);
        result.getConstrainedElements().addAll(constrainedElements);
        result.setSpecification((ValueSpecification)CodeSnippetUtils.createOpaqueExpressionWithDefaultLanguage((Element)owner));
        return result;
    }

    public static Constraint getTriggerGuard(Trigger trigger) {
        List rules = (List)trigger.eContainer().eGet((EStructuralFeature)UMLPackage.Literals.NAMESPACE__OWNED_RULE);
        return rules.stream().filter(c -> c.getConstrainedElements().contains((Object)trigger)).findFirst().orElseGet(() -> null);
    }

    public static OpaqueExpression createOpaqueExpressionWithDefaultLanguage(Element context) {
        OpaqueExpression result = UMLFactory.eINSTANCE.createOpaqueExpression();
        result.getBodies().add((Object)"");
        return result;
    }

    public static OpaqueBehavior createOpaqueBehaviorWithDefaultLanguage(Element context) {
        OpaqueBehavior result = UMLFactory.eINSTANCE.createOpaqueBehavior();
        result.getBodies().add((Object)"");
        return result;
    }
}

